/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.migrationtools.tests.containers;

import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.ignite.migrationtools.tests.containers.Ignite2ClusterWithSamples;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.Assertions;
import org.testcontainers.containers.BindMode;
import org.testcontainers.containers.Container;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.Network;
import org.testcontainers.containers.output.OutputFrame;
import org.testcontainers.containers.wait.strategy.Wait;
import org.testcontainers.containers.wait.strategy.WaitStrategy;
import org.testcontainers.lifecycle.Startable;
import org.testcontainers.lifecycle.Startables;
import org.testcontainers.utility.MountableFile;

public class Ignite2ClusterContainer
implements Startable {
    private static final Logger LOGGER = LogManager.getLogger(Ignite2ClusterContainer.class);
    public final Network network;
    private final List<GenericContainer<?>> containers;

    public Ignite2ClusterContainer(Path cfgFilePath, Path storagePathOnHost, List<String> nodeIds) {
        this(Network.newNetwork(), cfgFilePath, storagePathOnHost, nodeIds);
    }

    public Ignite2ClusterContainer(Network network, Path cfgFilePath, Path storagePathOnHost, List<String> nodeIds) {
        this.network = network;
        this.containers = new ArrayList(nodeIds.size());
        for (int i = 0; i < nodeIds.size(); ++i) {
            String hostname = "node" + (1 + i);
            String nodeId = nodeIds.get(i);
            GenericContainer nodeContainer = Ignite2ClusterContainer.createIgnite2Container(network, hostname, nodeId, cfgFilePath, storagePathOnHost);
            this.containers.add(nodeContainer);
        }
        this.containers.get(0).withExposedPorts(new Integer[]{10800});
    }

    public Network getNetwork() {
        return this.network;
    }

    private static GenericContainer createIgnite2Container(Network network, String hostName, String nodeId, Path cfgFilePath, Path storagePathOnHost) {
        CheckpointerLogConsumer logConsumer = new CheckpointerLogConsumer();
        String heapSize = System.getProperty("ai2.sampleCluster.Xmx", "10g");
        String ignite2DockerImage = System.getProperty("ignite2.docker.image");
        assert (ignite2DockerImage != null) : "ignite2.docker.image must be defined";
        return new GenericContainer(ignite2DockerImage).withLabel("ai2.sample-cluster.node", hostName).withNetwork(network).withNetworkAliases(new String[]{hostName}).withCopyFileToContainer(MountableFile.forHostPath((Path)cfgFilePath), "/config-file.xml").withFileSystemBind(storagePathOnHost.toString(), "/storage", BindMode.READ_WRITE).withEnv("CONFIG_URI", "/config-file.xml").withEnv("IGNITE_WORK_DIR", "/storage").withEnv("IGNITE_QUIET", "false").withEnv("IGNITE_NODE_NAME", nodeId).withEnv("JVM_OPTS", String.format("-Xmx%s", heapSize)).withLogConsumer((Consumer)logConsumer).waitingFor((WaitStrategy)Wait.forLogMessage((String)".*Node started .*", (int)1));
    }

    public void start() {
        Startables.deepStart(this.containers).join();
    }

    public void stop() {
        this.doStop(true);
    }

    public void doStop(boolean waitForCheckpoints) {
        block7: {
            if (waitForCheckpoints) {
                try {
                    this.waitForNextCheckpoint();
                }
                catch (Exception ex) {
                    LOGGER.error("Error waiting for checkpoints: ", (Throwable)ex);
                    if (!(ex instanceof InterruptedException)) break block7;
                    Thread.currentThread().interrupt();
                }
            }
        }
        try {
            GenericContainer<?> firstContainer = this.containers.get(0);
            Container.ExecResult chmodOp = firstContainer.execInContainer(new String[]{"chmod", "-R", "777", "/storage"});
            ((AbstractIntegerAssert)Assertions.assertThat((int)chmodOp.getExitCode()).withFailMessage("CHMOD must be successfull", new Object[0])).isZero();
        }
        catch (IOException ex) {
            LOGGER.error("Error executing chmod", (Throwable)ex);
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            LOGGER.error("Interrupted while executing chmod", (Throwable)ex);
        }
        for (GenericContainer<?> node : this.containers) {
            node.stop();
        }
    }

    public void waitForNextCheckpoint() throws InterruptedException {
        LOGGER.info("Waiting for checkpoints to happen. This might take a while.");
        List nodeCheckpointCheckers = this.containers.stream().map(container -> {
            String nodeLabel = (String)container.getLabels().get("ai2.sample-cluster.node");
            CheckpointerLogConsumer logConsumer = (CheckpointerLogConsumer)container.getLogConsumers().get(0);
            AtomicBoolean checkpointFinished = new AtomicBoolean(false);
            Runnable onCheckpoint = () -> {
                LOGGER.info("Checkpoint finished on node: {}", (Object)nodeLabel);
                checkpointFinished.set(true);
            };
            logConsumer.onCheckpoint(onCheckpoint);
            return () -> {
                if (!container.isRunning() && checkpointFinished.compareAndSet(false, true)) {
                    LOGGER.warn("Container stopped running before the checkpoint was finished: {}", (Object)nodeLabel);
                }
                if (checkpointFinished.get()) {
                    logConsumer.removeListener(onCheckpoint);
                    return true;
                }
                return false;
            };
        }).collect(Collectors.toList());
        int maxWaitSeconds = Integer.parseInt(System.getProperty("ai2.sampleCluster.checkpointChecker.maxwaitseconds", "360"));
        int pollingSeconds = Integer.parseInt(System.getProperty("ai2.sampleCluster.checkpointChecker.pollingseconds", "10"));
        boolean success = Ignite2ClusterWithSamples.waitForCondition(() -> nodeCheckpointCheckers.stream().allMatch(BooleanSupplier::getAsBoolean), pollingSeconds * 1000, maxWaitSeconds * 1000);
        LOGGER.info("Finished waiting for checkpoints: {}", (Object)success);
    }

    private static class CheckpointerLogConsumer
    implements Consumer<OutputFrame> {
        private List<Runnable> listeners = new CopyOnWriteArrayList<Runnable>();

        private CheckpointerLogConsumer() {
        }

        @Override
        public void accept(OutputFrame frame) {
            String msg;
            if (this.listeners.isEmpty()) {
                return;
            }
            if ((frame.getType() == OutputFrame.OutputType.STDOUT || frame.getType() == OutputFrame.OutputType.STDERR) && ((msg = frame.getUtf8String()).contains("Checkpoint finished") || msg.contains("Skipping checkpoint (no pages were modified)"))) {
                for (Runnable listener : this.listeners) {
                    listener.run();
                }
            }
        }

        public void onCheckpoint(Runnable action) {
            this.listeners.add(action);
        }

        public void removeListener(Runnable action) {
            this.listeners.remove(action);
        }
    }
}

