/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.migrationtools.cli.sql.calls;

import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.migrationtools.cli.sql.commands.SqlDdlGeneratorCmd;
import org.apache.ignite.migrationtools.config.Ignite2ConfigurationUtils;
import org.apache.ignite.migrationtools.sql.SqlDdlGenerator;
import org.apache.ignite.migrationtools.tablemanagement.TableTypeRegistry;
import org.apache.ignite.migrationtools.tablemanagement.TableTypeRegistryMapImpl;
import org.apache.ignite3.catalog.definitions.TableDefinition;
import org.apache.ignite3.internal.cli.core.call.Call;
import org.apache.ignite3.internal.cli.core.call.CallInput;
import org.apache.ignite3.internal.cli.core.call.CallOutput;
import org.apache.ignite3.internal.cli.core.call.DefaultCallOutput;
import org.apache.ignite3.internal.cli.core.exception.IgniteCliException;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SqlDdlGeneratorCall
implements Call<Input, String> {
    private static final Logger LOGGER = LoggerFactory.getLogger(SqlDdlGeneratorCmd.class);

    public CallOutput<String> execute(Input i) {
        IgniteConfiguration cfg = Ignite2ConfigurationUtils.loadIgnite2Configuration((File)i.inputFilePath.toFile(), (boolean)true, (ClassLoader)i.classloader);
        CacheConfiguration[] loadedCacheCfgs = Optional.ofNullable(cfg.getCacheConfiguration()).orElse(new CacheConfiguration[0]);
        if (loadedCacheCfgs.length == 0) {
            LOGGER.error("Config file does not have any cache configurations: {}", (Object)i.inputFilePath);
            return DefaultCallOutput.failure((Throwable)new IgniteCliException("Config file does not have any cache configurations: " + String.valueOf(i.inputFilePath)));
        }
        List availableCaches = Arrays.stream(loadedCacheCfgs).filter(Objects::nonNull).collect(Collectors.toList());
        if (loadedCacheCfgs.length > availableCaches.size()) {
            String msg = String.format("Loaded %d caches out of %d. Check the errors for more information.", availableCaches.size(), loadedCacheCfgs.length);
            if (i.stopOnError) {
                return DefaultCallOutput.failure((Throwable)new IgniteCliException(msg));
            }
            LOGGER.warn(msg);
        }
        SqlDdlGenerator generator = new SqlDdlGenerator(i.classloader, (TableTypeRegistry)new TableTypeRegistryMapImpl(), i.allowExtraFields);
        ArrayList<TableDefinition> tableDefs = new ArrayList<TableDefinition>(availableCaches.size());
        for (CacheConfiguration cacheCfg : availableCaches) {
            try {
                TableDefinition def = generator.generateTableDefinition(cacheCfg);
                tableDefs.add(def);
            }
            catch (RuntimeException ex) {
                String msg = "Error while generating table definition for cache: " + cacheCfg.getName();
                if (i.stopOnError) {
                    return DefaultCallOutput.failure((Throwable)new IgniteCliException(msg, (Throwable)ex));
                }
                LOGGER.warn(msg, (Throwable)ex);
            }
        }
        LOGGER.info("Found definitions for {} caches", (Object)tableDefs.size());
        String ddlScript = SqlDdlGenerator.createDdlQuery(tableDefs);
        LOGGER.info("Finished generating script for caches");
        if (i.targetFilePath == null) {
            return DefaultCallOutput.success((Object)ddlScript);
        }
        try (BufferedWriter wr = Files.newBufferedWriter(i.targetFilePath, StandardCharsets.UTF_8, new OpenOption[0]);){
            wr.write(ddlScript);
        }
        catch (IOException e) {
            LOGGER.error("Error writing to the target file ({}) for writing", (Object)i.targetFilePath, (Object)e);
            return DefaultCallOutput.failure((Throwable)new IgniteCliException(String.format("Error writing to the target file ({}) for writing", i.targetFilePath), (Throwable)e));
        }
        return DefaultCallOutput.success((Object)"");
    }

    public static class Input
    implements CallInput {
        private Path inputFilePath;
        @Nullable
        private Path targetFilePath;
        private boolean stopOnError;
        private boolean allowExtraFields;
        private ClassLoader classloader;

        public Input(Path inputFilePath, @Nullable Path targetFilePath, boolean stopOnError, boolean allowExtraFields, ClassLoader classloader) {
            this.inputFilePath = inputFilePath;
            this.targetFilePath = targetFilePath;
            this.stopOnError = stopOnError;
            this.allowExtraFields = allowExtraFields;
            this.classloader = classloader;
        }
    }
}

