/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.migrationtools.cli.persistence.commands;

import java.util.ArrayList;
import java.util.concurrent.Callable;
import org.apache.commons.lang3.StringUtils;
import org.apache.ignite.migrationtools.cli.exceptions.DataStreamerExceptionHandler;
import org.apache.ignite.migrationtools.cli.exceptions.DefaultMigrateCacheExceptionHandler;
import org.apache.ignite.migrationtools.cli.exceptions.ErrorLoadingInputConfigurationHandlers;
import org.apache.ignite.migrationtools.cli.exceptions.IgniteClientConnectionExceptionHandler;
import org.apache.ignite.migrationtools.cli.persistence.calls.MigrateCacheCall;
import org.apache.ignite.migrationtools.cli.persistence.calls.RetriableMigrateCacheCall;
import org.apache.ignite.migrationtools.cli.persistence.commands.PersistenceBaseCmd;
import org.apache.ignite.migrationtools.cli.persistence.params.IgniteClientAuthenticatorParams;
import org.apache.ignite.migrationtools.cli.persistence.params.MigrateCacheParams;
import org.apache.ignite.migrationtools.cli.persistence.params.RetrieableMigrateCacheParams;
import org.apache.ignite3.internal.cli.commands.BaseCommand;
import org.apache.ignite3.internal.cli.core.call.Call;
import org.apache.ignite3.internal.cli.core.call.CallExecutionPipeline;
import org.apache.ignite3.internal.cli.core.call.CallExecutionPipelineBuilder;
import org.apache.ignite3.internal.cli.core.exception.ExceptionHandler;
import org.apache.ignite3.internal.cli.core.exception.ExceptionHandlers;
import org.apache.ignite3.internal.cli.core.exception.handler.DefaultExceptionHandlers;
import picocli.CommandLine;

@CommandLine.Command(name="migrate-cache", description={"Migrate a cache from a Ignite 2 work dir into a Ignite 3 cluster"})
public class MigrateCacheCmd
extends BaseCommand
implements Callable<Integer> {
    @CommandLine.ParentCommand
    private PersistenceBaseCmd parent;
    @CommandLine.Mixin
    private MigrateCacheParams migrateCacheParams;
    @CommandLine.Mixin
    private RetrieableMigrateCacheParams retryParams;
    @CommandLine.Mixin
    private IgniteClientAuthenticatorParams clientAuthenticatorParams;

    @Override
    public Integer call() throws Exception {
        MigrateCacheCall migrateCacheCall = new MigrateCacheCall();
        RetriableMigrateCacheCall call = new RetriableMigrateCacheCall(migrateCacheCall);
        return this.runPipeline((CallExecutionPipelineBuilder)CallExecutionPipeline.builder((Call)call).defaultExceptionHandler((ExceptionHandlers)new DefaultExceptionHandlers((ExceptionHandler)DefaultMigrateCacheExceptionHandler.INSTANCE)).exceptionHandler((ExceptionHandler)new IgniteClientConnectionExceptionHandler()).exceptionHandler((ExceptionHandler)new DataStreamerExceptionHandler()).exceptionHandlers(ErrorLoadingInputConfigurationHandlers.create()).inputProvider(() -> new RetriableMigrateCacheCall.Input(this.parent.params(), this.migrateCacheParams, this.retryParams, this.clientAuthenticatorParams)).decorator(ouput -> () -> {
            ArrayList<Object> parts = new ArrayList<Object>(2);
            if (StringUtils.isNotBlank((CharSequence)ouput.getMsg())) {
                parts.add(ouput.getMsg());
            }
            if (ouput.getProgressFilePath() != null) {
                parts.add("Progress File: " + String.valueOf(ouput.getProgressFilePath()));
            }
            return String.join((CharSequence)"\n", parts);
        }));
    }
}

