/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.ignite.migrationtools.adapter.internal.sql;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.ListIterator;
import org.apache.calcite.config.Lex;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlDataTypeSpec;
import org.apache.calcite.sql.SqlDelete;
import org.apache.calcite.sql.SqlDynamicParam;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlInsert;
import org.apache.calcite.sql.SqlIntervalQualifier;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlLiteral;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.calcite.sql.SqlSelect;
import org.apache.calcite.sql.SqlUpdate;
import org.apache.calcite.sql.parser.SqlParser;
import org.apache.calcite.sql.util.SqlVisitor;
import org.apache.ignite.internal.processors.query.calcite.sql.IgniteSqlConformance;
import org.apache.ignite.internal.processors.query.calcite.sql.generated.IgniteSqlParserImpl;

public class QueryTransformer
implements SqlVisitor<Object> {
    public static final SqlParser.Config SQL_PARSER_CONFIGURATION = SqlParser.config().withParserFactory(IgniteSqlParserImpl.FACTORY).withLex(Lex.ORACLE).withConformance(IgniteSqlConformance.INSTANCE);
    private final String tableName;
    private final String ai2Schema;
    private final String ai2CacheName;
    private final Deque<Boolean> ctxStack;
    private boolean hasRefTo_Key = false;
    private boolean hasRefTo_Val = false;

    public QueryTransformer(String tableName, String ai2Schema, String ai2CacheName) {
        this.tableName = tableName;
        this.ai2Schema = ai2Schema;
        this.ai2CacheName = ai2CacheName;
        this.ctxStack = new ArrayDeque<Boolean>();
        this.ctxStack.add(true);
    }

    public boolean hasRefTo_Key() {
        return this.hasRefTo_Key;
    }

    public boolean hasRefTo_Val() {
        return this.hasRefTo_Val;
    }

    public Object visit(SqlCall call) {
        SqlDelete casted;
        int operandCount = call.operandCount();
        SqlNode tableSubgraphRoot = null;
        SqlKind kind = call.getKind();
        if (SqlKind.SELECT.equals((Object)kind)) {
            SqlSelect selectCall = (SqlSelect)call;
            tableSubgraphRoot = selectCall.getFrom();
            --operandCount;
        } else if (SqlKind.DELETE.equals((Object)kind)) {
            casted = (SqlDelete)call;
            tableSubgraphRoot = casted.getTargetTable();
            --operandCount;
        } else if (SqlKind.INSERT.equals((Object)kind)) {
            casted = (SqlInsert)call;
            tableSubgraphRoot = casted.getTargetTable();
            --operandCount;
        } else if (SqlKind.UPDATE.equals((Object)kind)) {
            casted = (SqlUpdate)call;
            tableSubgraphRoot = casted.getTargetTable();
            --operandCount;
        }
        for (int i = 0; i < operandCount; ++i) {
            SqlNode node;
            SqlNode op = (SqlNode)call.getOperandList().get(i);
            if (op == null) continue;
            if (op == tableSubgraphRoot) {
                this.ctxStack.push(false);
                node = (SqlNode)op.accept((SqlVisitor)this);
                call.setOperand(i, node);
                this.ctxStack.pop();
                continue;
            }
            node = (SqlNode)op.accept((SqlVisitor)this);
            call.setOperand(i, node);
        }
        return call;
    }

    public Object visit(SqlNodeList list) {
        ListIterator it = list.listIterator();
        while (it.hasNext()) {
            SqlNode node = (SqlNode)it.next();
            SqlNode newNode = (SqlNode)node.accept((SqlVisitor)this);
            it.set(newNode);
        }
        return list;
    }

    public Object visit(SqlIdentifier identifier) {
        SqlIdentifier ret = identifier;
        int headIdx = identifier.names.size() - 1;
        if (!this.ctxStack.element().booleanValue()) {
            String schema = headIdx == 1 ? (String)identifier.names.get(0) : null;
            String tableName = (String)identifier.names.get(headIdx);
            if ((schema == null || this.ai2Schema.equals(schema)) && tableName.equalsIgnoreCase(this.ai2CacheName)) {
                ret = identifier.setName(headIdx, this.tableName);
            }
        } else {
            if (headIdx > 0) {
                this.ctxStack.push(false);
                SqlIdentifier tableIdentifier = (SqlIdentifier)this.visit(identifier.getComponent(0, headIdx));
                this.ctxStack.pop();
                for (int i = 0; i < tableIdentifier.names.size(); ++i) {
                    ret = identifier.setName(i, (String)tableIdentifier.names.get(i));
                }
            }
            String colName = (String)identifier.names.get(headIdx);
            this.hasRefTo_Key |= colName.equals("_KEY");
            this.hasRefTo_Val |= colName.equals("_VAL");
        }
        return ret;
    }

    public Object visit(SqlLiteral literal) {
        return literal;
    }

    public Object visit(SqlDataTypeSpec spec) {
        return spec;
    }

    public Object visit(SqlDynamicParam param) {
        return param;
    }

    public Object visit(SqlIntervalQualifier qualifier) {
        return qualifier;
    }
}

