/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.ignite.migrationtools.adapter.internal.mapper.converters;

import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import org.apache.ignite3.table.mapper.TypeConverter;
import org.gridgain.ignite.migrationtools.adapter.internal.mapper.converters.CalendarToInstantConverter;
import org.gridgain.ignite.migrationtools.adapter.internal.mapper.converters.CalendarToLocalDateTimeConverter;
import org.gridgain.ignite.migrationtools.adapter.internal.mapper.converters.DateToInstantConverter;
import org.gridgain.ignite.migrationtools.adapter.internal.mapper.converters.DateToLocalDateTimeConverter;
import org.gridgain.ignite.migrationtools.adapter.internal.mapper.converters.EnumToStringTypeConverter;
import org.gridgain.ignite.migrationtools.adapter.internal.mapper.converters.SqlDateToLocalDateConverter;
import org.gridgain.ignite.migrationtools.adapter.internal.mapper.converters.SqlTimeToLocalTimeConverter;
import org.gridgain.ignite.migrationtools.adapter.internal.mapper.converters.SqlTimestampToInstantConverter;
import org.gridgain.ignite.migrationtools.adapter.internal.mapper.converters.SqlTimestampToLocalDateTimeConverter;
import org.gridgain.ignite.migrationtools.adapter.internal.mapper.converters.TypeConverterFactory;
import org.jetbrains.annotations.Nullable;

public class StaticTypeConverterFactory
implements TypeConverterFactory {
    public static final TypeConverterFactory DEFAULT_INSTANCE = new StaticTypeConverterFactory();
    private static final Map<Map.Entry<Class<?>, Class<?>>, TypeConverter<?, ?>> CONVERTERS = new HashMap<Map.Entry<Class<Timestamp>, Class<LocalDateTime>>, SqlTimestampToLocalDateTimeConverter>(Map.of(Map.entry(Calendar.class, Instant.class), new CalendarToInstantConverter(), Map.entry(Calendar.class, LocalDateTime.class), new CalendarToLocalDateTimeConverter(), Map.entry(java.util.Date.class, Instant.class), new DateToInstantConverter(), Map.entry(java.util.Date.class, LocalDateTime.class), new DateToLocalDateTimeConverter(), Map.entry(Date.class, LocalDate.class), new SqlDateToLocalDateConverter(), Map.entry(Time.class, LocalTime.class), new SqlTimeToLocalTimeConverter(), Map.entry(Timestamp.class, Instant.class), new SqlTimestampToInstantConverter(), Map.entry(Timestamp.class, LocalDateTime.class), new SqlTimestampToLocalDateTimeConverter()));

    private StaticTypeConverterFactory() {
    }

    @Override
    @Nullable
    public <ObjectT, ColumnT> TypeConverter<? extends ObjectT, ? extends ColumnT> converterFor(Class<ObjectT> objType, Class<ColumnT> columnType) {
        return CONVERTERS.computeIfAbsent(Map.entry(objType, columnType), StaticTypeConverterFactory::tryCreateNewConverter);
    }

    @Nullable
    private static TypeConverter<?, ?> tryCreateNewConverter(Map.Entry<Class<?>, Class<?>> entry) {
        Class<?> objType = entry.getKey();
        if (objType.isEnum()) {
            return new EnumToStringTypeConverter(objType);
        }
        return null;
    }
}

