/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.ignite.migrationtools.adapter;

import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import org.apache.ignite.Ignite;
import org.apache.ignite.migrationtools.tablemanagement.PersistentTableTypeRegistryImpl;
import org.apache.ignite.migrationtools.tablemanagement.TableTypeRegistry;
import org.apache.ignite3.client.IgniteClient;
import org.apache.ignite3.compute.IgniteCompute;
import org.apache.ignite3.deployment.DeploymentUnit;
import org.apache.ignite3.network.IgniteCluster;
import org.gridgain.ignite.migrationtools.adapter.internal.ClientAdapter;
import org.gridgain.ignite.migrationtools.adapter.internal.mapper.MapperUtils;
import org.gridgain.ignite.migrationtools.adapter.internal.transactions.Ignite2TransactionAdapter;
import org.jetbrains.annotations.Nullable;

public interface IgniteAdapter {
    public static Builder builder(IgniteClient ignite3Client) {
        return new Builder(ignite3Client);
    }

    public static class Builder {
        private final IgniteClient ignite3Client;
        private TableTypeRegistry tableTypeRegistry;
        private boolean allowExtraFields;
        private boolean allowNonDefaultConstructors;
        @Nullable
        private Function<Class<?>, List<DeploymentUnit>> computeDeploymentUnitsSelector;

        public Builder(IgniteClient ignite3Client) {
            if (ignite3Client == null) {
                throw new IllegalArgumentException("ignite3Client must not be null");
            }
            this.ignite3Client = ignite3Client;
            this.tableTypeRegistry = new PersistentTableTypeRegistryImpl(ignite3Client);
            this.allowExtraFields = false;
            this.allowNonDefaultConstructors = false;
            this.computeDeploymentUnitsSelector = null;
        }

        public Builder tableTypeRegistry(TableTypeRegistry tableTypeRegistry) {
            if (tableTypeRegistry == null) {
                throw new IllegalArgumentException("tableTypeRegistry must not be null");
            }
            this.tableTypeRegistry = tableTypeRegistry;
            return this;
        }

        public Builder allowExtraFields(boolean allowExtraFields) {
            this.allowExtraFields = allowExtraFields;
            return this;
        }

        public Builder allowNonDefaultConstructors(boolean allowNonDefaultConstructors) {
            this.allowNonDefaultConstructors = allowNonDefaultConstructors;
            return this;
        }

        public Builder computeDeploymentUnitsSelector(@Nullable Function<Class<?>, List<DeploymentUnit>> selector) {
            this.computeDeploymentUnitsSelector = selector;
            return this;
        }

        public Ignite build() {
            MapperUtils mapperUtils = new MapperUtils(this.allowExtraFields, this.allowNonDefaultConstructors);
            ClientAdapter adapter = new ClientAdapter(this.ignite3Client, this.tableTypeRegistry, mapperUtils);
            Ignite2TransactionAdapter transactionAdapter = new Ignite2TransactionAdapter(this.ignite3Client.transactions());
            IgniteCompute computeApi = this.ignite3Client.compute();
            IgniteCluster clusterApi = this.ignite3Client.cluster();
            return new org.gridgain.ignite.migrationtools.adapter.internal.IgniteAdapter(adapter, transactionAdapter, computeApi, clusterApi, this.computeDeploymentUnitsSelector != null ? this.computeDeploymentUnitsSelector : c -> Collections.emptyList());
        }
    }
}

