/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.ignite.migrationtools.adapter.internal;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import javax.cache.configuration.CacheEntryListenerConfiguration;
import javax.cache.expiry.ExpiryPolicy;
import javax.cache.processor.EntryProcessor;
import javax.cache.processor.EntryProcessorException;
import javax.cache.processor.EntryProcessorResult;
import org.apache.ignite.cache.CachePeekMode;
import org.apache.ignite.cache.query.ContinuousQuery;
import org.apache.ignite.cache.query.FieldsQueryCursor;
import org.apache.ignite.cache.query.Query;
import org.apache.ignite.cache.query.QueryCursor;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.client.ClientCache;
import org.apache.ignite.client.ClientCacheConfiguration;
import org.apache.ignite.client.ClientDisconnectListener;
import org.apache.ignite.client.ClientException;
import org.apache.ignite.client.IgniteClientFuture;
import org.apache.ignite.internal.client.thin.IgniteClientFutureImpl;
import org.gridgain.ignite.migrationtools.adapter.internal.CacheAdapter;

public class ThinClientCacheAdapter<K, V>
implements ClientCache<K, V> {
    private final CacheAdapter<K, V> base;

    public ThinClientCacheAdapter(CacheAdapter<K, V> base) {
        this.base = base;
    }

    private static <T> IgniteClientFuture<T> wrapFuture(CompletableFuture<T> fut) {
        return new IgniteClientFutureImpl(fut);
    }

    private static <T> T block(CompletableFuture<T> fut) {
        try {
            return fut.get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ClientException((Throwable)e);
        }
        catch (ExecutionException e) {
            throw new ClientException((Throwable)e);
        }
    }

    public String getName() {
        return this.base.getName();
    }

    public ClientCacheConfiguration getConfiguration() throws ClientException {
        throw new UnsupportedOperationException();
    }

    public IgniteClientFuture<ClientCacheConfiguration> getConfigurationAsync() throws ClientException {
        throw new UnsupportedOperationException();
    }

    public V get(K key) throws ClientException {
        return ThinClientCacheAdapter.block(this.base.get(key));
    }

    public IgniteClientFuture<V> getAsync(K key) {
        return ThinClientCacheAdapter.wrapFuture(this.base.get(key));
    }

    public void put(K key, V val) throws ClientException {
        ThinClientCacheAdapter.block(this.base.put(key, val));
    }

    public IgniteClientFuture<Void> putAsync(K key, V val) throws ClientException {
        return ThinClientCacheAdapter.wrapFuture(this.base.put(key, val));
    }

    public boolean containsKey(K key) throws ClientException {
        return ThinClientCacheAdapter.block(this.base.containsKey(key));
    }

    public IgniteClientFuture<Boolean> containsKeyAsync(K key) throws ClientException {
        return ThinClientCacheAdapter.wrapFuture(this.base.containsKey(key));
    }

    public boolean containsKeys(Set<? extends K> keys) throws ClientException {
        return ThinClientCacheAdapter.block(this.base.containsKeys(keys));
    }

    public IgniteClientFuture<Boolean> containsKeysAsync(Set<? extends K> keys) throws ClientException {
        return ThinClientCacheAdapter.wrapFuture(this.base.containsKeys(keys));
    }

    public int size(CachePeekMode ... peekModes) throws ClientException {
        return Math.toIntExact(ThinClientCacheAdapter.block(this.base.size(peekModes)));
    }

    public IgniteClientFuture<Integer> sizeAsync(CachePeekMode ... peekModes) throws ClientException {
        return ThinClientCacheAdapter.wrapFuture(this.base.size(peekModes).thenApply(Math::toIntExact));
    }

    public Map<K, V> getAll(Set<? extends K> keys) throws ClientException {
        return ThinClientCacheAdapter.block(this.base.getAll(keys));
    }

    public IgniteClientFuture<Map<K, V>> getAllAsync(Set<? extends K> keys) throws ClientException {
        return ThinClientCacheAdapter.wrapFuture(this.base.getAll(keys));
    }

    public void putAll(Map<? extends K, ? extends V> map) throws ClientException {
        ThinClientCacheAdapter.block(this.base.putAll(map));
    }

    public IgniteClientFuture<Void> putAllAsync(Map<? extends K, ? extends V> map) throws ClientException {
        return ThinClientCacheAdapter.wrapFuture(this.base.putAll(map));
    }

    public boolean replace(K key, V oldVal, V newVal) throws ClientException {
        return ThinClientCacheAdapter.block(this.base.replace(key, oldVal, newVal));
    }

    public IgniteClientFuture<Boolean> replaceAsync(K key, V oldVal, V newVal) throws ClientException {
        return ThinClientCacheAdapter.wrapFuture(this.base.replace(key, oldVal, newVal));
    }

    public boolean replace(K key, V val) throws ClientException {
        return ThinClientCacheAdapter.block(this.base.replace(key, val));
    }

    public IgniteClientFuture<Boolean> replaceAsync(K key, V val) throws ClientException {
        return ThinClientCacheAdapter.wrapFuture(this.base.replace(key, val));
    }

    public boolean remove(K key) throws ClientException {
        return ThinClientCacheAdapter.block(this.base.remove(key));
    }

    public IgniteClientFuture<Boolean> removeAsync(K key) throws ClientException {
        return ThinClientCacheAdapter.wrapFuture(this.base.remove(key));
    }

    public boolean remove(K key, V oldVal) throws ClientException {
        return ThinClientCacheAdapter.block(this.base.remove(key, oldVal));
    }

    public IgniteClientFuture<Boolean> removeAsync(K key, V oldVal) throws ClientException {
        return ThinClientCacheAdapter.wrapFuture(this.base.remove(key, oldVal));
    }

    public void removeAll(Set<? extends K> keys) throws ClientException {
        ThinClientCacheAdapter.block(this.base.removeAll(keys));
    }

    public IgniteClientFuture<Void> removeAllAsync(Set<? extends K> keys) throws ClientException {
        return ThinClientCacheAdapter.wrapFuture(this.base.removeAll(keys));
    }

    public void removeAll() throws ClientException {
        ThinClientCacheAdapter.block(this.base.removeAll());
    }

    public IgniteClientFuture<Void> removeAllAsync() throws ClientException {
        return ThinClientCacheAdapter.wrapFuture(this.base.removeAll());
    }

    public V getAndPut(K key, V val) throws ClientException {
        return ThinClientCacheAdapter.block(this.base.getAndPut(key, val));
    }

    public IgniteClientFuture<V> getAndPutAsync(K key, V val) throws ClientException {
        return ThinClientCacheAdapter.wrapFuture(this.base.getAndPut(key, val));
    }

    public V getAndRemove(K key) throws ClientException {
        return ThinClientCacheAdapter.block(this.base.getAndRemove(key));
    }

    public IgniteClientFuture<V> getAndRemoveAsync(K key) throws ClientException {
        return ThinClientCacheAdapter.wrapFuture(this.base.getAndRemove(key));
    }

    public V getAndReplace(K key, V val) throws ClientException {
        return ThinClientCacheAdapter.block(this.base.getAndReplace(key, val));
    }

    public IgniteClientFuture<V> getAndReplaceAsync(K key, V val) throws ClientException {
        return ThinClientCacheAdapter.wrapFuture(this.base.getAndReplace(key, val));
    }

    public boolean putIfAbsent(K key, V val) throws ClientException {
        return ThinClientCacheAdapter.block(this.base.putIfAbsent(key, val));
    }

    public IgniteClientFuture<Boolean> putIfAbsentAsync(K key, V val) throws ClientException {
        return ThinClientCacheAdapter.wrapFuture(this.base.putIfAbsent(key, val));
    }

    public V getAndPutIfAbsent(K key, V val) throws ClientException {
        return ThinClientCacheAdapter.block(this.base.getAndPutIfAbsent(key, val));
    }

    public IgniteClientFuture<V> getAndPutIfAbsentAsync(K key, V val) throws ClientException {
        return ThinClientCacheAdapter.wrapFuture(this.base.getAndPutIfAbsent(key, val));
    }

    public void clear() throws ClientException {
        ThinClientCacheAdapter.block(this.base.clear());
    }

    public IgniteClientFuture<Void> clearAsync() throws ClientException {
        return ThinClientCacheAdapter.wrapFuture(this.base.clear());
    }

    public void clear(K key) throws ClientException {
        ThinClientCacheAdapter.block(this.base.clear(key));
    }

    public IgniteClientFuture<Void> clearAsync(K key) throws ClientException {
        return ThinClientCacheAdapter.wrapFuture(this.base.clear(key));
    }

    public void clearAll(Set<? extends K> keys) throws ClientException {
        ThinClientCacheAdapter.block(this.base.clearAll(keys));
    }

    public IgniteClientFuture<Void> clearAllAsync(Set<? extends K> keys) throws ClientException {
        return ThinClientCacheAdapter.wrapFuture(this.base.clearAll(keys));
    }

    public <T> T invoke(K k, EntryProcessor<K, V, T> entryProcessor, Object ... objects) throws EntryProcessorException, ClientException {
        throw new UnsupportedOperationException();
    }

    public <T> IgniteClientFuture<T> invokeAsync(K k, EntryProcessor<K, V, T> entryProcessor, Object ... objects) throws ClientException {
        throw new UnsupportedOperationException();
    }

    public <T> Map<K, EntryProcessorResult<T>> invokeAll(Set<? extends K> set, EntryProcessor<K, V, T> entryProcessor, Object ... objects) throws ClientException {
        throw new UnsupportedOperationException();
    }

    public <T> IgniteClientFuture<Map<K, EntryProcessorResult<T>>> invokeAllAsync(Set<? extends K> set, EntryProcessor<K, V, T> entryProcessor, Object ... objects) throws ClientException {
        throw new UnsupportedOperationException();
    }

    public <K1, V1> ClientCache<K1, V1> withKeepBinary() {
        throw new UnsupportedOperationException();
    }

    public <K1, V1> ClientCache<K1, V1> withExpirePolicy(ExpiryPolicy expiryPlc) {
        throw new UnsupportedOperationException();
    }

    public <K1, V1> ClientCache<K1, V1> withExpiryPolicy(ExpiryPolicy expiryPlc) {
        throw new UnsupportedOperationException();
    }

    public <R> QueryCursor<R> query(Query<R> qry) {
        return ThinClientCacheAdapter.block(this.base.query(qry));
    }

    public FieldsQueryCursor<List<?>> query(SqlFieldsQuery qry) {
        return this.base.query(qry);
    }

    public <R> QueryCursor<R> query(ContinuousQuery<K, V> qry, ClientDisconnectListener disconnectListener) {
        throw new UnsupportedOperationException();
    }

    public void registerCacheEntryListener(CacheEntryListenerConfiguration<K, V> cacheEntryListenerConfiguration) {
        throw new UnsupportedOperationException();
    }

    public void registerCacheEntryListener(CacheEntryListenerConfiguration<K, V> cacheEntryListenerConfiguration, ClientDisconnectListener disconnectListener) {
        throw new UnsupportedOperationException();
    }

    public void deregisterCacheEntryListener(CacheEntryListenerConfiguration<K, V> cacheEntryListenerConfiguration) {
        throw new UnsupportedOperationException();
    }
}

