/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.ignite.migrationtools.adapter.internal;

import java.io.Serializable;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.cache.Cache;
import javax.cache.CacheException;
import javax.cache.CacheManager;
import javax.cache.configuration.CacheEntryListenerConfiguration;
import javax.cache.configuration.Configuration;
import javax.cache.expiry.ExpiryPolicy;
import javax.cache.integration.CompletionListener;
import javax.cache.processor.EntryProcessor;
import javax.cache.processor.EntryProcessorException;
import javax.cache.processor.EntryProcessorResult;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.cache.CacheEntry;
import org.apache.ignite.cache.CacheEntryProcessor;
import org.apache.ignite.cache.CacheMetrics;
import org.apache.ignite.cache.CachePeekMode;
import org.apache.ignite.cache.query.Query;
import org.apache.ignite.cache.query.QueryCursor;
import org.apache.ignite.cache.query.QueryDetailMetrics;
import org.apache.ignite.cache.query.QueryMetrics;
import org.apache.ignite.cluster.ClusterGroup;
import org.apache.ignite.lang.IgniteBiPredicate;
import org.apache.ignite.lang.IgniteClosure;
import org.apache.ignite.lang.IgniteFuture;
import org.apache.ignite.lang.IgniteInClosure;
import org.apache.ignite.mxbean.CacheMetricsMXBean;
import org.apache.ignite.transactions.TransactionException;
import org.gridgain.ignite.migrationtools.adapter.internal.futures.IgniteFutureAdapter;
import org.gridgain.ignite.migrationtools.adapter.internal.sql.TransformedCursor;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractCacheAdapter<K, V>
implements IgniteCache<K, V> {
    public V get(K k) {
        return (V)this.getAsync(k).get();
    }

    public Map<K, V> getAll(Set<? extends K> set) {
        return (Map)this.getAllAsync(set).get();
    }

    public boolean containsKey(K k) {
        return (Boolean)this.containsKeyAsync(k).get();
    }

    public void put(K k, V v) {
        this.putAsync(k, v).get();
    }

    public V getAndPut(K k, V v) {
        return (V)this.getAndPutAsync(k, v).get();
    }

    public void putAll(Map<? extends K, ? extends V> map) {
        this.putAllAsync(map).get();
    }

    public boolean putIfAbsent(K k, V v) {
        return (Boolean)this.putIfAbsentAsync(k, v).get();
    }

    public boolean remove(K k) {
        return (Boolean)this.removeAsync(k).get();
    }

    public boolean remove(K k, V v) {
        return (Boolean)this.removeAsync(k, v).get();
    }

    public V getAndRemove(K k) {
        return (V)this.getAndRemoveAsync(k).get();
    }

    public boolean replace(K k, V v, V v1) {
        return (Boolean)this.replaceAsync(k, v, v1).get();
    }

    public boolean replace(K k, V v) {
        return (Boolean)this.replaceAsync(k, v).get();
    }

    public V getAndReplace(K k, V v) {
        return (V)this.getAndReplaceAsync(k, v).get();
    }

    public void removeAll(Set<? extends K> set) {
        this.removeAllAsync(set).get();
    }

    public void loadAll(Set<? extends K> set, boolean b, CompletionListener listener) {
        throw new UnsupportedOperationException();
    }

    public void removeAll() {
        this.removeAllAsync().get();
    }

    public void clear() {
        this.clearAsync().get();
    }

    public <C extends Configuration<K, V>> C getConfiguration(Class<C> klass) {
        throw new UnsupportedOperationException();
    }

    public CacheManager getCacheManager() {
        throw new UnsupportedOperationException();
    }

    public void close() {
    }

    public boolean isClosed() {
        return false;
    }

    public <T> T unwrap(Class<T> klass) {
        throw new UnsupportedOperationException();
    }

    public void registerCacheEntryListener(CacheEntryListenerConfiguration<K, V> configuration) {
        throw new UnsupportedOperationException();
    }

    public void deregisterCacheEntryListener(CacheEntryListenerConfiguration<K, V> configuration) {
        throw new UnsupportedOperationException();
    }

    public IgniteCache<K, V> withAsync() {
        throw new UnsupportedOperationException();
    }

    public boolean isAsync() {
        throw new UnsupportedOperationException();
    }

    public <R> IgniteFuture<R> future() {
        throw new UnsupportedOperationException();
    }

    public IgniteCache<K, V> withExpiryPolicy(ExpiryPolicy plc) {
        throw new UnsupportedOperationException();
    }

    public IgniteCache<K, V> withSkipStore() {
        throw new UnsupportedOperationException();
    }

    public IgniteCache<K, V> withNoRetries() {
        throw new UnsupportedOperationException();
    }

    public IgniteCache<K, V> withPartitionRecover() {
        throw new UnsupportedOperationException();
    }

    public <K1, V1> IgniteCache<K1, V1> withAllowAtomicOpsInTx() {
        throw new UnsupportedOperationException();
    }

    public void loadCache(@Nullable IgniteBiPredicate<K, V> p, Object ... args) throws CacheException {
        throw new UnsupportedOperationException();
    }

    public IgniteFuture<Void> loadCacheAsync(@Nullable IgniteBiPredicate<K, V> p, Object ... args) throws CacheException {
        throw new UnsupportedOperationException();
    }

    public void localLoadCache(@Nullable IgniteBiPredicate<K, V> p, Object ... args) throws CacheException {
        throw new UnsupportedOperationException();
    }

    public IgniteFuture<Void> localLoadCacheAsync(@Nullable IgniteBiPredicate<K, V> p, Object ... args) throws CacheException {
        throw new UnsupportedOperationException();
    }

    public V getAndPutIfAbsent(K key, V val) throws CacheException, TransactionException {
        return (V)this.getAndPutIfAbsentAsync(key, val).get();
    }

    public Lock lock(K key) {
        throw new UnsupportedOperationException();
    }

    public Lock lockAll(Collection<? extends K> keys) {
        throw new UnsupportedOperationException();
    }

    public boolean isLocalLocked(K key, boolean byCurrThread) {
        throw new UnsupportedOperationException();
    }

    public Iterable<Cache.Entry<K, V>> localEntries(CachePeekMode ... peekModes) throws CacheException {
        throw new UnsupportedOperationException();
    }

    public QueryMetrics queryMetrics() {
        throw new UnsupportedOperationException();
    }

    public void resetQueryMetrics() {
        throw new UnsupportedOperationException();
    }

    public Collection<? extends QueryDetailMetrics> queryDetailMetrics() {
        throw new UnsupportedOperationException();
    }

    public void resetQueryDetailMetrics() {
        throw new UnsupportedOperationException();
    }

    public void localEvict(Collection<? extends K> keys) {
        throw new UnsupportedOperationException();
    }

    public V localPeek(K key, CachePeekMode ... peekModes) {
        throw new UnsupportedOperationException();
    }

    public int size(CachePeekMode ... peekModes) throws CacheException {
        return (Integer)this.sizeAsync(new CachePeekMode[0]).get();
    }

    public IgniteFuture<Integer> sizeAsync(CachePeekMode ... peekModes) throws CacheException {
        return this.sizeLongAsync(peekModes).chain((IgniteClosure & Serializable)f -> Math.toIntExact((Long)f.get()));
    }

    public long sizeLong(CachePeekMode ... peekModes) throws CacheException {
        return (Long)this.sizeLongAsync(peekModes).get();
    }

    public long sizeLong(int partition, CachePeekMode ... peekModes) throws CacheException {
        return (Long)this.sizeLongAsync(partition, peekModes).get();
    }

    public IgniteFuture<Long> sizeLongAsync(int partition, CachePeekMode ... peekModes) throws CacheException {
        throw new UnsupportedOperationException();
    }

    public int localSize(CachePeekMode ... peekModes) {
        throw new UnsupportedOperationException();
    }

    public long localSizeLong(CachePeekMode ... peekModes) {
        throw new UnsupportedOperationException();
    }

    public long localSizeLong(int partition, CachePeekMode ... peekModes) {
        throw new UnsupportedOperationException();
    }

    public <T> Map<K, EntryProcessorResult<T>> invokeAll(Set<? extends K> keys, EntryProcessor<K, V, T> entryProcessor, Object ... args) throws TransactionException {
        return (Map)this.invokeAllAsync(keys, entryProcessor, args).get();
    }

    public <T> Map<K, EntryProcessorResult<T>> invokeAll(Map<? extends K, ? extends EntryProcessor<K, V, T>> map, Object ... args) throws TransactionException {
        return (Map)this.invokeAllAsync(map, args).get();
    }

    public <T> IgniteFuture<Map<K, EntryProcessorResult<T>>> invokeAllAsync(Map<? extends K, ? extends EntryProcessor<K, V, T>> map, Object ... args) throws TransactionException {
        ConcurrentHashMap<K, EntryProcessorResult> ret = new ConcurrentHashMap<K, EntryProcessorResult>(map.size());
        for (Map.Entry<K, EntryProcessor<K, V, T>> e : map.entrySet()) {
            K key = e.getKey();
            EntryProcessor<K, V, T> processor = e.getValue();
            IgniteFuture fut = this.invokeAsync(key, processor, args);
            ret.put(key, () -> ((IgniteFuture)fut).get());
        }
        return new IgniteFutureAdapter<Map<K, EntryProcessorResult<T>>>(CompletableFuture.completedFuture(ret));
    }

    public CacheEntry<K, V> getEntry(K key) throws TransactionException {
        return (CacheEntry)this.getEntryAsync(key).get();
    }

    public IgniteFuture<CacheEntry<K, V>> getEntryAsync(K key) throws TransactionException {
        return this.getAsync(key).chain((IgniteClosure & Serializable)f -> {
            Object val = f.get();
            if (val == null) {
                return null;
            }
            return new MyCacheEntry(key, val);
        });
    }

    public Collection<CacheEntry<K, V>> getEntries(Set<? extends K> keys) throws TransactionException {
        return (Collection)this.getEntriesAsync(keys).get();
    }

    public IgniteFuture<Collection<CacheEntry<K, V>>> getEntriesAsync(Set<? extends K> keys) throws TransactionException {
        return this.getAllAsync(keys).chain((IgniteClosure & Serializable)f -> ((Map)f.get()).entrySet().stream().map(e -> new MyCacheEntry(e.getKey(), e.getValue())).collect(Collectors.toList()));
    }

    public Map<K, V> getAllOutTx(Set<? extends K> keys) {
        throw new UnsupportedOperationException();
    }

    public IgniteFuture<Map<K, V>> getAllOutTxAsync(Set<? extends K> keys) {
        throw new UnsupportedOperationException();
    }

    public boolean containsKeys(Set<? extends K> keys) throws TransactionException {
        return (Boolean)this.containsKeysAsync(keys).get();
    }

    public IgniteFuture<Boolean> containsKeysAsync(Set<? extends K> keys) throws TransactionException {
        if (keys.isEmpty()) {
            throw new IllegalArgumentException("Must provide at least one key");
        }
        AtomicInteger n = new AtomicInteger(keys.size());
        CompletableFuture ret = new CompletableFuture();
        for (K key : keys) {
            IgniteFuture f = this.containsKeyAsync(key);
            f.listen((IgniteInClosure & Serializable)theFuture -> {
                int remainingFutures;
                Boolean hasKey = (Boolean)theFuture.get();
                if (!hasKey.booleanValue()) {
                    ret.complete(false);
                }
                if ((remainingFutures = n.decrementAndGet()) == 0 && hasKey.booleanValue()) {
                    ret.complete(true);
                }
            });
        }
        return new IgniteFutureAdapter<Boolean>(ret);
    }

    public void clear(K key) {
        this.clearAsync(key).get();
    }

    public void clearAll(Set<? extends K> keys) {
        this.clearAllAsync(keys).get();
    }

    public void localClear(K key) {
        throw new UnsupportedOperationException();
    }

    public void localClearAll(Set<? extends K> keys) {
        throw new UnsupportedOperationException();
    }

    public <T> T invoke(K key, EntryProcessor<K, V, T> entryProcessor, Object ... objects) throws EntryProcessorException {
        return (T)this.invokeAsync(key, entryProcessor, objects).get();
    }

    public <T> T invoke(K key, CacheEntryProcessor<K, V, T> entryProcessor, Object ... arguments) throws TransactionException {
        return (T)this.invokeAsync(key, (EntryProcessor)entryProcessor, arguments).get();
    }

    public <T> IgniteFuture<T> invokeAsync(K key, CacheEntryProcessor<K, V, T> entryProcessor, Object ... arguments) throws TransactionException {
        return this.invokeAsync(key, (EntryProcessor)entryProcessor, arguments);
    }

    public <T> IgniteFuture<Map<K, EntryProcessorResult<T>>> invokeAllAsync(Set<? extends K> keys, EntryProcessor<K, V, T> entryProcessor, Object ... args) throws TransactionException {
        Map req = keys.stream().collect(Collectors.toMap(Function.identity(), k -> entryProcessor));
        return this.invokeAllAsync(req, args);
    }

    public <T> Map<K, EntryProcessorResult<T>> invokeAll(Set<? extends K> keys, CacheEntryProcessor<K, V, T> entryProcessor, Object ... args) throws TransactionException {
        return (Map)this.invokeAllAsync(keys, entryProcessor, args).get();
    }

    public <T> IgniteFuture<Map<K, EntryProcessorResult<T>>> invokeAllAsync(Set<? extends K> keys, CacheEntryProcessor<K, V, T> entryProcessor, Object ... args) throws TransactionException {
        Map req = keys.stream().collect(Collectors.toMap(Function.identity(), k -> entryProcessor));
        return this.invokeAllAsync(req, args);
    }

    public IgniteFuture<Boolean> rebalance() {
        throw new UnsupportedOperationException();
    }

    public IgniteFuture<?> indexReadyFuture() {
        throw new UnsupportedOperationException();
    }

    public CacheMetrics metrics() {
        throw new UnsupportedOperationException();
    }

    public CacheMetrics metrics(ClusterGroup grp) {
        throw new UnsupportedOperationException();
    }

    public CacheMetrics localMetrics() {
        throw new UnsupportedOperationException();
    }

    public Collection<Integer> lostPartitions() {
        throw new UnsupportedOperationException();
    }

    public void enableStatistics(boolean enabled) {
        throw new UnsupportedOperationException();
    }

    public void clearStatistics() {
        throw new UnsupportedOperationException();
    }

    public void preloadPartition(int partition) {
        throw new UnsupportedOperationException();
    }

    public IgniteFuture<Void> preloadPartitionAsync(int partition) {
        throw new UnsupportedOperationException();
    }

    public boolean localPreloadPartition(int partition) {
        throw new UnsupportedOperationException();
    }

    public CacheMetricsMXBean mxBean() {
        throw new UnsupportedOperationException();
    }

    public CacheMetricsMXBean localMxBean() {
        throw new UnsupportedOperationException();
    }

    public int localEntrySize(K k) {
        throw new UnsupportedOperationException();
    }

    public boolean touch(K k) {
        throw new UnsupportedOperationException();
    }

    public IgniteFuture<Boolean> touchAsync(K key) {
        return null;
    }

    public <T, R> QueryCursor<R> query(Query<T> qry, IgniteClosure<T, R> transformer) {
        QueryCursor cursor = this.query(qry);
        return new TransformedCursor<T, R>(cursor, transformer);
    }

    protected class MyCacheEntry
    implements CacheEntry<K, V> {
        private final K key;
        private final V val;

        public MyCacheEntry(K key, V val) {
            this.key = key;
            this.val = val;
        }

        public Comparable version() {
            throw new UnsupportedOperationException();
        }

        public K getKey() {
            return this.key;
        }

        public V getValue() {
            return this.val;
        }

        public <T> T unwrap(Class<T> clazz) {
            if (clazz == MyCacheEntry.class) {
                return (T)this;
            }
            throw new IllegalArgumentException("Only " + MyCacheEntry.class.getName() + " is supported.");
        }
    }
}

