/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.ignite.migrationtools.adapter;

import org.apache.ignite.migrationtools.tablemanagement.PersistentTableTypeRegistryImpl;
import org.apache.ignite.migrationtools.tablemanagement.TableTypeRegistry;
import org.apache.ignite3.client.IgniteClient;
import org.gridgain.ignite.migrationtools.adapter.internal.ClientAdapter;
import org.gridgain.ignite.migrationtools.adapter.internal.mapper.MapperUtils;

public interface IgniteClientAdapter {
    public static Builder builder(IgniteClient ignite3Client) {
        return new Builder(ignite3Client);
    }

    public static class Builder {
        private final IgniteClient ignite3Client;
        private TableTypeRegistry tableTypeRegistry;
        private boolean allowExtraFields;
        private boolean allowNonDefaultConstructors;

        public Builder(IgniteClient ignite3Client) {
            if (ignite3Client == null) {
                throw new IllegalArgumentException("ignite3Client must not be null");
            }
            this.ignite3Client = ignite3Client;
            this.tableTypeRegistry = new PersistentTableTypeRegistryImpl(ignite3Client);
            this.allowExtraFields = false;
            this.allowNonDefaultConstructors = false;
        }

        public Builder tableTypeRegistry(TableTypeRegistry tableTypeRegistry) {
            if (tableTypeRegistry == null) {
                throw new IllegalArgumentException("tableTypeRegistry must not be null");
            }
            this.tableTypeRegistry = tableTypeRegistry;
            return this;
        }

        public Builder allowExtraFields(boolean allowExtraFields) {
            this.allowExtraFields = allowExtraFields;
            return this;
        }

        public Builder allowNonDefaultConstructors(boolean allowNonDefaultConstructors) {
            this.allowNonDefaultConstructors = allowNonDefaultConstructors;
            return this;
        }

        public org.apache.ignite.client.IgniteClient build() {
            MapperUtils mapperUtils = new MapperUtils(this.allowExtraFields, this.allowNonDefaultConstructors);
            ClientAdapter adapter = new ClientAdapter(this.ignite3Client, this.tableTypeRegistry, mapperUtils);
            return new org.gridgain.ignite.migrationtools.adapter.internal.IgniteClientAdapter(adapter);
        }
    }
}

