/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.marshaller;

import java.util.Collection;
import java.util.Objects;
import java.util.TreeSet;
import org.apache.ignite3.internal.marshaller.BinaryMode;
import org.apache.ignite3.internal.marshaller.ExtraFieldsAccesor;
import org.apache.ignite3.internal.marshaller.FieldAccessor;
import org.apache.ignite3.internal.marshaller.Marshaller;
import org.apache.ignite3.internal.marshaller.MarshallerColumn;
import org.apache.ignite3.internal.marshaller.MarshallerReader;
import org.apache.ignite3.internal.marshaller.MarshallerWriter;
import org.apache.ignite3.internal.marshaller.UnmappedColumnsException;
import org.apache.ignite3.internal.util.Factory;
import org.apache.ignite3.internal.util.ObjectFactory;
import org.apache.ignite3.lang.MarshallerException;
import org.apache.ignite3.table.mapper.PojoMapper;
import org.apache.ignite3.table.mapper.TypeConverter;
import org.gridgain.ignite.migrationtools.adapter.internal.mapper.ExtendedPojoMapper;
import org.jetbrains.annotations.Nullable;

public class ExtendedMarshallerFactory {
    public static PojoMarshaller pojoMarshaller(MarshallerColumn[] cols, PojoMapper<?> mapper, boolean requireAllFields, boolean allowUnmappedFields) {
        Collection fields;
        FieldAccessor[] fieldAccessors = new FieldAccessor[cols.length];
        int usedFields = 0;
        ExtendedPojoMapper extendedMapper = mapper instanceof ExtendedPojoMapper ? (ExtendedPojoMapper)mapper : null;
        for (int i = 0; i < cols.length; ++i) {
            MarshallerColumn col = cols[i];
            String columnName = col.name();
            String fieldName = mapper.fieldForColumn(columnName);
            if ("__EXTRA__".equals(columnName) && extendedMapper != null) {
                ++usedFields;
                fieldAccessors[i] = extendedMapper.hasExtraFields() ? new ExtraFieldsAccesor(extendedMapper.extraFields(), i, BinaryMode.POJO) : FieldAccessor.noopAccessor((MarshallerColumn)col);
                continue;
            }
            if (fieldName == null) {
                if (requireAllFields) {
                    throw new IllegalArgumentException(String.format("No mapped object field found for column '%s'", columnName));
                }
                fieldAccessors[i] = FieldAccessor.noopAccessor((MarshallerColumn)col);
                continue;
            }
            ++usedFields;
            TypeConverter converter = mapper.converterForColumn(columnName);
            fieldAccessors[i] = FieldAccessor.create((Class)mapper.targetType(), (String)fieldName, (MarshallerColumn)col, (int)i, (TypeConverter)converter);
        }
        if (!allowUnmappedFields && (fields = mapper.fields()).size() > usedFields) {
            TreeSet fieldSet = new TreeSet(fields);
            for (MarshallerColumn col : cols) {
                String fieldName = mapper.fieldForColumn(col.name());
                fieldSet.remove(fieldName);
            }
            throw new IllegalArgumentException(String.format("Fields %s of type %s are not mapped to columns", fieldSet, mapper.targetType().getName()), (Throwable)new UnmappedColumnsException());
        }
        ObjectFactory factory = extendedMapper != null && extendedMapper.getFactory() != null ? extendedMapper.getFactory() : new ObjectFactory(mapper.targetType());
        return new PojoMarshaller((Factory<?>)factory, fieldAccessors);
    }

    private static class PojoMarshaller
    extends Marshaller {
        private final FieldAccessor[] fieldAccessors;
        private final Factory<?> factory;

        PojoMarshaller(Factory<?> factory, FieldAccessor[] fieldAccessors) {
            this.fieldAccessors = fieldAccessors;
            this.factory = Objects.requireNonNull(factory);
        }

        @Nullable
        public Object value(Object obj, int fldIdx) {
            return this.fieldAccessors[fldIdx].value(obj);
        }

        public Object readObject(MarshallerReader reader, Object target) throws MarshallerException {
            Object obj = target == null ? this.factory.create() : target;
            for (int fldIdx = 0; fldIdx < this.fieldAccessors.length; ++fldIdx) {
                this.fieldAccessors[fldIdx].read(reader, obj);
            }
            return obj;
        }

        public void writeObject(@Nullable Object obj, MarshallerWriter writer) throws MarshallerException {
            for (int fldIdx = 0; fldIdx < this.fieldAccessors.length; ++fldIdx) {
                this.fieldAccessors[fldIdx].write(writer, obj);
            }
        }

        public void writeField(@Nullable Object obj, MarshallerWriter writer, int fldIdx) throws MarshallerException {
            this.fieldAccessors[fldIdx].write(writer, obj);
        }
    }
}

