/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.ignite.migrationtools.adapter.internal.sql;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;
import org.apache.ignite.cache.query.FieldsQueryCursor;
import org.apache.ignite3.sql.ColumnMetadata;
import org.apache.ignite3.sql.ResultSet;
import org.apache.ignite3.sql.SqlRow;
import org.apache.ignite3.table.mapper.TypeConverter;
import org.gridgain.ignite.migrationtools.adapter.internal.mapper.converters.IdentityConverter;

public class FieldsQueryCursorImpl
implements FieldsQueryCursor<List<?>> {
    private final ResultSet<SqlRow> results;
    private final String[] colNames;
    private final TypeConverter[] converters;

    public FieldsQueryCursorImpl(ResultSet<SqlRow> results, Function<String, TypeConverter<?, ?>> fieldConverter) {
        this.results = results;
        if (results.hasRowSet()) {
            List columnsMeta = results.metadata().columns();
            int nColumns = columnsMeta.size();
            this.colNames = new String[nColumns];
            this.converters = new TypeConverter[nColumns];
            for (int i = 0; i < nColumns; ++i) {
                ColumnMetadata colMeta = (ColumnMetadata)columnsMeta.get(i);
                TypeConverter<?, ?> converter = fieldConverter.apply(colMeta.name());
                this.colNames[i] = colMeta.name();
                this.converters[i] = converter != null ? converter : IdentityConverter.INSTANCE;
            }
        } else {
            this.colNames = new String[0];
            this.converters = new TypeConverter[0];
        }
    }

    public String getFieldName(int idx) {
        if (!this.results.hasRowSet()) {
            throw new UnsupportedOperationException("Cannot getFieldName on an empty result set.");
        }
        return this.colNames[idx];
    }

    public int getColumnsCount() {
        if (!this.results.hasRowSet()) {
            throw new UnsupportedOperationException("Cannot getColumnsCount on an empty result set.");
        }
        return this.colNames.length;
    }

    public List<List<?>> getAll() {
        ArrayList ret = new ArrayList();
        Iterator<List<?>> iterator = this.iterator();
        while (iterator.hasNext()) {
            List<?> objects = iterator.next();
            ret.add(objects);
        }
        return ret;
    }

    public void close() {
        this.results.close();
    }

    public Iterator<List<?>> iterator() {
        if (!this.results.hasRowSet()) {
            return Collections.emptyIterator();
        }
        final int expectedSize = this.getColumnsCount();
        return new Iterator<List<?>>(){

            @Override
            public boolean hasNext() {
                return FieldsQueryCursorImpl.this.results.hasNext();
            }

            @Override
            public List<?> next() {
                SqlRow row = (SqlRow)FieldsQueryCursorImpl.this.results.next();
                ArrayList<Object> retList = new ArrayList<Object>(expectedSize);
                for (int i = 0; i < expectedSize; ++i) {
                    Object o = row.value(i);
                    try {
                        Object t = o != null ? FieldsQueryCursorImpl.this.converters[i].toObjectType(o) : null;
                        retList.add(t);
                        continue;
                    }
                    catch (Exception ex) {
                        throw new RuntimeException(ex);
                    }
                }
                return retList;
            }
        };
    }
}

