/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.table.mapper;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import org.apache.ignite3.internal.util.Factory;
import org.apache.ignite3.table.mapper.Mapper;
import org.apache.ignite3.table.mapper.MapperBuilder;
import org.apache.ignite3.table.mapper.PojoMapper;
import org.apache.ignite3.table.mapper.TypeConverter;
import org.gridgain.ignite.migrationtools.adapter.internal.mapper.ExtendedPojoMapper;
import org.gridgain.ignite.migrationtools.adapter.internal.mapper.UnsafeObjectFactory;
import org.jetbrains.annotations.Nullable;

public class ExtendedMapperBuilder<T> {
    private static final Field targetTypeField;
    private final MapperBuilder<T> builder;
    @Nullable
    private final Factory<T> factory;
    private final Map<Field, String> extraFields;
    private boolean withExtraFields;

    private ExtendedMapperBuilder(MapperBuilder<T> builder, Factory<T> factory) {
        this.builder = builder;
        this.factory = factory;
        this.extraFields = new HashMap<Field, String>();
    }

    public MapperBuilder<T> map(String fieldName, String columnName, String ... fieldColumnPairs) {
        return this.builder.map(fieldName, columnName, fieldColumnPairs);
    }

    public <ObjectT, ColumnT> MapperBuilder<T> map(String fieldName, String columnName, TypeConverter<ObjectT, ColumnT> converter) {
        return this.builder.map(fieldName, columnName, converter);
    }

    public ExtendedMapperBuilder<T> mapExtraField(Field field) {
        String columnName = field.getName();
        this.extraFields.put(field, columnName);
        return this;
    }

    public ExtendedMapperBuilder<T> enableExtraFields(boolean val) {
        this.withExtraFields = val;
        return this;
    }

    public Mapper<T> build() {
        PojoMapper baseMapper = (PojoMapper)this.builder.build();
        if (!this.withExtraFields && this.factory == null) {
            return baseMapper;
        }
        return new ExtendedPojoMapper<T>(baseMapper, this.extraFields, this.factory);
    }

    public static <T> ExtendedMapperBuilder<T> create(Class<T> targetCls, boolean allowMissingDfltConstructor) {
        try {
            MapperBuilder builder = new MapperBuilder(targetCls);
            return new ExtendedMapperBuilder<T>(builder, null);
        }
        catch (IllegalArgumentException e) {
            if (!(allowMissingDfltConstructor && e.getMessage().equals("Class has no default constructor: class=" + targetCls.getName()) && e.getMessage().equals("Could not find default (no-args) or canonical (record) constructor for class " + targetCls.getName()))) {
                throw e;
            }
            MapperBuilder builder = new MapperBuilder(Object.class);
            try {
                targetTypeField.set(builder, targetCls);
            }
            catch (IllegalAccessException ex) {
                throw new RuntimeException("Unexpected fatal exception", ex);
            }
            return new ExtendedMapperBuilder<T>(builder, new UnsafeObjectFactory<T>(targetCls));
        }
    }

    static {
        try {
            targetTypeField = MapperBuilder.class.getDeclaredField("targetType");
            targetTypeField.setAccessible(true);
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
    }
}

