/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.marshaller;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.NotImplementedException;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.apache.ignite3.internal.marshaller.BinaryMode;
import org.apache.ignite3.internal.marshaller.FieldAccessor;
import org.apache.ignite3.internal.marshaller.MarshallerReader;
import org.apache.ignite3.internal.marshaller.MarshallerWriter;
import org.jetbrains.annotations.Nullable;

public class ExtraFieldsAccesor
extends FieldAccessor {
    private final Map<Field, String> unmappedFields;
    private final ObjectMapper objectMapper;

    public ExtraFieldsAccesor(Map<Field, String> unmappedFields, int colIdx, BinaryMode mode) {
        super(colIdx, mode);
        this.unmappedFields = unmappedFields;
        this.objectMapper = new ObjectMapper();
        this.objectMapper.configure(MapperFeature.ACCEPT_CASE_INSENSITIVE_PROPERTIES, true);
        this.objectMapper.setVisibility(PropertyAccessor.FIELD, JsonAutoDetect.Visibility.ANY);
    }

    void write0(MarshallerWriter writer, @Nullable Object o) throws Exception {
        HashMap<String, Object> values = new HashMap<String, Object>();
        for (Map.Entry<Field, String> entry : this.unmappedFields.entrySet()) {
            Field field = entry.getKey();
            String fieldName = entry.getValue();
            Object val = FieldUtils.readField((Field)field, (Object)o);
            values.put(fieldName, val);
        }
        byte[] data = this.objectMapper.writeValueAsBytes(values);
        writer.writeBytes(data);
    }

    Object read(MarshallerReader marshallerReader) {
        throw new NotImplementedException();
    }

    void read0(MarshallerReader reader, Object o) {
        try {
            byte[] bytes = reader.readBytes();
            JsonNode root = this.objectMapper.readTree(bytes);
            for (Map.Entry<Field, String> entry : this.unmappedFields.entrySet()) {
                Field field = entry.getKey();
                String fieldName = entry.getValue();
                ObjectReader nodeReader = this.objectMapper.readerFor(field.getType());
                JsonNode fieldNode = root.get(fieldName);
                Object val = fieldNode != null ? nodeReader.readValue(fieldNode) : null;
                FieldUtils.writeField((Field)field, (Object)o, (Object)val);
            }
        }
        catch (IOException | IllegalAccessException e) {
            throw new IllegalArgumentException(e);
        }
    }

    Object value(Object o) {
        throw new NotImplementedException();
    }

    void set(Object o, Object o1) {
        throw new NotImplementedException();
    }
}

