/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.ignite.migrationtools.adapter.internal.mapper.converters;

import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.Calendar;
import java.util.GregorianCalendar;
import org.apache.ignite3.table.mapper.TypeConverter;

public class CalendarToLocalDateTimeConverter
implements TypeConverter<Calendar, LocalDateTime> {
    public LocalDateTime toColumnType(Calendar calendar) throws Exception {
        return LocalDateTime.ofInstant(calendar.toInstant(), ZoneOffset.UTC);
    }

    public Calendar toObjectType(LocalDateTime dateTime) throws Exception {
        return GregorianCalendar.from(ZonedDateTime.of(dateTime, ZoneOffset.UTC));
    }
}

