/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.ignite.migrationtools.adapter.internal.mapper;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.ignite.migrationtools.types.InspectedField;
import org.apache.ignite.migrationtools.types.TypeInspector;
import org.apache.ignite3.internal.client.proto.TuplePart;
import org.apache.ignite3.internal.client.table.ClientColumn;
import org.apache.ignite3.internal.client.table.ClientSchema;
import org.apache.ignite3.table.mapper.ExtendedMapperBuilder;
import org.apache.ignite3.table.mapper.Mapper;
import org.apache.ignite3.table.mapper.MapperBuilder;
import org.apache.ignite3.table.mapper.OneColumnMapper;
import org.apache.ignite3.table.mapper.TypeConverter;
import org.gridgain.ignite.migrationtools.adapter.internal.converters.JsonBytesTypeConverter;
import org.gridgain.ignite.migrationtools.adapter.internal.mapper.converters.StaticTypeConverterFactory;
import org.gridgain.ignite.migrationtools.adapter.internal.mapper.converters.TypeConverterFactory;
import org.gridgain.ignite.migrationtools.adapter.internal.mapper.exceptions.UnableToCreateMapperException;
import org.jetbrains.annotations.Nullable;

public class MapperUtils {
    private static final Constructor<OneColumnMapper<?>> ONE_COLUMN_MAPPER_CONSTRUCTOR;
    private static final Method GET_COLUMN_TO_FIELD_MAPPING;
    private final TypeConverterFactory typeConverterFactory;
    private final boolean allowExtraFields;
    private final boolean allowMissingDfltConstructor;

    public MapperUtils(boolean allowExtraFields, boolean allowMissingDfltConstructor) {
        this(StaticTypeConverterFactory.DEFAULT_INSTANCE, allowExtraFields, allowMissingDfltConstructor);
    }

    public MapperUtils(TypeConverterFactory typeConverterFactory, boolean allowExtraFields, boolean allowMissingDfltConstructor) {
        this.typeConverterFactory = typeConverterFactory;
        this.allowExtraFields = allowExtraFields;
        this.allowMissingDfltConstructor = allowMissingDfltConstructor;
    }

    public boolean allowsExtraFields() {
        return this.allowExtraFields;
    }

    public boolean allowsMissingDfltConstructor() {
        return this.allowMissingDfltConstructor;
    }

    public Mapper<?> createMapper(ClientSchema latestSchema, Class<?> klass, TuplePart tuplePart, Map<String, String> fieldNameToColumnsMapping) throws UnableToCreateMapperException {
        if (Mapper.nativelySupported(klass)) {
            ClientColumn[] columns = latestSchema.columns(tuplePart);
            assert (columns.length == 1);
            String columnName = columns[0].name();
            return Mapper.of(klass, (String)columnName);
        }
        if (klass.isArray() || Collection.class.isAssignableFrom(klass)) {
            return MapperUtils.createJsonColumnMapper(klass);
        }
        ExtendedMapperBuilder<?> builder = ExtendedMapperBuilder.create(klass, this.allowMissingDfltConstructor);
        boolean schemaHasExtraColumn = false;
        List inspectedFields = TypeInspector.inspectType(klass);
        ClientColumn[] columns = latestSchema.columns(tuplePart);
        for (ClientColumn c : columns) {
            Class<?> fieldType;
            if ("__EXTRA__".equals(c.name())) {
                schemaHasExtraColumn = true;
                builder.enableExtraFields(true);
                continue;
            }
            String fieldName = fieldNameToColumnsMapping.entrySet().stream().filter(e -> ((String)e.getKey()).equalsIgnoreCase(c.name())).map(Map.Entry::getValue).findFirst().orElseThrow(() -> new UnableToCreateMapperException("Could not find fieldname mapping for column '" + c.name() + "' in " + fieldNameToColumnsMapping.keySet()));
            InspectedField field = null;
            Iterator it = inspectedFields.iterator();
            while (it.hasNext()) {
                InspectedField curr = (InspectedField)it.next();
                if (!fieldName.equals(curr.fieldName())) continue;
                field = curr;
                it.remove();
            }
            if (field == null) {
                throw new UnableToCreateMapperException("Inspection did not find field with name:" + fieldName);
            }
            assert (field != null) : "Column should always exist";
            try {
                fieldType = Class.forName(field.typeName());
            }
            catch (ClassNotFoundException e2) {
                throw new UnableToCreateMapperException("Could not find class(" + field.typeName() + ") for field: " + field.fieldName(), e2);
            }
            Class columnType = c.type().javaClass();
            @Nullable TypeConverter<?, ColumnT> converter = this.typeConverterFactory.converterFor(fieldType, columnType);
            if (converter != null) {
                builder.map(fieldName, c.name(), converter);
                continue;
            }
            builder.map(fieldName, c.name(), new String[0]);
        }
        if (!inspectedFields.isEmpty() && this.allowExtraFields && schemaHasExtraColumn) {
            for (InspectedField inspectedField : inspectedFields) {
                Field field = null;
                try {
                    @Nullable String fieldName = inspectedField.fieldName();
                    assert (fieldName != null);
                    field = klass.getDeclaredField(fieldName);
                }
                catch (NoSuchFieldException e3) {
                    throw new UnableToCreateMapperException("Unexpected error while reflecting fields", e3);
                }
                field.setAccessible(true);
                builder.mapExtraField(field);
            }
        }
        return builder.build();
    }

    public static <T> OneColumnMapper<T> createJsonColumnMapper(Class<T> targetType) {
        try {
            return ONE_COLUMN_MAPPER_CONSTRUCTOR.newInstance(targetType, "VAL", new JsonBytesTypeConverter<T>(targetType));
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    static {
        try {
            Class<?> oneColumnMapperCls = Class.forName("org.apache.ignite3.table.mapper.OneColumnMapperImpl");
            ONE_COLUMN_MAPPER_CONSTRUCTOR = oneColumnMapperCls.getDeclaredConstructor(Class.class, String.class, TypeConverter.class);
            ONE_COLUMN_MAPPER_CONSTRUCTOR.setAccessible(true);
            GET_COLUMN_TO_FIELD_MAPPING = MapperBuilder.class.getDeclaredMethod("getColumnToFieldMapping", Field.class);
            GET_COLUMN_TO_FIELD_MAPPING.setAccessible(true);
        }
        catch (ClassNotFoundException | NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }

    private static class NullConverter
    implements TypeConverter<Object, Object> {
        private NullConverter() {
        }

        public Object toColumnType(Object o) throws Exception {
            return null;
        }

        public Object toObjectType(Object o) throws Exception {
            return null;
        }
    }
}

