/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.ignite.migrationtools.adapter.internal.futures;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.commons.lang3.NotImplementedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.lang.IgniteClosure;
import org.apache.ignite.lang.IgniteFuture;
import org.apache.ignite.lang.IgniteInClosure;

public class IgniteFutureAdapter<T>
implements IgniteFuture<T> {
    private final CompletableFuture<T> internalFuture;

    public IgniteFutureAdapter(CompletableFuture<T> future) {
        this.internalFuture = future;
    }

    public T get() throws IgniteException {
        try {
            return this.internalFuture.get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IgniteException((Throwable)e);
        }
        catch (ExecutionException e) {
            throw new IgniteException((Throwable)e);
        }
    }

    public T get(long timeout) throws IgniteException {
        try {
            return this.internalFuture.get(timeout, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IgniteException((Throwable)e);
        }
        catch (ExecutionException | TimeoutException e) {
            throw new IgniteException((Throwable)e);
        }
    }

    public T get(long timeout, TimeUnit unit) throws IgniteException {
        try {
            return this.internalFuture.get(timeout, unit);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IgniteException((Throwable)e);
        }
        catch (ExecutionException | TimeoutException e) {
            throw new IgniteException((Throwable)e);
        }
    }

    public boolean cancel() throws IgniteException {
        return this.internalFuture.cancel(true);
    }

    public boolean isCancelled() {
        return this.internalFuture.isCancelled();
    }

    public boolean isDone() {
        return this.internalFuture.isDone();
    }

    public void listen(IgniteInClosure<? super IgniteFuture<T>> lsnr) {
        this.internalFuture.thenRun(() -> lsnr.apply((Object)this));
    }

    public void listenAsync(IgniteInClosure<? super IgniteFuture<T>> lsnr, Executor exec) {
        throw new NotImplementedException();
    }

    public <T1> IgniteFuture<T1> chain(IgniteClosure<? super IgniteFuture<T>, T1> doneCb) {
        return new IgniteFutureAdapter<T>(this.internalFuture.thenApply(v -> doneCb.apply((Object)this)));
    }

    public <T1> IgniteFuture<T1> chainAsync(IgniteClosure<? super IgniteFuture<T>, T1> doneCb, Executor exec) {
        throw new NotImplementedException();
    }
}

