/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.ignite.migrationtools.adapter.internal;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;
import javax.cache.Cache;
import javax.cache.CacheException;
import org.apache.ignite.cache.query.QueryCursor;
import org.apache.ignite.internal.processors.cache.CacheEntryImpl;
import org.apache.ignite3.internal.binarytuple.BinaryTupleContainer;
import org.apache.ignite3.internal.binarytuple.BinaryTupleReader;
import org.apache.ignite3.internal.client.proto.TuplePart;
import org.apache.ignite3.internal.client.table.ClientSchema;
import org.apache.ignite3.internal.marshaller.ClientMarshallerReader;
import org.apache.ignite3.internal.marshaller.Marshaller;
import org.apache.ignite3.internal.marshaller.MarshallerReader;
import org.apache.ignite3.internal.util.TransformingIterator;
import org.apache.ignite3.lang.MarshallerException;
import org.apache.ignite3.sql.ResultSet;
import org.apache.ignite3.sql.SqlRow;
import org.jetbrains.annotations.Nullable;

class ScanQueryCursor<K, V>
implements QueryCursor<Cache.Entry<K, V>> {
    private final ResultSet<SqlRow> rs;
    private final ClientSchema clientSchema;
    private final Marshaller keyMarshaller;
    private final Marshaller valMarshaller;
    private final Consumer<Cache.Entry<K, V>> removeHandler;

    ScanQueryCursor(ResultSet<SqlRow> rs, ClientSchema clientSchema, Marshaller keyMarshaller, Marshaller valMarshaller, Consumer<Cache.Entry<K, V>> removeHandler) {
        this.rs = rs;
        this.clientSchema = clientSchema;
        this.keyMarshaller = keyMarshaller;
        this.valMarshaller = valMarshaller;
        this.removeHandler = removeHandler;
    }

    public List<Cache.Entry<K, V>> getAll() {
        ArrayList<Cache.Entry<K, V>> ret = new ArrayList<Cache.Entry<K, V>>();
        Iterator<Cache.Entry<K, V>> iter = this.iterator();
        while (iter.hasNext()) {
            Cache.Entry<K, V> e = iter.next();
            ret.add(e);
        }
        return ret;
    }

    public void close() {
        this.rs.close();
    }

    public Iterator<Cache.Entry<K, V>> iterator() {
        return new TransformingIterator<SqlRow, Cache.Entry<K, V>>((Iterator)this.rs, this::rowToEntry){
            @Nullable
            private Cache.Entry<K, V> curr;
            {
                this.curr = null;
            }

            public Cache.Entry<K, V> next() {
                this.curr = (Cache.Entry)super.next();
                return this.curr;
            }

            public void remove() {
                if (this.curr == null) {
                    throw new IllegalStateException("No current value.");
                }
                ScanQueryCursor.this.removeHandler.accept(this.curr);
                this.curr = null;
            }
        };
    }

    private Cache.Entry<K, V> rowToEntry(SqlRow row) {
        Object v;
        Object k;
        BinaryTupleContainer tupleContainer = (BinaryTupleContainer)row;
        BinaryTupleReader binaryTupleReader = tupleContainer.binaryTuple();
        try {
            ClientMarshallerReader reader = new ClientMarshallerReader(binaryTupleReader, this.clientSchema.columns(TuplePart.KEY), TuplePart.KEY_AND_VAL);
            k = this.keyMarshaller.readObject((MarshallerReader)reader, null);
        }
        catch (MarshallerException e) {
            throw new CacheException("Error unmarshalling key", (Throwable)e);
        }
        try {
            ClientMarshallerReader reader = new ClientMarshallerReader(binaryTupleReader, this.clientSchema.columns(TuplePart.VAL), TuplePart.KEY_AND_VAL);
            v = this.valMarshaller.readObject((MarshallerReader)reader, null);
        }
        catch (MarshallerException e) {
            throw new CacheException("Error unmarshalling value", (Throwable)e);
        }
        return new CacheEntryImpl(k, v);
    }
}

