/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.ignite.migrationtools.adapter.internal;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;
import org.apache.commons.lang3.concurrent.ConcurrentException;
import org.apache.commons.lang3.concurrent.LazyInitializer;
import org.apache.ignite.IgniteCompute;
import org.apache.ignite.IgniteException;
import org.apache.ignite.cluster.ClusterGroup;
import org.apache.ignite.compute.ComputeTask;
import org.apache.ignite.compute.ComputeTaskFuture;
import org.apache.ignite.lang.IgniteCallable;
import org.apache.ignite.lang.IgniteClosure;
import org.apache.ignite.lang.IgniteFuture;
import org.apache.ignite.lang.IgniteReducer;
import org.apache.ignite.lang.IgniteRunnable;
import org.apache.ignite.lang.IgniteUuid;
import org.apache.ignite3.compute.BroadcastJobTarget;
import org.apache.ignite3.compute.JobDescriptor;
import org.apache.ignite3.deployment.DeploymentUnit;
import org.apache.ignite3.marshalling.Marshaller;
import org.apache.ignite3.network.IgniteCluster;
import org.gridgain.ignite.migrationtools.adapter.compute.IgniteCallableComputeJob;
import org.gridgain.ignite.migrationtools.adapter.compute.IgniteClosureComputeJob;
import org.gridgain.ignite.migrationtools.adapter.compute.IgniteRunnableComputeJob;
import org.gridgain.ignite.migrationtools.adapter.internal.ClusterGroupAdapter;
import org.gridgain.ignite.migrationtools.adapter.internal.compute.JdkMarshallerImpl;
import org.gridgain.ignite.migrationtools.adapter.internal.compute.VoidMarshaller;
import org.gridgain.ignite.migrationtools.adapter.internal.futures.IgniteFutureAdapter;

public class IgniteComputeAdapter
implements IgniteCompute {
    private static LazyInitializer<List<DeploymentUnit>> DEPLOYMENT_UNITS = new LazyInitializer<List<DeploymentUnit>>(){

        protected List<DeploymentUnit> initialize() throws ConcurrentException {
            ArrayList<DeploymentUnit> arrayList;
            BufferedReader is = new BufferedReader(new InputStreamReader(IgniteComputeAdapter.class.getClassLoader().getResourceAsStream("compute-deployment-units"), StandardCharsets.UTF_8));
            try {
                ArrayList<DeploymentUnit> ret = new ArrayList<DeploymentUnit>();
                String line = null;
                while ((line = is.readLine()) != null) {
                    int idx = line.lastIndexOf(58);
                    if (idx == -1) {
                        throw new ConcurrentException((Throwable)new IllegalStateException("Malformed dependency unit entry: " + line));
                    }
                    String name = line.substring(0, idx);
                    String version = line.substring(idx + 1);
                    DeploymentUnit depUnit = new DeploymentUnit(name, version);
                    ret.add(depUnit);
                }
                arrayList = ret;
            }
            catch (Throwable throwable) {
                try {
                    try {
                        is.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new ConcurrentException((Throwable)e);
                }
            }
            is.close();
            return arrayList;
        }
    };
    private final org.apache.ignite3.compute.IgniteCompute computeApi;
    private final IgniteCluster clusterApi;
    private final ClusterGroup clusterGroup;
    private final Function<Class<?>, List<DeploymentUnit>> deploymentUnitSelector;

    public IgniteComputeAdapter(org.apache.ignite3.compute.IgniteCompute computeApi, IgniteCluster clusterApi, ClusterGroup clusterGroup, Function<Class<?>, List<DeploymentUnit>> deploymentUnitSelector) {
        List defaultDeploymentUnits;
        this.computeApi = computeApi;
        this.clusterApi = clusterApi;
        this.clusterGroup = clusterGroup;
        try {
            defaultDeploymentUnits = (List)DEPLOYMENT_UNITS.get();
        }
        catch (ConcurrentException e) {
            throw new IllegalStateException("Could not load deployment unit dependencies", e);
        }
        this.deploymentUnitSelector = deploymentUnitSelector.andThen(u -> {
            ArrayList r = new ArrayList(defaultDeploymentUnits.size() + u.size());
            r.addAll(defaultDeploymentUnits);
            r.addAll(u);
            return r;
        });
    }

    private static <T> IgniteFuture<T> wrapFuture(CompletableFuture<T> future) {
        return new IgniteFutureAdapter<T>(future);
    }

    public ClusterGroup clusterGroup() {
        throw new UnsupportedOperationException();
    }

    public void affinityRun(String s, Object o, IgniteRunnable igniteRunnable) throws IgniteException {
        throw new UnsupportedOperationException();
    }

    public void affinityRun(Collection<String> collection, Object o, IgniteRunnable igniteRunnable) throws IgniteException {
        throw new UnsupportedOperationException();
    }

    public void affinityRun(Collection<String> collection, int i, IgniteRunnable igniteRunnable) throws IgniteException {
        throw new UnsupportedOperationException();
    }

    public IgniteFuture<Void> affinityRunAsync(String s, Object o, IgniteRunnable igniteRunnable) throws IgniteException {
        throw new UnsupportedOperationException();
    }

    public IgniteFuture<Void> affinityRunAsync(Collection<String> collection, Object o, IgniteRunnable igniteRunnable) throws IgniteException {
        throw new UnsupportedOperationException();
    }

    public IgniteFuture<Void> affinityRunAsync(Collection<String> collection, int i, IgniteRunnable igniteRunnable) throws IgniteException {
        throw new UnsupportedOperationException();
    }

    public <R> R affinityCall(String s, Object o, IgniteCallable<R> igniteCallable) throws IgniteException {
        throw new UnsupportedOperationException();
    }

    public <R> R affinityCall(Collection<String> collection, Object o, IgniteCallable<R> igniteCallable) throws IgniteException {
        throw new UnsupportedOperationException();
    }

    public <R> R affinityCall(Collection<String> collection, int i, IgniteCallable<R> igniteCallable) throws IgniteException {
        throw new UnsupportedOperationException();
    }

    public <R> IgniteFuture<R> affinityCallAsync(String s, Object o, IgniteCallable<R> igniteCallable) throws IgniteException {
        throw new UnsupportedOperationException();
    }

    public <R> IgniteFuture<R> affinityCallAsync(Collection<String> collection, Object o, IgniteCallable<R> igniteCallable) throws IgniteException {
        throw new UnsupportedOperationException();
    }

    public <R> IgniteFuture<R> affinityCallAsync(Collection<String> collection, int i, IgniteCallable<R> igniteCallable) throws IgniteException {
        throw new UnsupportedOperationException();
    }

    public <T, R> R execute(Class<? extends ComputeTask<T, R>> klass, T t) throws IgniteException {
        throw new UnsupportedOperationException();
    }

    public <T, R> R execute(ComputeTask<T, R> computeTask, T t) throws IgniteException {
        throw new UnsupportedOperationException();
    }

    public <T, R> R execute(String s, T t) throws IgniteException {
        throw new UnsupportedOperationException();
    }

    public <T, R> ComputeTaskFuture<R> executeAsync(Class<? extends ComputeTask<T, R>> klass, T t) throws IgniteException {
        throw new UnsupportedOperationException();
    }

    public <T, R> ComputeTaskFuture<R> executeAsync(ComputeTask<T, R> computeTask, T t) throws IgniteException {
        throw new UnsupportedOperationException();
    }

    public <T, R> ComputeTaskFuture<R> executeAsync(String s, T t) throws IgniteException {
        throw new UnsupportedOperationException();
    }

    public void broadcast(IgniteRunnable igniteRunnable) throws IgniteException {
        this.broadcastAsync(igniteRunnable).get();
    }

    public <R> Collection<R> broadcast(IgniteCallable<R> igniteCallable) throws IgniteException {
        return (Collection)this.broadcastAsync(igniteCallable).get();
    }

    public <R, T> Collection<R> broadcast(IgniteClosure<T, R> igniteClosure, T t) throws IgniteException {
        return (Collection)this.broadcastAsync(igniteClosure, t).get();
    }

    public IgniteFuture<Void> broadcastAsync(IgniteRunnable igniteRunnable) throws IgniteException {
        if (this.clusterGroup != ClusterGroupAdapter.FOR_SERVERS_INSTANCE) {
            throw new UnsupportedOperationException("Only ClusterGroup#forServers() is supported atm.");
        }
        Collection nodes = this.clusterApi.nodes();
        BroadcastJobTarget target = BroadcastJobTarget.nodes((Collection)nodes);
        JobDescriptor descr = JobDescriptor.builder((String)IgniteRunnableComputeJob.class.getName()).argumentMarshaller(new JdkMarshallerImpl()).resultMarshaller((Marshaller)VoidMarshaller.INSTANCE).units(this.deploymentUnitSelector.apply(igniteRunnable.getClass())).build();
        CompletionStage res = this.computeApi.executeAsync(target, descr, (Object)igniteRunnable).thenApply(fs -> null);
        return IgniteComputeAdapter.wrapFuture(res);
    }

    public <R> IgniteFuture<Collection<R>> broadcastAsync(IgniteCallable<R> igniteCallable) throws IgniteException {
        if (this.clusterGroup != ClusterGroupAdapter.FOR_SERVERS_INSTANCE) {
            throw new UnsupportedOperationException("Only ClusterGroup#forServers() is supported atm.");
        }
        Collection nodes = this.clusterApi.nodes();
        BroadcastJobTarget target = BroadcastJobTarget.nodes((Collection)nodes);
        JobDescriptor descr = JobDescriptor.builder((String)IgniteCallableComputeJob.class.getName()).argumentMarshaller(new JdkMarshallerImpl()).resultMarshaller(new JdkMarshallerImpl()).units(this.deploymentUnitSelector.apply(igniteCallable.getClass())).build();
        CompletableFuture res = this.computeApi.executeAsync(target, descr, igniteCallable);
        return IgniteComputeAdapter.wrapFuture(res);
    }

    public <R, T> IgniteFuture<Collection<R>> broadcastAsync(IgniteClosure<T, R> igniteClosure, T t) throws IgniteException {
        if (this.clusterGroup != ClusterGroupAdapter.FOR_SERVERS_INSTANCE) {
            throw new UnsupportedOperationException("Only ClusterGroup#forServers() is supported atm.");
        }
        Collection nodes = this.clusterApi.nodes();
        BroadcastJobTarget target = BroadcastJobTarget.nodes((Collection)nodes);
        JobDescriptor descr = JobDescriptor.builder((String)IgniteClosureComputeJob.class.getName()).argumentMarshaller(new JdkMarshallerImpl()).resultMarshaller(new JdkMarshallerImpl()).units(this.deploymentUnitSelector.apply(igniteClosure.getClass())).build();
        CompletableFuture res = this.computeApi.executeAsync(target, descr, (Object)new IgniteClosureComputeJob.Input(igniteClosure, t));
        return IgniteComputeAdapter.wrapFuture(res);
    }

    public void run(IgniteRunnable igniteRunnable) throws IgniteException {
        throw new UnsupportedOperationException();
    }

    public void run(Collection<? extends IgniteRunnable> collection) throws IgniteException {
        throw new UnsupportedOperationException();
    }

    public IgniteFuture<Void> runAsync(IgniteRunnable igniteRunnable) throws IgniteException {
        throw new UnsupportedOperationException();
    }

    public IgniteFuture<Void> runAsync(Collection<? extends IgniteRunnable> collection) throws IgniteException {
        throw new UnsupportedOperationException();
    }

    public <R> R call(IgniteCallable<R> igniteCallable) throws IgniteException {
        throw new UnsupportedOperationException();
    }

    public <R> IgniteFuture<R> callAsync(IgniteCallable<R> igniteCallable) throws IgniteException {
        throw new UnsupportedOperationException();
    }

    public <R> Collection<R> call(Collection<? extends IgniteCallable<R>> collection) throws IgniteException {
        throw new UnsupportedOperationException();
    }

    public <R> IgniteFuture<Collection<R>> callAsync(Collection<? extends IgniteCallable<R>> collection) throws IgniteException {
        throw new UnsupportedOperationException();
    }

    public <R1, R2> R2 call(Collection<? extends IgniteCallable<R1>> collection, IgniteReducer<R1, R2> igniteReducer) throws IgniteException {
        throw new UnsupportedOperationException();
    }

    public <R1, R2> IgniteFuture<R2> callAsync(Collection<? extends IgniteCallable<R1>> collection, IgniteReducer<R1, R2> igniteReducer) throws IgniteException {
        throw new UnsupportedOperationException();
    }

    public <R, T> R apply(IgniteClosure<T, R> igniteClosure, T t) throws IgniteException {
        throw new UnsupportedOperationException();
    }

    public <T, R> Collection<R> apply(IgniteClosure<T, R> igniteClosure, Collection<? extends T> collection) throws IgniteException {
        throw new UnsupportedOperationException();
    }

    public <R1, R2, T> R2 apply(IgniteClosure<T, R1> igniteClosure, Collection<? extends T> collection, IgniteReducer<R1, R2> igniteReducer) throws IgniteException {
        throw new UnsupportedOperationException();
    }

    public <R, T> IgniteFuture<R> applyAsync(IgniteClosure<T, R> igniteClosure, T t) throws IgniteException {
        throw new UnsupportedOperationException();
    }

    public <T, R> IgniteFuture<Collection<R>> applyAsync(IgniteClosure<T, R> igniteClosure, Collection<? extends T> collection) throws IgniteException {
        throw new UnsupportedOperationException();
    }

    public <R1, R2, T> IgniteFuture<R2> applyAsync(IgniteClosure<T, R1> igniteClosure, Collection<? extends T> collection, IgniteReducer<R1, R2> igniteReducer) throws IgniteException {
        throw new UnsupportedOperationException();
    }

    public <R> Map<IgniteUuid, ComputeTaskFuture<R>> activeTaskFutures() {
        throw new UnsupportedOperationException();
    }

    public IgniteCompute withName(String s) {
        throw new UnsupportedOperationException();
    }

    public IgniteCompute withTimeout(long l) {
        throw new UnsupportedOperationException();
    }

    public IgniteCompute withNoFailover() {
        throw new UnsupportedOperationException();
    }

    public IgniteCompute withNoResultCache() {
        throw new UnsupportedOperationException();
    }

    public void localDeployTask(Class<? extends ComputeTask> klass, ClassLoader classLoader) throws IgniteException {
        throw new UnsupportedOperationException();
    }

    public Map<String, Class<? extends ComputeTask<?, ?>>> localTasks() {
        throw new UnsupportedOperationException();
    }

    public void undeployTask(String s) throws IgniteException {
        throw new UnsupportedOperationException();
    }

    public <R> ComputeTaskFuture<R> future() {
        throw new UnsupportedOperationException();
    }

    public IgniteCompute withAsync() {
        throw new UnsupportedOperationException();
    }

    public boolean isAsync() {
        throw new UnsupportedOperationException();
    }

    public IgniteCompute withExecutor(String s) {
        throw new UnsupportedOperationException();
    }
}

