/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.ignite.migrationtools.adapter.internal;

import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.cache.CacheException;
import org.apache.ignite.DataRegionMetrics;
import org.apache.ignite.DataStorageMetrics;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteAtomicLong;
import org.apache.ignite.IgniteAtomicReference;
import org.apache.ignite.IgniteAtomicSequence;
import org.apache.ignite.IgniteAtomicStamped;
import org.apache.ignite.IgniteBinary;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.IgniteCompute;
import org.apache.ignite.IgniteCountDownLatch;
import org.apache.ignite.IgniteDataStreamer;
import org.apache.ignite.IgniteEncryption;
import org.apache.ignite.IgniteEvents;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteLock;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.IgniteMessaging;
import org.apache.ignite.IgniteQueue;
import org.apache.ignite.IgniteScheduler;
import org.apache.ignite.IgniteSemaphore;
import org.apache.ignite.IgniteServices;
import org.apache.ignite.IgniteSet;
import org.apache.ignite.IgniteTransactions;
import org.apache.ignite.MemoryMetrics;
import org.apache.ignite.PersistenceMetrics;
import org.apache.ignite.cache.affinity.Affinity;
import org.apache.ignite.cluster.ClusterGroup;
import org.apache.ignite.configuration.AtomicConfiguration;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.CollectionConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.configuration.NearCacheConfiguration;
import org.apache.ignite.lang.IgniteProductVersion;
import org.apache.ignite.plugin.IgnitePlugin;
import org.apache.ignite.plugin.PluginNotFoundException;
import org.apache.ignite.spi.tracing.TracingConfigurationManager;
import org.apache.ignite3.deployment.DeploymentUnit;
import org.apache.ignite3.network.IgniteCluster;
import org.gridgain.ignite.migrationtools.adapter.internal.CacheAdapter;
import org.gridgain.ignite.migrationtools.adapter.internal.ClientAdapter;
import org.gridgain.ignite.migrationtools.adapter.internal.IgniteClusterAdapter;
import org.gridgain.ignite.migrationtools.adapter.internal.IgniteComputeAdapter;
import org.gridgain.ignite.migrationtools.adapter.internal.MappedKeyValueViewAdapterImpl;
import org.gridgain.ignite.migrationtools.adapter.internal.transactions.Ignite2TransactionAdapter;
import org.jetbrains.annotations.Nullable;

public class IgniteAdapter
implements Ignite {
    private final ClientAdapter base;
    private final Ignite2TransactionAdapter transactionAdapter;
    private final org.apache.ignite3.compute.IgniteCompute computeApi;
    private final IgniteCluster clusterApi;
    private final Function<Class<?>, List<DeploymentUnit>> computeDeploymentUnitsSelector;
    private final org.apache.ignite.IgniteCluster igniteClusterAdapter;

    public IgniteAdapter(ClientAdapter baseAdapter, Ignite2TransactionAdapter transactionAdapter, org.apache.ignite3.compute.IgniteCompute computeApi, IgniteCluster clusterApi, Function<Class<?>, List<DeploymentUnit>> computeDeploymentUnitsSelector) {
        this.base = baseAdapter;
        this.transactionAdapter = transactionAdapter;
        this.computeApi = computeApi;
        this.clusterApi = clusterApi;
        this.computeDeploymentUnitsSelector = computeDeploymentUnitsSelector;
        this.igniteClusterAdapter = new IgniteClusterAdapter();
    }

    private static <T> T block(CompletableFuture<T> fut) throws CacheException {
        try {
            return fut.get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new CacheException((Throwable)e);
        }
        catch (ExecutionException e) {
            throw new CacheException((Throwable)e);
        }
    }

    public String name() {
        throw new UnsupportedOperationException();
    }

    public IgniteLogger log() {
        throw new UnsupportedOperationException();
    }

    public IgniteConfiguration configuration() {
        throw new UnsupportedOperationException();
    }

    public org.apache.ignite.IgniteCluster cluster() {
        return this.igniteClusterAdapter;
    }

    public IgniteCompute compute() {
        throw new UnsupportedOperationException();
    }

    public IgniteCompute compute(ClusterGroup grp) {
        return new IgniteComputeAdapter(this.computeApi, this.clusterApi, grp, this.computeDeploymentUnitsSelector);
    }

    public IgniteMessaging message() {
        throw new UnsupportedOperationException();
    }

    public IgniteMessaging message(ClusterGroup grp) {
        throw new UnsupportedOperationException();
    }

    public IgniteEvents events() {
        throw new UnsupportedOperationException();
    }

    public IgniteEvents events(ClusterGroup grp) {
        throw new UnsupportedOperationException();
    }

    public IgniteServices services() {
        throw new UnsupportedOperationException();
    }

    public IgniteServices services(ClusterGroup grp) {
        throw new UnsupportedOperationException();
    }

    public ExecutorService executorService() {
        throw new UnsupportedOperationException();
    }

    public ExecutorService executorService(ClusterGroup grp) {
        throw new UnsupportedOperationException();
    }

    public IgniteProductVersion version() {
        throw new UnsupportedOperationException();
    }

    public IgniteScheduler scheduler() {
        throw new UnsupportedOperationException();
    }

    public <K, V> IgniteCache<K, V> createCache(CacheConfiguration<K, V> cacheCfg) throws CacheException {
        return (IgniteCache)IgniteAdapter.block(this.base.createCache(cacheCfg).thenApply(this::wrapCache));
    }

    public Collection<IgniteCache> createCaches(Collection<CacheConfiguration> cacheCfgs) throws CacheException {
        List futures = cacheCfgs.stream().map(c -> this.base.createCache(c).thenApply(cache -> this.wrapCache((CacheAdapter)cache))).collect(Collectors.toList());
        CompletionStage whenFinished = CompletableFuture.allOf((CompletableFuture[])futures.toArray(CompletableFuture[]::new)).thenApply(r -> futures.stream().map(IgniteAdapter::block).collect(Collectors.toList()));
        return (Collection)IgniteAdapter.block(whenFinished);
    }

    public <K, V> IgniteCache<K, V> createCache(String cacheName) throws CacheException {
        return this.createCache(new CacheConfiguration(cacheName));
    }

    public <K, V> IgniteCache<K, V> getOrCreateCache(CacheConfiguration<K, V> cacheCfg) throws CacheException {
        return (IgniteCache)IgniteAdapter.block(this.base.getOrCreateCache(cacheCfg).thenApply(this::wrapCache));
    }

    public <K, V> IgniteCache<K, V> getOrCreateCache(String cacheName) throws CacheException {
        return this.getOrCreateCache(new CacheConfiguration(cacheName));
    }

    public Collection<IgniteCache> getOrCreateCaches(Collection<CacheConfiguration> cacheCfgs) throws CacheException {
        List futures = cacheCfgs.stream().map(c -> this.base.getOrCreateCache(c).thenApply(cache -> this.wrapCache((CacheAdapter)cache))).collect(Collectors.toList());
        CompletionStage whenFinished = CompletableFuture.allOf((CompletableFuture[])futures.toArray(CompletableFuture[]::new)).thenApply(r -> futures.stream().map(IgniteAdapter::block).collect(Collectors.toList()));
        return (Collection)IgniteAdapter.block(whenFinished);
    }

    public <K, V> void addCacheConfiguration(CacheConfiguration<K, V> cacheCfg) throws CacheException {
        throw new UnsupportedOperationException();
    }

    public <K, V> IgniteCache<K, V> createCache(CacheConfiguration<K, V> cacheCfg, NearCacheConfiguration<K, V> nearCfg) throws CacheException {
        throw new UnsupportedOperationException();
    }

    public <K, V> IgniteCache<K, V> getOrCreateCache(CacheConfiguration<K, V> cacheCfg, NearCacheConfiguration<K, V> nearCfg) throws CacheException {
        throw new UnsupportedOperationException();
    }

    public <K, V> IgniteCache<K, V> createNearCache(String cacheName, NearCacheConfiguration<K, V> nearCfg) throws CacheException {
        throw new UnsupportedOperationException();
    }

    public <K, V> IgniteCache<K, V> getOrCreateNearCache(String cacheName, NearCacheConfiguration<K, V> nearCfg) throws CacheException {
        throw new UnsupportedOperationException();
    }

    public void destroyCache(String cacheName) throws CacheException {
        IgniteAdapter.block(this.base.destroyCache(cacheName));
    }

    public void destroyCaches(Collection<String> cacheNames) throws CacheException {
        if (cacheNames.stream().anyMatch(Objects::isNull)) {
            throw new IllegalArgumentException("cacheNames must not contain NULL elements.");
        }
        List futures = cacheNames.stream().map(this.base::destroyCache).collect(Collectors.toList());
        IgniteAdapter.block(CompletableFuture.allOf((CompletableFuture[])futures.toArray(CompletableFuture[]::new)));
    }

    public <K, V> IgniteCache<K, V> cache(String name) throws CacheException {
        return this.wrapCache(this.base.cache(name));
    }

    public Collection<String> cacheNames() {
        return IgniteAdapter.block(this.base.cacheNames());
    }

    public IgniteTransactions transactions() {
        return this.transactionAdapter;
    }

    public <K, V> IgniteDataStreamer<K, V> dataStreamer(String cacheName) throws IllegalStateException {
        throw new UnsupportedOperationException();
    }

    public IgniteAtomicSequence atomicSequence(String name, long initVal, boolean create) throws IgniteException {
        throw new UnsupportedOperationException();
    }

    public IgniteAtomicSequence atomicSequence(String name, AtomicConfiguration cfg, long initVal, boolean create) throws IgniteException {
        throw new UnsupportedOperationException();
    }

    public IgniteAtomicLong atomicLong(String name, long initVal, boolean create) throws IgniteException {
        throw new UnsupportedOperationException();
    }

    public IgniteAtomicLong atomicLong(String name, AtomicConfiguration cfg, long initVal, boolean create) throws IgniteException {
        throw new UnsupportedOperationException();
    }

    public <T> IgniteAtomicReference<T> atomicReference(String name, @Nullable T initVal, boolean create) throws IgniteException {
        throw new UnsupportedOperationException();
    }

    public <T> IgniteAtomicReference<T> atomicReference(String name, AtomicConfiguration cfg, @Nullable T initVal, boolean create) throws IgniteException {
        throw new UnsupportedOperationException();
    }

    public <T, S> IgniteAtomicStamped<T, S> atomicStamped(String name, @Nullable T initVal, @Nullable S initStamp, boolean create) throws IgniteException {
        throw new UnsupportedOperationException();
    }

    public <T, S> IgniteAtomicStamped<T, S> atomicStamped(String name, AtomicConfiguration cfg, @Nullable T initVal, @Nullable S initStamp, boolean create) throws IgniteException {
        throw new UnsupportedOperationException();
    }

    public IgniteCountDownLatch countDownLatch(String name, int cnt, boolean autoDel, boolean create) throws IgniteException {
        throw new UnsupportedOperationException();
    }

    public IgniteSemaphore semaphore(String name, int cnt, boolean failoverSafe, boolean create) throws IgniteException {
        throw new UnsupportedOperationException();
    }

    public IgniteLock reentrantLock(String name, boolean failoverSafe, boolean fair, boolean create) throws IgniteException {
        throw new UnsupportedOperationException();
    }

    public <T> IgniteQueue<T> queue(String name, int cap, @Nullable CollectionConfiguration cfg) throws IgniteException {
        throw new UnsupportedOperationException();
    }

    public <T> IgniteSet<T> set(String name, @Nullable CollectionConfiguration cfg) throws IgniteException {
        throw new UnsupportedOperationException();
    }

    public <T extends IgnitePlugin> T plugin(String name) throws PluginNotFoundException {
        throw new UnsupportedOperationException();
    }

    public IgniteBinary binary() {
        throw new UnsupportedOperationException();
    }

    public void close() throws IgniteException {
        try {
            this.base.close();
        }
        catch (Exception e) {
            throw new IgniteException((Throwable)e);
        }
    }

    public <K> Affinity<K> affinity(String cacheName) {
        throw new UnsupportedOperationException();
    }

    public boolean active() {
        throw new UnsupportedOperationException();
    }

    public void active(boolean active) {
        throw new UnsupportedOperationException();
    }

    public void resetLostPartitions(Collection<String> cacheNames) {
        throw new UnsupportedOperationException();
    }

    public Collection<MemoryMetrics> memoryMetrics() {
        throw new UnsupportedOperationException();
    }

    @Nullable
    public MemoryMetrics memoryMetrics(String memPlcName) {
        throw new UnsupportedOperationException();
    }

    public PersistenceMetrics persistentStoreMetrics() {
        throw new UnsupportedOperationException();
    }

    public Collection<DataRegionMetrics> dataRegionMetrics() {
        throw new UnsupportedOperationException();
    }

    @Nullable
    public DataRegionMetrics dataRegionMetrics(String memPlcName) {
        throw new UnsupportedOperationException();
    }

    public DataStorageMetrics dataStorageMetrics() {
        throw new UnsupportedOperationException();
    }

    public IgniteEncryption encryption() {
        throw new UnsupportedOperationException();
    }

    public TracingConfigurationManager tracingConfiguration() {
        throw new UnsupportedOperationException();
    }

    private <K, V> IgniteCache<K, V> wrapCache(@Nullable CacheAdapter<K, V> cacheAdapter) {
        if (cacheAdapter == null) {
            return null;
        }
        return new MappedKeyValueViewAdapterImpl<K, V>(cacheAdapter, this.computeApi);
    }
}

