/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.ignite.migrationtools.adapter.internal.mapper.converters;

import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Calendar;
import java.util.GregorianCalendar;
import org.apache.ignite3.table.mapper.TypeConverter;

public class CalendarToInstantConverter
implements TypeConverter<Calendar, Instant> {
    public Instant toColumnType(Calendar calendar) throws Exception {
        return calendar.toInstant();
    }

    public Calendar toObjectType(Instant instant) throws Exception {
        return GregorianCalendar.from(ZonedDateTime.ofInstant(instant, ZoneId.systemDefault()));
    }
}

