/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.ignite.migrationtools.adapter.internal;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import javax.cache.Cache;
import javax.cache.CacheException;
import javax.cache.processor.EntryProcessor;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.cache.CachePeekMode;
import org.apache.ignite.cache.query.FieldsQueryCursor;
import org.apache.ignite.cache.query.Query;
import org.apache.ignite.cache.query.QueryCursor;
import org.apache.ignite.cache.query.ScanQuery;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.lang.IgniteFuture;
import org.apache.ignite.transactions.TransactionException;
import org.apache.ignite3.compute.IgniteCompute;
import org.apache.ignite3.compute.JobDescriptor;
import org.apache.ignite3.compute.JobTarget;
import org.apache.ignite3.table.KeyValueView;
import org.apache.ignite3.table.Tuple;
import org.apache.ignite3.table.mapper.Mapper;
import org.apache.ignite3.table.mapper.OneColumnMapper;
import org.gridgain.ignite.migrationtools.adapter.compute.MappedEntryProcessorComputeJob;
import org.gridgain.ignite.migrationtools.adapter.converters.BinaryObjectTuple;
import org.gridgain.ignite.migrationtools.adapter.converters.TypeConverter;
import org.gridgain.ignite.migrationtools.adapter.internal.AbstractCacheAdapter;
import org.gridgain.ignite.migrationtools.adapter.internal.BinaryKeyValueViewAdapter;
import org.gridgain.ignite.migrationtools.adapter.internal.CacheAdapter;
import org.gridgain.ignite.migrationtools.adapter.internal.converters.NativeTypeTuple;
import org.gridgain.ignite.migrationtools.adapter.internal.futures.IgniteFutureAdapter;

public class MappedKeyValueViewAdapterImpl<K, V>
extends AbstractCacheAdapter<K, V> {
    private final CacheAdapter<K, V> base;
    private final IgniteCompute compute;

    public MappedKeyValueViewAdapterImpl(CacheAdapter<K, V> base, IgniteCompute compute) {
        this.base = base;
        this.compute = compute;
    }

    private static <T> TypeConverter<?, ?> getTypeConverterFor(Mapper<T> mapper, String defaultColumnName) {
        if (mapper instanceof OneColumnMapper) {
            String colName = Optional.ofNullable(((OneColumnMapper)mapper).mappedColumn()).orElse(defaultColumnName);
            return new NativeTypeTuple(colName);
        }
        return BinaryObjectTuple.INSTANCE;
    }

    private static <T> IgniteFuture<T> wrapFuture(CompletableFuture<T> f) {
        return new IgniteFutureAdapter<T>(f);
    }

    public String getName() {
        return this.base.getName();
    }

    public Iterator<Cache.Entry<K, V>> iterator() {
        return ((QueryCursor)MappedKeyValueViewAdapterImpl.wrapFuture(this.base.query(new ScanQuery())).get()).iterator();
    }

    public <K1, V1> IgniteCache<K1, V1> withKeepBinary() {
        Mapper<K> keyMapper = this.base.getKeyMapper();
        Mapper<V> valMapper = this.base.getValueMapper();
        TypeConverter<?, ?> keyTypeConverter = MappedKeyValueViewAdapterImpl.getTypeConverterFor(keyMapper, "ID");
        TypeConverter<?, ?> valTypeConverter = MappedKeyValueViewAdapterImpl.getTypeConverterFor(valMapper, "VAL");
        return new BinaryKeyValueViewAdapter(this.compute, this.base.getClientTable(), (KeyValueView<Tuple, Tuple>)this.base.getClientTable().keyValueView(), keyTypeConverter, valTypeConverter);
    }

    public IgniteFuture<V> getAsync(K key) {
        return MappedKeyValueViewAdapterImpl.wrapFuture(this.base.get(key));
    }

    public IgniteFuture<Map<K, V>> getAllAsync(Set<? extends K> keys) throws TransactionException {
        return MappedKeyValueViewAdapterImpl.wrapFuture(this.base.getAll(keys));
    }

    public IgniteFuture<Boolean> containsKeyAsync(K key) throws TransactionException {
        return MappedKeyValueViewAdapterImpl.wrapFuture(this.base.containsKey(key));
    }

    public IgniteFuture<Void> putAsync(K key, V val) throws TransactionException {
        return MappedKeyValueViewAdapterImpl.wrapFuture(this.base.put(key, val));
    }

    public IgniteFuture<V> getAndPutAsync(K key, V val) throws TransactionException {
        return MappedKeyValueViewAdapterImpl.wrapFuture(this.base.getAndPut(key, val));
    }

    public IgniteFuture<V> getAndPutIfAbsentAsync(K key, V val) throws TransactionException {
        return MappedKeyValueViewAdapterImpl.wrapFuture(this.base.getAndPutIfAbsent(key, val));
    }

    public IgniteFuture<Void> putAllAsync(Map<? extends K, ? extends V> map) throws TransactionException {
        return MappedKeyValueViewAdapterImpl.wrapFuture(this.base.putAll(map));
    }

    public IgniteFuture<Boolean> putIfAbsentAsync(K key, V val) {
        return MappedKeyValueViewAdapterImpl.wrapFuture(this.base.putIfAbsent(key, val));
    }

    public IgniteFuture<Boolean> removeAsync(K key) throws TransactionException {
        return MappedKeyValueViewAdapterImpl.wrapFuture(this.base.remove(key));
    }

    public IgniteFuture<Boolean> removeAsync(K key, V oldVal) throws TransactionException {
        return MappedKeyValueViewAdapterImpl.wrapFuture(this.base.remove(key, oldVal));
    }

    public IgniteFuture<V> getAndRemoveAsync(K key) throws TransactionException {
        return MappedKeyValueViewAdapterImpl.wrapFuture(this.base.getAndRemove(key));
    }

    public IgniteFuture<Boolean> replaceAsync(K key, V oldVal, V newVal) throws TransactionException {
        return MappedKeyValueViewAdapterImpl.wrapFuture(this.base.replace(key, oldVal, newVal));
    }

    public IgniteFuture<Boolean> replaceAsync(K key, V val) throws TransactionException {
        return MappedKeyValueViewAdapterImpl.wrapFuture(this.base.replace(key, val));
    }

    public IgniteFuture<V> getAndReplaceAsync(K key, V val) {
        return MappedKeyValueViewAdapterImpl.wrapFuture(this.base.getAndReplace(key, val));
    }

    public IgniteFuture<Void> removeAllAsync(Set<? extends K> keys) throws TransactionException {
        return MappedKeyValueViewAdapterImpl.wrapFuture(this.base.removeAll(keys));
    }

    public IgniteFuture<Void> removeAllAsync() {
        return MappedKeyValueViewAdapterImpl.wrapFuture(this.base.removeAll());
    }

    public IgniteFuture<Void> clearAsync() {
        return MappedKeyValueViewAdapterImpl.wrapFuture(this.base.clear());
    }

    public IgniteFuture<Void> clearAsync(K key) {
        return MappedKeyValueViewAdapterImpl.wrapFuture(this.base.clear(key));
    }

    public IgniteFuture<Void> clearAllAsync(Set<? extends K> keys) {
        return MappedKeyValueViewAdapterImpl.wrapFuture(this.base.clearAll(keys));
    }

    @Override
    public <T> IgniteFuture<T> invokeAsync(K key, EntryProcessor<K, V, T> entryProcessor, Object ... arguments) throws TransactionException {
        byte[] keyPayload;
        if (this.base.isInTransaction()) {
            throw new UnsupportedOperationException("Cannot run EntryProcessor inside a transaction.");
        }
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(bos);
            oos.writeObject(key);
            oos.flush();
            keyPayload = bos.toByteArray();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        String tableName = this.base.getClientTable().name();
        Mapper<K> keyMapper = this.base.getKeyMapper();
        Mapper<V> valMapper = this.base.getValueMapper();
        ArrayList<byte[]> params = new ArrayList<byte[]>(List.of(entryProcessor.getClass().getName(), tableName, keyMapper.targetType().getName(), valMapper.targetType().getName(), keyPayload));
        Collections.addAll(params, arguments);
        JobTarget target = JobTarget.colocated((String)tableName, key, keyMapper);
        JobDescriptor jobDescriptor = JobDescriptor.builder((String)MappedEntryProcessorComputeJob.class.getName()).build();
        CompletableFuture fut = this.compute.executeAsync(target, jobDescriptor, (Object)params.toArray());
        return new IgniteFutureAdapter(fut);
    }

    public void destroy() {
        MappedKeyValueViewAdapterImpl.wrapFuture(this.base.destroy()).get();
    }

    public IgniteFuture<Long> sizeLongAsync(CachePeekMode ... peekModes) throws CacheException {
        return MappedKeyValueViewAdapterImpl.wrapFuture(this.base.size(peekModes));
    }

    public <R> QueryCursor<R> query(Query<R> query) {
        return (QueryCursor)MappedKeyValueViewAdapterImpl.wrapFuture(this.base.query(query)).get();
    }

    public FieldsQueryCursor<List<?>> query(SqlFieldsQuery qry) {
        return this.base.query(qry);
    }
}

