/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.ignite.migrationtools.adapter.internal;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.beanutils.BeanIntrospector;
import org.apache.commons.beanutils.BeanUtilsBean;
import org.apache.commons.beanutils.ConvertUtilsBean;
import org.apache.commons.beanutils.Converter;
import org.apache.commons.beanutils.FluentPropertyBeanIntrospector;
import org.apache.commons.beanutils.PropertyUtilsBean;
import org.apache.ignite.IgniteBinary;
import org.apache.ignite.cache.QueryEntity;
import org.apache.ignite.cache.query.FieldsQueryCursor;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.client.ClientAtomicConfiguration;
import org.apache.ignite.client.ClientAtomicLong;
import org.apache.ignite.client.ClientAtomicSequence;
import org.apache.ignite.client.ClientCache;
import org.apache.ignite.client.ClientCacheConfiguration;
import org.apache.ignite.client.ClientCachePluginConfiguration;
import org.apache.ignite.client.ClientCluster;
import org.apache.ignite.client.ClientClusterGroup;
import org.apache.ignite.client.ClientCollectionConfiguration;
import org.apache.ignite.client.ClientCompute;
import org.apache.ignite.client.ClientException;
import org.apache.ignite.client.ClientIgniteSet;
import org.apache.ignite.client.ClientServices;
import org.apache.ignite.client.ClientTransactions;
import org.apache.ignite.client.IgniteClient;
import org.apache.ignite.client.IgniteClientFuture;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.internal.client.thin.IgniteClientFutureImpl;
import org.apache.ignite.plugin.CachePluginConfiguration;
import org.apache.ignite3.lang.IgniteException;
import org.apache.ignite3.lang.TableNotFoundException;
import org.gridgain.ignite.migrationtools.adapter.internal.CacheAdapter;
import org.gridgain.ignite.migrationtools.adapter.internal.ClientAdapter;
import org.gridgain.ignite.migrationtools.adapter.internal.ThinClientCacheAdapter;
import org.jetbrains.annotations.Nullable;

public class IgniteClientAdapter
implements IgniteClient {
    private static final Pattern TABLE_ALREADY_EXISTS_EXCEPTION_PATTERN = Pattern.compile("Table with name '((?<schemaName>\\w+)\\.)?(?<tableName>\\w+)' already exists\\.");
    private static final Pattern TABLE_NOT_FOUND_EXCEPTION_PATTERN = Pattern.compile("Table with name '((?<schemaName>\\w+)\\.)?(?<tableName>\\w+)' not found\\.");
    private static final BeanUtilsBean BEAN_UTILS;
    private final ClientAdapter base;

    public IgniteClientAdapter(ClientAdapter baseAdapter) {
        this.base = baseAdapter;
    }

    private static <K, V> CacheConfiguration<K, V> convert(ClientCacheConfiguration ccfg) {
        CacheConfiguration c = new CacheConfiguration();
        try {
            if (ccfg.getQueryEntities() == null) {
                ccfg.setQueryEntities(new QueryEntity[0]);
            }
            ccfg.setPluginConfigurations(new ClientCachePluginConfiguration[0]);
            BEAN_UTILS.copyProperties((Object)c, (Object)ccfg);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException("Error converting ClientCacheConfiguration into CacheConfiguration", e);
        }
        return c;
    }

    private static <T> IgniteClientFuture<T> wrapFuture(CompletableFuture<T> fut) {
        CompletionStage withExceptionHandler = fut.exceptionally(e -> {
            Throwable cause = e.getCause();
            if (cause instanceof IgniteException) {
                IgniteException ignEx = (IgniteException)cause;
                if (ignEx.code() == 262148 && "SQL".equals(ignEx.groupName())) {
                    Matcher matcher = TABLE_ALREADY_EXISTS_EXCEPTION_PATTERN.matcher(ignEx.getMessage());
                    if (matcher.find()) {
                        String tableNameStr = matcher.group("tableName");
                        throw new ClientException("Failed to start cache (a cache with the same name is already started): " + tableNameStr, cause);
                    }
                    matcher = TABLE_NOT_FOUND_EXCEPTION_PATTERN.matcher(ignEx.getMessage());
                    if (matcher.find()) {
                        throw new ClientException("Cache does not exist", cause);
                    }
                } else if (cause instanceof TableNotFoundException) {
                    throw new ClientException("Cache does not exist", cause);
                }
            }
            throw new ClientException(cause.getMessage(), cause);
        });
        return new IgniteClientFutureImpl(withExceptionHandler);
    }

    private static <T> T block(CompletableFuture<T> fut) {
        try {
            return fut.get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ClientException((Throwable)e);
        }
        catch (ExecutionException e) {
            throw new ClientException((Throwable)e);
        }
    }

    private static <T> T block(IgniteClientFuture<T> fut) {
        try {
            return (T)fut.get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ClientException((Throwable)e);
        }
        catch (ExecutionException e) {
            throw new ClientException((Throwable)e);
        }
    }

    public <K, V> ClientCache<K, V> getOrCreateCache(String name) throws ClientException {
        return IgniteClientAdapter.block(this.getOrCreateCacheAsync(name));
    }

    public <K, V> IgniteClientFuture<ClientCache<K, V>> getOrCreateCacheAsync(String name) throws ClientException {
        CacheConfiguration cfg = new CacheConfiguration().setName(name);
        return IgniteClientAdapter.wrapFuture(this.base.getOrCreateCache(cfg).thenApply(base -> new ThinClientCacheAdapter(base)));
    }

    public <K, V> ClientCache<K, V> getOrCreateCache(ClientCacheConfiguration cfg) throws ClientException {
        return IgniteClientAdapter.block(this.getOrCreateCacheAsync(cfg));
    }

    public <K, V> IgniteClientFuture<ClientCache<K, V>> getOrCreateCacheAsync(ClientCacheConfiguration cfg) throws ClientException {
        return IgniteClientAdapter.wrapFuture(this.base.getOrCreateCache(IgniteClientAdapter.convert(cfg)).thenApply(base -> new ThinClientCacheAdapter(base)));
    }

    public <K, V> ClientCache<K, V> cache(String name) {
        CacheAdapter cache = this.base.cache(name);
        if (cache != null) {
            return new ThinClientCacheAdapter(cache);
        }
        return (ClientCache)Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{ClientCache.class}, (proxy, method, args) -> {
            ClientException ex = new ClientException("Cache does not exist");
            if (IgniteClientFuture.class.equals(method.getReturnType())) {
                return new IgniteClientFutureImpl(CompletableFuture.failedFuture((Throwable)ex));
            }
            throw ex;
        });
    }

    public <K, V> ClientCache<K, V> createCache(String name) throws ClientException {
        CacheConfiguration cfg = new CacheConfiguration().setName(name);
        return (ClientCache)IgniteClientAdapter.block(this.base.createCache(cfg).thenApply(base -> new ThinClientCacheAdapter(base)));
    }

    public <K, V> IgniteClientFuture<ClientCache<K, V>> createCacheAsync(String name) throws ClientException {
        CacheConfiguration cfg = new CacheConfiguration().setName(name);
        return IgniteClientAdapter.wrapFuture(this.base.createCache(cfg).thenApply(base -> new ThinClientCacheAdapter(base)));
    }

    public <K, V> ClientCache<K, V> createCache(ClientCacheConfiguration cfg) throws ClientException {
        return (ClientCache)IgniteClientAdapter.block(this.base.createCache(IgniteClientAdapter.convert(cfg)).thenApply(base -> new ThinClientCacheAdapter(base)));
    }

    public <K, V> IgniteClientFuture<ClientCache<K, V>> createCacheAsync(ClientCacheConfiguration cfg) throws ClientException {
        return IgniteClientAdapter.wrapFuture(this.base.createCache(IgniteClientAdapter.convert(cfg)).thenApply(base -> new ThinClientCacheAdapter(base)));
    }

    public Collection<String> cacheNames() throws ClientException {
        return IgniteClientAdapter.block(this.base.cacheNames());
    }

    public IgniteClientFuture<Collection<String>> cacheNamesAsync() throws ClientException {
        return IgniteClientAdapter.wrapFuture(this.base.cacheNames());
    }

    public void destroyCache(String name) throws ClientException {
        IgniteClientAdapter.block(this.base.destroyCache(name));
    }

    public IgniteClientFuture<Void> destroyCacheAsync(String name) throws ClientException {
        return IgniteClientAdapter.wrapFuture(this.base.destroyCache(name));
    }

    public void close() {
        try {
            this.base.close();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public IgniteBinary binary() {
        throw new UnsupportedOperationException();
    }

    public FieldsQueryCursor<List<?>> query(SqlFieldsQuery qry) {
        throw new UnsupportedOperationException();
    }

    public ClientTransactions transactions() {
        throw new UnsupportedOperationException();
    }

    public ClientCompute compute() {
        throw new UnsupportedOperationException();
    }

    public ClientCompute compute(ClientClusterGroup grp) {
        throw new UnsupportedOperationException();
    }

    public ClientCluster cluster() {
        throw new UnsupportedOperationException();
    }

    public ClientServices services() {
        throw new UnsupportedOperationException();
    }

    public ClientServices services(ClientClusterGroup grp) {
        throw new UnsupportedOperationException();
    }

    public ClientAtomicLong atomicLong(String name, long initVal, boolean create) {
        throw new UnsupportedOperationException();
    }

    public ClientAtomicLong atomicLong(String name, ClientAtomicConfiguration cfg, long initVal, boolean create) {
        throw new UnsupportedOperationException();
    }

    public <T> ClientIgniteSet<T> set(String name, @Nullable ClientCollectionConfiguration cfg) {
        throw new UnsupportedOperationException();
    }

    public ClientAtomicSequence atomicSequence(String name, long initVal, boolean create) throws org.apache.ignite.IgniteException {
        throw new UnsupportedOperationException();
    }

    public ClientAtomicSequence atomicSequence(String name, ClientAtomicConfiguration cfg, long initVal, boolean create) throws org.apache.ignite.IgniteException {
        throw new UnsupportedOperationException();
    }

    static {
        PropertyUtilsBean propertyUtils = new PropertyUtilsBean();
        propertyUtils.addBeanIntrospector((BeanIntrospector)new FluentPropertyBeanIntrospector());
        ConvertUtilsBean converterUtils = new ConvertUtilsBean();
        converterUtils.register(new Converter(){

            public <T> T convert(Class<T> type, Object value) {
                if (value.getClass().isArray()) {
                    return (T)Arrays.asList((Object[])value);
                }
                return null;
            }
        }, Collection.class);
        converterUtils.register(new Converter(){

            public <T> T convert(Class<T> type, Object value) {
                if (value != null && value instanceof CachePluginConfiguration[]) {
                    return (T)value;
                }
                return null;
            }
        }, CachePluginConfiguration[].class);
        BEAN_UTILS = new BeanUtilsBean(converterUtils, propertyUtils);
    }
}

