/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.ignite.migrationtools.adapter.internal;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.cache.Cache;
import javax.cache.CacheException;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.parser.SqlParseException;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.tuple.Triple;
import org.apache.ignite.cache.CachePeekMode;
import org.apache.ignite.cache.query.FieldsQueryCursor;
import org.apache.ignite.cache.query.Query;
import org.apache.ignite.cache.query.QueryCursor;
import org.apache.ignite.cache.query.ScanQuery;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.internal.util.GridArgumentCheck;
import org.apache.ignite.transactions.TransactionException;
import org.apache.ignite3.internal.client.proto.TuplePart;
import org.apache.ignite3.internal.client.table.ClientColumn;
import org.apache.ignite3.internal.client.table.ClientSchema;
import org.apache.ignite3.internal.client.table.ClientTable;
import org.apache.ignite3.internal.marshaller.Marshaller;
import org.apache.ignite3.internal.marshaller.MarshallersProvider;
import org.apache.ignite3.internal.sql.SyncResultSetAdapter;
import org.apache.ignite3.sql.ColumnMetadata;
import org.apache.ignite3.sql.IgniteSql;
import org.apache.ignite3.sql.ResultSet;
import org.apache.ignite3.sql.ResultSetMetadata;
import org.apache.ignite3.sql.SqlRow;
import org.apache.ignite3.sql.Statement;
import org.apache.ignite3.table.KeyValueView;
import org.apache.ignite3.table.QualifiedName;
import org.apache.ignite3.table.mapper.Mapper;
import org.apache.ignite3.table.mapper.PojoMapper;
import org.apache.ignite3.table.mapper.TypeConverter;
import org.apache.ignite3.tx.Transaction;
import org.gridgain.ignite.migrationtools.adapter.internal.CacheTableReference;
import org.gridgain.ignite.migrationtools.adapter.internal.ClientAdapter;
import org.gridgain.ignite.migrationtools.adapter.internal.ScanQueryCursor;
import org.gridgain.ignite.migrationtools.adapter.internal.sql.AffectedRowsFieldsQueryCursorImpl;
import org.gridgain.ignite.migrationtools.adapter.internal.sql.FieldsQueryCursorImpl;
import org.gridgain.ignite.migrationtools.adapter.internal.sql.QueryTransformer;
import org.gridgain.ignite.migrationtools.adapter.internal.sql.QueryTransformerUtils;

public class CacheAdapter<K, V> {
    private final ClientAdapter clientAdapter;
    private final IgniteSql sql;
    private final ClientTable clientTable;
    private final KeyValueView<K, V> kvView;
    private final Supplier<Transaction> txSupplier;
    private Mapper<K> keyMapper;
    private Mapper<V> valueMapper;
    private CacheTableReference ai2CacheInfo;

    public CacheAdapter(ClientAdapter clientAdapter, IgniteSql sql, ClientTable clientTable, Mapper<K> keyMapper, Mapper<V> valueMapper, Supplier<Transaction> txSupplier, CacheTableReference cacheRef) {
        this.clientAdapter = clientAdapter;
        this.sql = sql;
        this.clientTable = clientTable;
        this.keyMapper = keyMapper;
        this.valueMapper = valueMapper;
        this.txSupplier = txSupplier;
        this.kvView = this.clientTable.keyValueView(keyMapper, valueMapper);
        this.ai2CacheInfo = cacheRef;
    }

    private static <T> Marshaller marshaller(ResultSetMetadata metadata, MarshallersProvider marshallers, Mapper<T> mapper) {
        ClientColumn[] schemaColumns = new ClientColumn[metadata.columns().size()];
        List columns = metadata.columns();
        for (int i = 0; i < columns.size(); ++i) {
            ClientColumn schemaColumn;
            ColumnMetadata metaColumn = (ColumnMetadata)columns.get(i);
            schemaColumns[i] = schemaColumn = new ClientColumn(metaColumn.name(), metaColumn.type(), metaColumn.nullable(), i, -1, -1, i, metaColumn.scale(), metaColumn.precision());
        }
        ClientSchema schema = new ClientSchema(0, schemaColumns, marshallers);
        return schema.getMarshaller(mapper);
    }

    private static void notNull(Collection<?> set, String name) {
        GridArgumentCheck.notNull(set, (String)name);
        if (set.stream().anyMatch(Objects::isNull)) {
            throw new NullPointerException("Ouch! Argument cannot be null: " + name + " cannot contain null values");
        }
    }

    private static void notNull(Map<?, ?> map, String name) {
        GridArgumentCheck.notNull(map, (String)name);
        if (map.entrySet().stream().anyMatch(e -> e == null || e.getKey() == null || e.getValue() == null)) {
            throw new NullPointerException("Ouch! Argument cannot be null: " + name + " cannot contain null keys or values");
        }
    }

    public ClientTable getClientTable() {
        return this.clientTable;
    }

    public IgniteSql getSql() {
        return this.sql;
    }

    public Mapper<K> getKeyMapper() {
        return this.keyMapper;
    }

    public Mapper<V> getValueMapper() {
        return this.valueMapper;
    }

    public boolean isInTransaction() {
        return this.txSupplier.get() != null;
    }

    public String getName() {
        String qualifiedNameStr = this.clientTable.name();
        QualifiedName qualifiedName = QualifiedName.parse((String)qualifiedNameStr);
        return qualifiedName.objectName();
    }

    public CompletableFuture<V> get(K key) {
        return this.kvView.getAsync(this.txSupplier.get(), key);
    }

    public CompletableFuture<Map<K, V>> getAll(Set<? extends K> keys) throws TransactionException {
        CacheAdapter.notNull(keys, "keys");
        return this.kvView.getAllAsync(this.txSupplier.get(), keys);
    }

    public CompletableFuture<Boolean> containsKey(K key) throws TransactionException {
        return this.kvView.containsAsync(this.txSupplier.get(), key);
    }

    public CompletableFuture<Boolean> containsKeys(Set<? extends K> keys) throws TransactionException {
        return this.kvView.getAllAsync(this.txSupplier.get(), keys).thenApply(res -> {
            Set foundKeys = res.keySet();
            if (foundKeys.size() < keys.size()) {
                return false;
            }
            return foundKeys.containsAll(keys);
        });
    }

    public CompletableFuture<Void> put(K key, V val) throws TransactionException {
        GridArgumentCheck.notNull(key, (String)"key", val, (String)"value");
        return this.kvView.putAsync(this.txSupplier.get(), key, val);
    }

    public CompletableFuture<V> getAndPut(K key, V val) throws TransactionException {
        GridArgumentCheck.notNull(key, (String)"key", val, (String)"value");
        return this.kvView.getAndPutAsync(this.txSupplier.get(), key, val);
    }

    public CompletableFuture<V> getAndPutIfAbsent(K key, V val) throws TransactionException {
        throw new UnsupportedOperationException("Will be implemented soon: IGNITE-22568");
    }

    public CompletableFuture<Void> putAll(Map<? extends K, ? extends V> map) throws TransactionException {
        CacheAdapter.notNull(map, "map");
        return this.kvView.putAllAsync(this.txSupplier.get(), map);
    }

    public CompletableFuture<Boolean> putIfAbsent(K key, V val) {
        return this.kvView.putIfAbsentAsync(this.txSupplier.get(), key, val);
    }

    public CompletableFuture<Boolean> remove(K key) throws TransactionException {
        GridArgumentCheck.notNull(key, (String)"key");
        return this.kvView.removeAsync(this.txSupplier.get(), key);
    }

    public CompletableFuture<Boolean> remove(K key, V oldVal) throws TransactionException {
        GridArgumentCheck.notNull(oldVal, (String)"oldVal");
        return this.kvView.removeAsync(this.txSupplier.get(), key, oldVal);
    }

    public CompletableFuture<V> getAndRemove(K key) throws TransactionException {
        GridArgumentCheck.notNull(key, (String)"key");
        return this.kvView.getAndRemoveAsync(this.txSupplier.get(), key);
    }

    public CompletableFuture<Boolean> replace(K key, V oldVal, V newVal) throws TransactionException {
        GridArgumentCheck.notNull(key, (String)"key", oldVal, (String)"oldVal", newVal, (String)"newVal");
        return this.kvView.replaceAsync(this.txSupplier.get(), key, oldVal, newVal);
    }

    public CompletableFuture<Boolean> replace(K key, V val) throws TransactionException {
        GridArgumentCheck.notNull(key, (String)"key", val, (String)"val");
        return this.kvView.replaceAsync(this.txSupplier.get(), key, val);
    }

    public CompletableFuture<V> getAndReplace(K key, V val) {
        GridArgumentCheck.notNull(key, (String)"key", val, (String)"val");
        return this.kvView.getAndReplaceAsync(this.txSupplier.get(), key, val);
    }

    public CompletableFuture<Void> removeAll() {
        return this.sql.executeAsync(null, "DELETE FROM " + this.clientTable.name() + ";", new Object[0]).thenAccept(rs -> {});
    }

    public CompletableFuture<Void> removeAll(Set<? extends K> keys) throws TransactionException {
        CacheAdapter.notNull(keys, "key");
        return this.kvView.removeAllAsync(this.txSupplier.get(), keys).thenRun(() -> {});
    }

    public CompletableFuture<Void> clear() {
        this.assertNotInTransaction();
        return this.removeAll();
    }

    public CompletableFuture<Void> clear(K key) {
        this.assertNotInTransaction();
        return this.kvView.removeAsync(null, key).thenAccept(r -> {});
    }

    public CompletableFuture<Void> clearAll(Set<? extends K> keys) {
        this.assertNotInTransaction();
        return this.kvView.removeAllAsync(null, keys).thenAccept(ks -> {});
    }

    public CompletableFuture<Void> destroy() {
        return this.clientAdapter.destroyCache(this.getName());
    }

    public CompletableFuture<Long> size(CachePeekMode ... peekModes) {
        if (ArrayUtils.getLength((Object)peekModes) != 0 && !CachePeekMode.PRIMARY.equals((Object)peekModes[0])) {
            throw new UnsupportedOperationException("Only CachePeekMode.PRIMARY is supported ATM.");
        }
        return this.sql.executeAsync(null, "SELECT COUNT(*) FROM " + this.clientTable.name() + ";", new Object[0]).thenApply(rs -> {
            Iterator it = rs.currentPage().iterator();
            if (!it.hasNext()) {
                throw new CacheException("Unexpected problem running query.");
            }
            SqlRow row = (SqlRow)it.next();
            return row.longValue(0);
        });
    }

    public <R> CompletableFuture<QueryCursor<R>> query(Query<R> qry) {
        if (qry instanceof SqlFieldsQuery) {
            return CompletableFuture.completedFuture(this.query((SqlFieldsQuery)qry));
        }
        if (qry instanceof ScanQuery) {
            return this.query((ScanQuery)qry);
        }
        throw new UnsupportedOperationException("Only SqlFieldsQuery and ScanQueries are currently supported.");
    }

    public FieldsQueryCursor<List<?>> query(SqlFieldsQuery qry) {
        SqlNode transformedNode;
        try {
            QueryTransformer transformer = new QueryTransformer(this.getName(), this.ai2CacheInfo.getSchema(), this.ai2CacheInfo.getTable());
            transformedNode = QueryTransformerUtils.transformQuery(transformer, qry.getSql());
            if (transformer.hasRefTo_Key() || transformer.hasRefTo_Val()) {
                throw new UnsupportedOperationException("Query with _KEY and _VAL columns is not supported.");
            }
        }
        catch (SqlParseException e) {
            throw new RuntimeException(e);
        }
        String sqlStr = QueryTransformerUtils.toSqlStr(transformedNode);
        boolean isQry = transformedNode.isA((Set)SqlKind.QUERY);
        Function<String, TypeConverter<?, ?>> fieldConverters = colName -> {
            TypeConverter c;
            if (this.keyMapper instanceof PojoMapper && (c = ((PojoMapper)this.keyMapper).converterForColumn(colName)) != null) {
                return c;
            }
            if (this.valueMapper instanceof PojoMapper && (c = ((PojoMapper)this.valueMapper).converterForColumn(colName)) != null) {
                return c;
            }
            return null;
        };
        ResultSet results = this.sql.execute(this.txSupplier.get(), sqlStr, qry.getArgs());
        return isQry ? new FieldsQueryCursorImpl((ResultSet<SqlRow>)results, fieldConverters) : new AffectedRowsFieldsQueryCursorImpl((ResultSet<SqlRow>)results);
    }

    public CompletableFuture<QueryCursor<Cache.Entry<K, V>>> query(ScanQuery<K, V> query) {
        if (query.getFilter() != null || query.getPartition() != null) {
            return CompletableFuture.failedFuture(new UnsupportedOperationException("Filter and Partition are currently not supported for ScanQueries."));
        }
        CompletionStage clientSchemaFut = ClientAdapter.getLatestSchemaForTable(this.clientTable).thenApply(clientSchema -> {
            Marshaller keyMarshaller = clientSchema.getMarshaller(this.keyMapper, TuplePart.KEY);
            Marshaller valMarshaller = clientSchema.getMarshaller(this.valueMapper, TuplePart.VAL);
            return Triple.of((Object)clientSchema, (Object)keyMarshaller, (Object)valMarshaller);
        });
        Statement stm = this.sql.statementBuilder().query("SELECT * FROM " + this.clientTable.qualifiedName().toCanonicalForm()).pageSize(query.getPageSize()).build();
        return ((CompletableFuture)this.sql.executeAsync(this.txSupplier.get(), stm, new Object[0]).thenApply(SyncResultSetAdapter::new)).thenCombine(clientSchemaFut, (rs, schemaCtx) -> new ScanQueryCursor((ResultSet<SqlRow>)rs, (ClientSchema)schemaCtx.getLeft(), (Marshaller)schemaCtx.getMiddle(), (Marshaller)schemaCtx.getRight(), e -> this.remove(e.getKey(), e.getValue()).join()));
    }

    private void assertNotInTransaction() {
        if (this.txSupplier.get() != null) {
            throw new CacheException("Cannot call clear methods inside a transaction.");
        }
    }
}

