/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.ignite.migrationtools.adapter.internal.mapper;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import org.apache.commons.lang3.ClassUtils;
import org.apache.ignite3.internal.client.proto.TuplePart;
import org.apache.ignite3.internal.client.table.ClientColumn;
import org.apache.ignite3.internal.client.table.ClientSchema;
import org.apache.ignite3.table.mapper.ExtendedMapperBuilder;
import org.apache.ignite3.table.mapper.Mapper;
import org.apache.ignite3.table.mapper.MapperBuilder;
import org.apache.ignite3.table.mapper.OneColumnMapper;
import org.apache.ignite3.table.mapper.TypeConverter;
import org.gridgain.ignite.migrationtools.adapter.internal.converters.JsonBytesTypeConverter;
import org.gridgain.ignite.migrationtools.adapter.internal.mapper.converters.StaticTypeConverterFactory;
import org.gridgain.ignite.migrationtools.adapter.internal.mapper.converters.TypeConverterFactory;
import org.jetbrains.annotations.Nullable;

public class MapperUtils {
    private static final Constructor<OneColumnMapper<?>> ONE_COLUMN_MAPPER_CONSTRUCTOR;
    private static final Method GET_COLUMN_TO_FIELD_MAPPING;
    private final TypeConverterFactory typeConverterFactory;
    private final boolean allowExtraFields;
    private final boolean allowMissingDfltConstructor;

    public MapperUtils(boolean allowExtraFields, boolean allowMissingDfltConstructor) {
        this(StaticTypeConverterFactory.DEFAULT_INSTANCE, allowExtraFields, allowMissingDfltConstructor);
    }

    public MapperUtils(TypeConverterFactory typeConverterFactory, boolean allowExtraFields, boolean allowMissingDfltConstructor) {
        this.typeConverterFactory = typeConverterFactory;
        this.allowExtraFields = allowExtraFields;
        this.allowMissingDfltConstructor = allowMissingDfltConstructor;
    }

    public boolean allowsExtraFields() {
        return this.allowExtraFields;
    }

    public boolean allowsMissingDfltConstructor() {
        return this.allowMissingDfltConstructor;
    }

    public Mapper<?> createMapper(ClientSchema latestSchema, Class<?> klass, TuplePart tuplePart) {
        if (Mapper.nativelySupported(klass)) {
            ClientColumn[] columns = latestSchema.columns(tuplePart);
            assert (columns.length == 1);
            String columnName = columns[0].name();
            return Mapper.of(klass, (String)columnName);
        }
        if (klass.isArray() || Collection.class.isAssignableFrom(klass)) {
            return MapperUtils.createJsonColumnMapper(klass);
        }
        ExtendedMapperBuilder<?> builder = ExtendedMapperBuilder.create(klass, this.allowMissingDfltConstructor);
        boolean schemaHasExtraColumn = Arrays.stream(latestSchema.columns()).anyMatch(col -> "__EXTRA__".equals(col.name()));
        builder.enableExtraFields(schemaHasExtraColumn);
        Arrays.stream(klass.getDeclaredFields()).filter(fld -> !Modifier.isStatic(fld.getModifiers()) && !Modifier.isTransient(fld.getModifiers())).forEach(fld -> {
            try {
                Class columnType;
                TypeConverter converter;
                Map.Entry entry = (Map.Entry)GET_COLUMN_TO_FIELD_MAPPING.invoke(null, fld);
                String colName = ((String)entry.getKey()).toUpperCase();
                String fieldName = (String)entry.getValue();
                Class<?> fieldType = fld.getType();
                if (Mapper.nativelySupported((Class)ClassUtils.primitiveToWrapper(fieldType))) {
                    builder.map(fieldName, colName, new String[0]);
                    return;
                }
                @Nullable ClientColumn col = latestSchema.columnSafe(colName);
                if (col != null && (converter = this.typeConverterFactory.converterFor(fieldType, columnType = col.type().javaClass())) != null) {
                    builder.map(fieldName, colName, converter);
                    return;
                }
                if (this.allowExtraFields && schemaHasExtraColumn) {
                    fld.setAccessible(true);
                    builder.mapExtraField((Field)fld);
                }
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        });
        return builder.build();
    }

    public static <T> OneColumnMapper<T> createJsonColumnMapper(Class<T> targetType) {
        try {
            return ONE_COLUMN_MAPPER_CONSTRUCTOR.newInstance(targetType, "VAL", new JsonBytesTypeConverter<T>(targetType));
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    static {
        try {
            Class<?> oneColumnMapperCls = Class.forName("org.apache.ignite3.table.mapper.OneColumnMapperImpl");
            ONE_COLUMN_MAPPER_CONSTRUCTOR = oneColumnMapperCls.getDeclaredConstructor(Class.class, String.class, TypeConverter.class);
            ONE_COLUMN_MAPPER_CONSTRUCTOR.setAccessible(true);
            GET_COLUMN_TO_FIELD_MAPPING = MapperBuilder.class.getDeclaredMethod("getColumnToFieldMapping", Field.class);
            GET_COLUMN_TO_FIELD_MAPPING.setAccessible(true);
        }
        catch (ClassNotFoundException | NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }

    private static class NullConverter
    implements TypeConverter<Object, Object> {
        private NullConverter() {
        }

        public Object toColumnType(Object o) throws Exception {
            return null;
        }

        public Object toObjectType(Object o) throws Exception {
            return null;
        }
    }
}

