/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.ignite.migrationtools.adapter.internal;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.migrationtools.sql.FieldNameConflictException;
import org.apache.ignite.migrationtools.sql.SqlDdlGenerator;
import org.apache.ignite.migrationtools.tablemanagement.Namespace;
import org.apache.ignite.migrationtools.tablemanagement.TableTypeDescriptor;
import org.apache.ignite.migrationtools.tablemanagement.TableTypeRegistry;
import org.apache.ignite.migrationtools.tablemanagement.TableTypeRegistryUtils;
import org.apache.ignite3.client.IgniteClient;
import org.apache.ignite3.internal.client.proto.TuplePart;
import org.apache.ignite3.internal.client.table.ClientSchema;
import org.apache.ignite3.internal.client.table.ClientTable;
import org.apache.ignite3.internal.marshaller.MarshallersProvider;
import org.apache.ignite3.lang.util.IgniteNameUtils;
import org.apache.ignite3.sql.SqlRow;
import org.apache.ignite3.sql.async.AsyncResultSet;
import org.apache.ignite3.table.QualifiedName;
import org.apache.ignite3.table.Table;
import org.apache.ignite3.table.mapper.Mapper;
import org.gridgain.ignite.migrationtools.adapter.internal.CacheAdapter;
import org.gridgain.ignite.migrationtools.adapter.internal.CacheTableReference;
import org.gridgain.ignite.migrationtools.adapter.internal.mapper.ExtendedMarshallerProvider;
import org.gridgain.ignite.migrationtools.adapter.internal.mapper.MapperUtils;
import org.gridgain.ignite.migrationtools.adapter.internal.transactions.Ignite2TransactionAdapter;
import org.jetbrains.annotations.Nullable;

public class ClientAdapter {
    private static final Method GET_LATEST_SCHEMA_METHOD;
    private final IgniteClient client;
    private final Ignite2TransactionAdapter transactionAdapter;
    private final TableTypeRegistry tableTypeRegistry;
    private final SqlDdlGenerator sqlGenerator;
    private final MapperUtils mapperUtils;

    public ClientAdapter(IgniteClient client, TableTypeRegistry tableTypeRegistry, MapperUtils mapperUtils) {
        this.client = client;
        this.tableTypeRegistry = tableTypeRegistry;
        this.mapperUtils = mapperUtils;
        this.transactionAdapter = new Ignite2TransactionAdapter(client.transactions());
        this.sqlGenerator = new SqlDdlGenerator(this.tableTypeRegistry, mapperUtils.allowsExtraFields());
    }

    private static <K, V> Function<Throwable, AsyncResultSet<SqlRow>> mapExceptionInFuture(String cacheName) {
        return e -> {
            String msg = e.getMessage();
            if (msg.endsWith("already exists") && msg.contains("Table with name")) {
                String newMsg = "Failed to start cache (a cache with the same name is already started): " + cacheName;
                throw new RuntimeException(newMsg, e.getCause());
            }
            if (msg.endsWith("not found") && msg.contains("Table with name")) {
                String newMsg = "Cache does not exist";
                throw new RuntimeException(newMsg, e.getCause());
            }
            throw (RuntimeException)e;
        };
    }

    @Nullable
    public ClientTable getClientTable(String name) {
        String quotedName = IgniteNameUtils.quote((String)name);
        return (ClientTable)this.client.tables().table(quotedName);
    }

    @Nullable
    public <K, V> CacheAdapter<K, V> cache(String name) {
        @Nullable ClientTable clientTable = this.getClientTable(name);
        if (clientTable == null) {
            return null;
        }
        try {
            Field field = FieldUtils.getField(clientTable.getClass(), (String)"marshallers", (boolean)true);
            MarshallersProvider marshallersProvider = (MarshallersProvider)FieldUtils.readField((Field)field, (Object)clientTable);
            ExtendedMarshallerProvider patchedProvider = new ExtendedMarshallerProvider(marshallersProvider);
            FieldUtils.writeField((Field)field, (Object)clientTable, (Object)patchedProvider);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        ClientSchema latestSchema = null;
        try {
            latestSchema = ClientAdapter.getLatestSchemaForTable(clientTable).get(20L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
        catch (ExecutionException | TimeoutException e) {
            throw new RuntimeException(e);
        }
        TableTypeDescriptor tblDsc = this.tableTypeRegistry.typesForTable(clientTable.name());
        Map.Entry types = null;
        try {
            assert (tblDsc != null);
            types = TableTypeRegistryUtils.typesToEntry((TableTypeDescriptor)tblDsc);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        Mapper<?> keyMapper = this.mapperUtils.createMapper(latestSchema, (Class)types.getKey(), TuplePart.KEY);
        Mapper<?> valueMapper = this.mapperUtils.createMapper(latestSchema, (Class)types.getValue(), TuplePart.VAL);
        CacheTableReference cacheTableRef = new CacheTableReference(name, valueMapper.targetType().getSimpleName());
        return new CacheAdapter(this, this.client.sql(), clientTable, keyMapper, valueMapper, this.transactionAdapter::getCurrentTx, cacheTableRef);
    }

    public <K, V> CompletableFuture<CacheAdapter<K, V>> createCache(CacheConfiguration<K, V> cacheCfg) {
        return ((CompletableFuture)CompletableFuture.supplyAsync(() -> this.createTableAndTypeHints(cacheCfg)).thenCompose(futureTable -> futureTable)).handle((none, err) -> {
            if (err != null) {
                ClientAdapter.mapExceptionInFuture(cacheCfg.getName()).apply((Throwable)err);
            }
            return this.cache(cacheCfg.getName());
        });
    }

    public <K, V> CompletableFuture<Map.Entry<ClientTable, SqlDdlGenerator.GenerateTableResult>> createTableAndTypeHints(CacheConfiguration<K, V> cacheCfg) {
        try {
            SqlDdlGenerator.GenerateTableResult res = this.sqlGenerator.generate(cacheCfg);
            return this.client.catalog().createTableAsync(res.tableDefinition()).thenApply(table -> {
                String actualTableName = table.name();
                this.tableTypeRegistry.registerTypesForTable(actualTableName, res.tableTypeDescriptor());
                return Map.entry((ClientTable)table, res);
            });
        }
        catch (FieldNameConflictException e) {
            return CompletableFuture.failedFuture(e);
        }
    }

    public <K, V> CompletableFuture<CacheAdapter<K, V>> getOrCreateCache(CacheConfiguration<K, V> cacheCfg) {
        CacheAdapter<K, V> cache = this.cache(cacheCfg.getName());
        if (cache != null) {
            return CompletableFuture.completedFuture(cache);
        }
        return this.createCache(cacheCfg);
    }

    public CompletableFuture<Collection<String>> cacheNames() {
        return this.client.tables().tablesAsync().thenApply(tables -> tables.stream().map(Table::name).map(name -> QualifiedName.parse((String)name).objectName()).filter(name -> !Namespace.isTableFromNamespace((String)name)).collect(Collectors.toList()));
    }

    public CompletableFuture<Void> destroyCache(String cacheName) {
        return ((CompletableFuture)this.client.sql().executeAsync(null, "DROP TABLE \"" + cacheName + "\";", new Object[0]).exceptionally(ClientAdapter.mapExceptionInFuture(cacheName))).thenAccept(r -> {});
    }

    public void close() throws Exception {
        this.client.close();
    }

    public static CompletableFuture<ClientSchema> getLatestSchemaForTable(ClientTable clientTable) {
        try {
            return (CompletableFuture)GET_LATEST_SCHEMA_METHOD.invoke((Object)clientTable, new Object[0]);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            return CompletableFuture.failedFuture(e);
        }
    }

    static {
        try {
            GET_LATEST_SCHEMA_METHOD = ClientTable.class.getDeclaredMethod("getLatestSchema", new Class[0]);
            GET_LATEST_SCHEMA_METHOD.setAccessible(true);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }
}

