/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.ignite.migrationtools.adapter.compute;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Arrays;
import java.util.concurrent.CompletableFuture;
import javax.cache.processor.EntryProcessor;
import org.apache.ignite.compute.ComputeJob;
import org.apache.ignite.compute.JobExecutionContext;
import org.apache.ignite.table.KeyValueView;
import org.gridgain.ignite.migrationtools.adapter.compute.GenericEntry;
import org.jetbrains.annotations.Nullable;

public class MappedEntryProcessorComputeJob
implements ComputeJob<Object, Object> {
    private static EntryProcessor createEntryProcessor(String className) {
        try {
            Class<?> processorKlass = Class.forName(className);
            return (EntryProcessor)processorKlass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private Object execute(JobExecutionContext context, Object ... args) {
        String processClassName = (String)args[0];
        String tableName = (String)args[1];
        String keyClassName = (String)args[2];
        String valueClassName = (String)args[3];
        byte[] keyPayload = (byte[])args[4];
        Object[] remainingArgs = Arrays.copyOfRange(args, 5, args.length);
        Class<?> keyClass = null;
        Class<?> valueClass = null;
        try {
            keyClass = Class.forName(keyClassName);
            valueClass = Class.forName(valueClassName);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        KeyValueView table = context.ignite().tables().table(tableName).keyValueView(keyClass, valueClass);
        Object key = this.deserializeObject(keyPayload);
        Object value = table.get(null, key);
        EntryProcessor processorInstance = MappedEntryProcessorComputeJob.createEntryProcessor(processClassName);
        GenericEntry mutableEntry = new GenericEntry(key, value);
        Object ret = processorInstance.process(mutableEntry, remainingArgs);
        Object newValue = mutableEntry.getValue();
        table.put(null, key, newValue);
        return ret;
    }

    private <T> T deserializeObject(byte[] payload) {
        try {
            ObjectInputStream ois = new ObjectInputStream(new ByteArrayInputStream(payload));
            return (T)ois.readObject();
        }
        catch (IOException | ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    @Nullable
    public CompletableFuture<Object> executeAsync(JobExecutionContext context, @Nullable Object o) {
        return CompletableFuture.supplyAsync(() -> this.execute(context, o));
    }
}

