/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.ignite.migrationtools.adapter.compute;

import java.io.Serializable;
import java.util.concurrent.CompletableFuture;
import org.apache.ignite.compute.ComputeJob;
import org.apache.ignite.compute.JobExecutionContext;
import org.apache.ignite.lang.IgniteClosure;
import org.apache.ignite.marshalling.Marshaller;
import org.gridgain.ignite.migrationtools.adapter.compute.marshallers.JdkMarshallerImpl;
import org.jetbrains.annotations.Nullable;

public class IgniteClosureComputeJob<I, R>
implements ComputeJob<Input<I, R>, R> {
    @Nullable
    public CompletableFuture<R> executeAsync(JobExecutionContext jobExecutionContext, @Nullable Input<I, R> irInput) {
        assert (irInput != null) : "rCallable must not be null";
        Object ret = null;
        try {
            ret = irInput.fun.apply(irInput.args);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return CompletableFuture.completedFuture(ret);
    }

    @Nullable
    public Marshaller<Input<I, R>, byte[]> inputMarshaller() {
        return new JdkMarshallerImpl<Input<I, R>>();
    }

    @Nullable
    public Marshaller<R, byte[]> resultMarshaller() {
        return new JdkMarshallerImpl();
    }

    public static class Input<I, R>
    implements Serializable {
        IgniteClosure<I, R> fun;
        I args;

        public Input(IgniteClosure<I, R> fun, I args) {
            this.fun = fun;
            this.args = args;
        }
    }
}

