/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.ignite.migrationtools.adapter.compute;

import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.concurrent.CompletableFuture;
import org.apache.commons.lang3.reflect.ConstructorUtils;
import org.apache.commons.lang3.reflect.MethodUtils;
import org.apache.ignite.compute.ComputeJob;
import org.apache.ignite.compute.JobExecutionContext;
import org.apache.ignite.table.KeyValueView;
import org.apache.ignite.table.Tuple;
import org.codehaus.plexus.classworlds.ClassWorld;
import org.codehaus.plexus.classworlds.realm.ClassRealm;
import org.codehaus.plexus.classworlds.realm.DuplicateRealmException;
import org.jetbrains.annotations.Nullable;

public class BinaryEntryProcessorComputeJob
implements ComputeJob<Object, Object> {
    public static final String TUPLE_BINARY_OBJECT_IMPL = "org.gridgain.ignite.migrationtools.adapter.binary.TupleBinaryObjectImpl";
    private static ClassRealm AI2_REAM;

    private static Object createProcessor(String processClassName) throws ClassNotFoundException, NoSuchMethodException, InvocationTargetException, InstantiationException, IllegalAccessException {
        Class processorKlass = AI2_REAM.loadClass(processClassName);
        Constructor provider = processorKlass.getDeclaredConstructor(new Class[0]);
        provider.setAccessible(true);
        return provider.newInstance(new Object[0]);
    }

    private Object execute(JobExecutionContext context, Object ... args) {
        String processClassName = (String)args[0];
        String tableName = (String)args[1];
        int numPkArgs = (Integer)args[2];
        Tuple keyTuple = Tuple.create((int)numPkArgs);
        for (int i = 0; i < numPkArgs; ++i) {
            int keyIdx = 3 + 2 * i;
            keyTuple.set((String)args[keyIdx], args[keyIdx + 1]);
        }
        Object[] remainingArgs = Arrays.copyOfRange(args, 2 * numPkArgs + 3, args.length);
        KeyValueView table = context.ignite().tables().table(tableName).keyValueView();
        Tuple valueTuple = (Tuple)table.get(null, (Object)keyTuple);
        try {
            Object processorInstance = BinaryEntryProcessorComputeJob.createProcessor(processClassName);
            Object keyObject = this.wrapTupleInBinaryObject(keyTuple);
            Object valueObj = this.wrapTupleInBinaryObject(valueTuple);
            Class entry = AI2_REAM.loadClass("org.gridgain.ignite.migrationtools.adapter.compute.GenericEntry");
            Object mutableEntry = ConstructorUtils.invokeConstructor((Class)entry, (Object[])new Object[]{keyObject, valueObj});
            System.out.println("Executing processor...");
            Object ret = MethodUtils.invokeMethod((Object)processorInstance, (String)"process", (Object[])new Object[]{mutableEntry, remainingArgs});
            System.out.println("Finished executing processor");
            Tuple newValue = this.unwrapTupleFromBinaryObject(valueTuple, MethodUtils.invokeMethod((Object)mutableEntry, (String)"getValue"));
            table.put(null, (Object)keyTuple, (Object)newValue);
            return ret;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    @Nullable
    public CompletableFuture executeAsync(JobExecutionContext context, @Nullable Object o) {
        return CompletableFuture.supplyAsync(() -> this.execute(context, o));
    }

    private Object wrapTupleInBinaryObject(Tuple tuple) {
        if (tuple.columnCount() == 1) {
            return tuple.value(0);
        }
        try {
            Class tupleClass = AI2_REAM.loadClass(TUPLE_BINARY_OBJECT_IMPL);
            Constructor constructor = tupleClass.getDeclaredConstructor(Tuple.class);
            return constructor.newInstance(tuple);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private Tuple unwrapTupleFromBinaryObject(Tuple tuple, Object wrappedValue) {
        if (TUPLE_BINARY_OBJECT_IMPL.equals(wrappedValue.getClass().getName())) {
            try {
                return (Tuple)MethodUtils.invokeMethod((Object)wrappedValue, (String)"getActual");
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
        Tuple ret = Tuple.copy((Tuple)tuple);
        return ret.set(tuple.columnName(0), wrappedValue);
    }

    static {
        ClassWorld world = new ClassWorld();
        try {
            ClassRealm ai3 = world.newRealm("parent-realm", BinaryEntryProcessorComputeJob.class.getClassLoader(), "org.apache.ignite.table.Tuple"::equals);
            String baseFolder = System.getenv("IGNITE_INTERFACE_ADAPTER_COMPUTE_FOLDER");
            if (baseFolder == null) {
                throw new RuntimeException("Empty environment variable: IGNITE_INTERFACE_ADAPTER_COMPUTE_FOLDER");
            }
            AI2_REAM = world.newRealm("ignite-2-realm", null);
            File base = new File(baseFolder);
            for (File jarFile : base.listFiles((dir, name) -> name.endsWith(".jar"))) {
                URL url = jarFile.toURI().toURL();
                AI2_REAM.addURL(url);
            }
            AI2_REAM.setParentRealm(ai3);
            AI2_REAM.display();
        }
        catch (MalformedURLException | DuplicateRealmException e) {
            throw new RuntimeException(e);
        }
    }
}

