/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.ignite.migrationtools.adapter.compute.marshallers;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.apache.ignite.marshalling.Marshaller;
import org.apache.ignite.marshalling.UnsupportedObjectTypeMarshallingException;
import org.jetbrains.annotations.Nullable;

public class JdkMarshallerImpl<T>
implements Marshaller<T, byte[]> {
    /*
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public byte[] marshal(@Nullable T obj) throws UnsupportedObjectTypeMarshallingException {
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            byte[] byArray;
            try (ObjectOutputStream oos = new ObjectOutputStream(baos);){
                oos.writeObject(obj);
                oos.flush();
                byArray = baos.toByteArray();
            }
            return byArray;
        }
        catch (IOException e) {
            throw new UnsupportedObjectTypeMarshallingException("Error while marshalling object", (Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public T unmarshal(@Nullable byte[] bytes) throws UnsupportedObjectTypeMarshallingException {
        if (bytes == null) {
            throw new UnsupportedObjectTypeMarshallingException("payload is null");
        }
        try (ObjectInputStream ois = new ObjectInputStream(new ByteArrayInputStream(bytes));){
            Object o;
            Object object = o = ois.readObject();
            return (T)object;
        }
        catch (IOException | ClassNotFoundException e) {
            throw new UnsupportedObjectTypeMarshallingException("Error while unmarshalling object", (Throwable)e);
        }
    }
}

