/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.ignite.migrationtools.adapter.internal;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.concurrent.CompletionStage;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteProxy;
import org.apache.ignite.client.ClientCache;
import org.apache.ignite.client.ClientCacheConfiguration;
import org.apache.ignite.client.ClientCacheProxy;
import org.apache.ignite.client.IgniteClient;
import org.apache.ignite.client.IgniteClientFuture;
import org.apache.ignite.client.IgniteClientProxy;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.internal.client.thin.IgniteClientFutureImpl;

public class ProxyUtils {
    private ProxyUtils() {
    }

    public static Ignite createProxy(IgniteProxy adapter) {
        return (Ignite)Proxy.newProxyInstance(ProxyUtils.class.getClassLoader(), new Class[]{Ignite.class}, new ProxiedInvocationHandler<IgniteProxy>(adapter));
    }

    public static IgniteClient createProxy(final IgniteClientProxy adapter) {
        Method clientConfigurationConverter;
        final Class<?> adapterKlass = adapter.getClass();
        ClassLoader guestLoader = adapterKlass.getClassLoader();
        try {
            Class<?> cliAdapter = Class.forName("org.gridgain.ignite.migrationtools.adapter.core.internal.IgniteClientAdapter", false, guestLoader);
            clientConfigurationConverter = cliAdapter.getMethod("convert", Object.class);
        }
        catch (ClassNotFoundException | NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
        return (IgniteClient)Proxy.newProxyInstance(ProxyUtils.class.getClassLoader(), new Class[]{IgniteClient.class}, new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                Class<?>[] paramTypes = method.getParameterTypes();
                Class[] newParamTypes = new Class[paramTypes.length];
                Object[] newArgs = args != null ? new Object[args.length] : null;
                for (int i = 0; i < paramTypes.length; ++i) {
                    Object newArg;
                    Class newParamType;
                    Class<?> paramType = paramTypes[i];
                    Object arg = args[i];
                    if (paramType == ClientCacheConfiguration.class) {
                        newParamType = CacheConfiguration.class;
                        newArg = clientConfigurationConverter.invoke(null, arg);
                    } else {
                        newParamType = paramType;
                        newArg = arg;
                    }
                    newParamTypes[i] = newParamType;
                    newArgs[i] = newArg;
                }
                Method targetMethod = adapterKlass.getMethod(method.getName(), newParamTypes);
                Class<?> targetReturnType = targetMethod.getReturnType();
                try {
                    Object retObj = targetMethod.invoke((Object)adapter, newArgs);
                    if (targetReturnType == ClientCacheProxy.class) {
                        return Proxy.newProxyInstance(ProxyUtils.class.getClassLoader(), new Class[]{ClientCache.class}, new ProxiedInvocationHandler<Object>(retObj));
                    }
                    if (targetReturnType == IgniteClientFuture.class) {
                        CompletionStage nf = ((IgniteClientFuture)retObj).thenApply(v -> {
                            if (v != null && ClientCacheProxy.class.isInstance(v)) {
                                return Proxy.newProxyInstance(ProxyUtils.class.getClassLoader(), new Class[]{ClientCache.class}, new ProxiedInvocationHandler<Object>(retObj));
                            }
                            return v;
                        });
                        return new IgniteClientFutureImpl(nf);
                    }
                    return retObj;
                }
                catch (InvocationTargetException ex) {
                    throw ex.getCause();
                }
            }
        });
    }

    private static class ProxiedInvocationHandler<T>
    implements InvocationHandler {
        private final T target;
        private final Class<?> targetClass;

        public ProxiedInvocationHandler(T target) {
            this.target = target;
            this.targetClass = target.getClass();
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            Method targetMethod = this.targetClass.getMethod(method.getName(), method.getParameterTypes());
            try {
                return targetMethod.invoke(this.target, args);
            }
            catch (InvocationTargetException ex) {
                throw ex.getCause();
            }
        }
    }
}

