/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.ignite.migrationtools.adapter;

import java.nio.file.ProviderNotFoundException;
import java.util.ServiceLoader;
import org.apache.commons.lang3.concurrent.ConcurrentException;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteProxy;
import org.gridgain.ignite.migrationtools.adapter.clients.IgniteAdapterOptions;
import org.gridgain.ignite.migrationtools.adapter.factories.IgniteAdapterFactory;
import org.gridgain.ignite.migrationtools.adapter.internal.ClassloaderUtils;
import org.gridgain.ignite.migrationtools.adapter.internal.ProxyUtils;
import org.gridgain.ignite.migrationtools.commons.tablemanagement.TableTypeRegistry;
import org.jetbrains.annotations.Nullable;

public interface IgniteAdapter {
    public static Builder builder(String address) {
        return new Builder(address);
    }

    public static class Builder {
        private final String address;
        private boolean allowExtraFields;
        private boolean allowNonDefaultConstructors;

        public Builder(String address) {
            this.address = address;
            this.allowExtraFields = false;
            this.allowNonDefaultConstructors = false;
        }

        public Builder allowExtraFields(boolean allowExtraFields) {
            this.allowExtraFields = allowExtraFields;
            return this;
        }

        public Builder allowNonDefaultConstructors(boolean allowNonDefaultConstructors) {
            this.allowNonDefaultConstructors = allowNonDefaultConstructors;
            return this;
        }

        public Ignite build() {
            ClassLoader classloader = null;
            try {
                classloader = (ClassLoader)ClassloaderUtils.CLASS_LOADER_LAZY_INITIALIZER.get();
            }
            catch (ConcurrentException e) {
                throw new RuntimeException(e.getCause());
            }
            IgniteAdapterFactory adapterFactory = ServiceLoader.load(IgniteAdapterFactory.class, classloader).findFirst().orElseThrow(() -> new ProviderNotFoundException("Provider for '" + IgniteAdapterFactory.class.getName() + "' was not found!"));
            IgniteProxy adapter = adapterFactory.create(this.address, new IgniteAdapterOptions(){

                @Nullable
                public TableTypeRegistry tableTypeRegistry() {
                    return null;
                }

                public boolean allowExtraFields() {
                    return allowExtraFields;
                }

                public boolean allowNonDefaultConstructors() {
                    return allowNonDefaultConstructors;
                }
            });
            return ProxyUtils.createProxy(adapter);
        }
    }
}

