/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.ignite.migrationtools.adapter.internal;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.concurrent.ConcurrentException;
import org.apache.commons.lang3.concurrent.LazyInitializer;

public class ClassloaderUtils {
    public static final LazyInitializer<ClassLoader> CLASS_LOADER_LAZY_INITIALIZER = new LazyInitializer<ClassLoader>(){

        protected ClassLoader initialize() throws ConcurrentException {
            ClassLoader classLoader;
            block19: {
                Set importedClasses;
                InputStream is;
                final ClassLoader hostClassLoader = ClassloaderUtils.class.getClassLoader();
                try {
                    is = hostClassLoader.getResourceAsStream("classloader-imports");
                    try {
                        if (is == null) {
                            throw new IllegalStateException("Could not find class import list.");
                        }
                        importedClasses = IOUtils.readLines((InputStream)is, (Charset)StandardCharsets.UTF_8).stream().map(String::trim).collect(Collectors.toSet());
                    }
                    finally {
                        if (is != null) {
                            is.close();
                        }
                    }
                }
                catch (IOException ex) {
                    throw new ConcurrentException((Throwable)ex);
                }
                is = hostClassLoader.getResourceAsStream("rt-classpath");
                try {
                    ClassLoader guestClassloader;
                    if (is == null) {
                        throw new IllegalStateException("Could not find embedded cluster dependencies");
                    }
                    List lines = IOUtils.readLines((InputStream)is, (Charset)StandardCharsets.UTF_8);
                    final URL[] deps = (URL[])lines.stream().map(l -> {
                        try {
                            return Path.of(l, new String[0]).toUri().toURL();
                        }
                        catch (MalformedURLException e) {
                            throw new RuntimeException(e);
                        }
                    }).toArray(URL[]::new);
                    classLoader = guestClassloader = AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

                        @Override
                        public ClassLoader run() {
                            return new URLClassLoader(deps, URLClassLoader.getPlatformClassLoader()){

                                @Override
                                protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
                                    if (importedClasses.contains(name)) {
                                        return hostClassLoader.loadClass(name);
                                    }
                                    return super.loadClass(name, resolve);
                                }

                                @Override
                                protected Class<?> findClass(String name) throws ClassNotFoundException {
                                    if (importedClasses.contains(name)) {
                                        return hostClassLoader.loadClass(name);
                                    }
                                    return super.findClass(name);
                                }
                            };
                        }
                    });
                    if (is == null) break block19;
                }
                catch (Throwable throwable) {
                    try {
                        if (is != null) {
                            try {
                                is.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        throw new ConcurrentException((Throwable)e);
                    }
                }
                is.close();
            }
            return classLoader;
        }
    };
}

