/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.spi.discovery.zk.internal;

import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.events.DiscoveryEvent;
import org.apache.ignite.internal.util.lang.GridAbsPredicate;
import org.apache.ignite.internal.util.typedef.T2;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteCallable;
import org.apache.ignite.spi.discovery.DiscoverySpi;
import org.apache.ignite.spi.discovery.zk.ZookeeperDiscoverySpi;
import org.apache.ignite.spi.discovery.zk.internal.ZookeeperClient;
import org.apache.ignite.testframework.GridTestUtils;
import org.apache.zookeeper.ZooKeeper;
import org.junit.Assert;

class ZookeeperDiscoverySpiTestHelper {
    static final String IGNITE_ZK_ROOT = "/apacheIgnite";
    private static final ThreadLocal<Boolean> clientThreadLoc = new ThreadLocal();
    private final Consumer<String> info;
    private final AtomicInteger clusterNum;
    private boolean client;

    ZookeeperDiscoverySpiTestHelper(Consumer<String> info, AtomicInteger clusterNum) {
        this.info = info;
        this.clusterNum = clusterNum;
    }

    void clientMode(boolean clientMode) {
        this.client = clientMode;
    }

    boolean clientMode() {
        return this.client;
    }

    void clientModeThreadLocal(boolean clientMode) {
        clientThreadLoc.set(clientMode);
    }

    Boolean clientModeThreadLocal() {
        return clientThreadLoc.get();
    }

    void clientModeThreadLocalReset() {
        clientThreadLoc.set(null);
    }

    static void ackEveryEventSystemProperty() {
        System.setProperty("IGNITE_ZOOKEEPER_DISCOVERY_SPI_ACK_THRESHOLD", "1");
    }

    void checkEvents(Ignite node, ConcurrentHashMap<UUID, Map<T2<Integer, Long>, DiscoveryEvent>> evts, DiscoveryEvent ... expEvts) throws Exception {
        this.checkEvents(node.cluster().localNode().id(), evts, expEvts);
    }

    private void checkEvents(final UUID nodeId, final ConcurrentHashMap<UUID, Map<T2<Integer, Long>, DiscoveryEvent>> evts, final DiscoveryEvent ... expEvts) throws Exception {
        Assert.assertTrue((boolean)GridTestUtils.waitForCondition((GridAbsPredicate)new GridAbsPredicate(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public boolean apply() {
                Map nodeEvts = (Map)evts.get(nodeId);
                if (nodeEvts == null) {
                    ZookeeperDiscoverySpiTestHelper.this.info.accept("No events for node: " + nodeId);
                    return false;
                }
                Map map = nodeEvts;
                synchronized (map) {
                    for (DiscoveryEvent expEvt : expEvts) {
                        DiscoveryEvent evt0 = (DiscoveryEvent)nodeEvts.get(new T2((Object)ZookeeperDiscoverySpiTestHelper.this.clusterNum.get(), (Object)expEvt.topologyVersion()));
                        if (evt0 == null) {
                            ZookeeperDiscoverySpiTestHelper.this.info.accept("No event for version: " + expEvt.topologyVersion());
                            return false;
                        }
                        Assert.assertEquals((String)("Unexpected event [topVer=" + expEvt.topologyVersion() + ", exp=" + U.gridEventName((int)expEvt.type()) + ", evt=" + evt0 + ']'), (long)expEvt.type(), (long)evt0.type());
                    }
                }
                return true;
            }
        }, (long)30000L));
    }

    static DiscoveryEvent joinEvent(long topVer) {
        DiscoveryEvent expEvt = new DiscoveryEvent(null, null, 10, null);
        expEvt.topologySnapshot(topVer, null);
        return expEvt;
    }

    static DiscoveryEvent failEvent(long topVer) {
        DiscoveryEvent expEvt = new DiscoveryEvent(null, null, 12, null);
        expEvt.topologySnapshot(topVer, null);
        return expEvt;
    }

    ZookeeperDiscoverySpi waitSpi(final String nodeName, final ConcurrentHashMap<String, ZookeeperDiscoverySpi> spis) throws Exception {
        GridTestUtils.waitForCondition((GridAbsPredicate)new GridAbsPredicate(){

            public boolean apply() {
                ZookeeperDiscoverySpi spi = (ZookeeperDiscoverySpi)spis.get(nodeName);
                return spi != null && GridTestUtils.getFieldValue((Object)spi, (String[])new String[]{"impl"}) != null;
            }
        }, (long)5000L);
        ZookeeperDiscoverySpi spi = spis.get(nodeName);
        Assert.assertNotNull((String)("Failed to get SPI for node: " + nodeName), (Object)spi);
        return spi;
    }

    static ZooKeeper zkClient(ZookeeperDiscoverySpi spi) {
        return (ZooKeeper)GridTestUtils.getFieldValue((Object)spi, (String[])new String[]{"impl", "rtState", "zkClient", "zk"});
    }

    static String aliveZkNodePath(DiscoverySpi spi) {
        String path = (String)GridTestUtils.getFieldValue((Object)spi, (String[])new String[]{"impl", "rtState", "locNodeZkPath"});
        return path.substring(path.lastIndexOf(47) + 1);
    }

    void waitForEventsAcks(final Ignite node) throws Exception {
        Assert.assertTrue((boolean)GridTestUtils.waitForCondition((GridAbsPredicate)new GridAbsPredicate(){

            public boolean apply() {
                Map evts = (Map)GridTestUtils.getFieldValue((Object)node.configuration().getDiscoverySpi(), (String[])new String[]{"impl", "rtState", "evtsData", "evts"});
                if (!evts.isEmpty()) {
                    ZookeeperDiscoverySpiTestHelper.this.info.accept("Unacked events: " + evts);
                    return false;
                }
                return true;
            }
        }, (long)10000L));
    }

    static void waitReconnectEvent(IgniteLogger log, CountDownLatch latch) throws Exception {
        if (!latch.await(30000L, TimeUnit.MILLISECONDS)) {
            log.error("Failed to wait for reconnect event, will dump threads, latch count: " + latch.getCount());
            U.dumpThreads((IgniteLogger)log);
            Assert.fail((String)"Failed to wait for disconnect/reconnect event.");
        }
    }

    static String aliveZkNodePath(Ignite node) {
        return ZookeeperDiscoverySpiTestHelper.aliveZkNodePath(node.configuration().getDiscoverySpi());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void waitNoAliveZkNodes(final IgniteLogger log, String connectStr, final List<String> failedZkNodes, long timeout) throws Exception {
        try (final ZookeeperClient zkClient = new ZookeeperClient(log, connectStr, 10000, null);){
            Assert.assertTrue((boolean)GridTestUtils.waitForCondition((GridAbsPredicate)new GridAbsPredicate(){

                public boolean apply() {
                    try {
                        List c = zkClient.getChildren("/apacheIgnite/n");
                        for (String failedZkNode : failedZkNodes) {
                            if (!c.contains(failedZkNode)) continue;
                            log.info("Alive node is not removed [node=" + failedZkNode + ", all=" + c + ']');
                            return false;
                        }
                        return true;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        Assert.fail();
                        return true;
                    }
                }
            }, (long)timeout));
        }
    }

    static class DummyCallable
    implements IgniteCallable<Object> {
        private byte[] data;

        DummyCallable(byte[] data) {
            this.data = data;
        }

        public Object call() throws Exception {
            return this.data;
        }
    }
}

