/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.spi.discovery.zk.internal;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.curator.test.TestingZooKeeperServer;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteState;
import org.apache.ignite.ShutdownPolicy;
import org.apache.ignite.cache.CacheAtomicityMode;
import org.apache.ignite.events.DiscoveryEvent;
import org.apache.ignite.events.Event;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.IgnitionEx;
import org.apache.ignite.internal.util.lang.GridAbsPredicate;
import org.apache.ignite.internal.util.typedef.T2;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgnitePredicate;
import org.apache.ignite.spi.discovery.DiscoverySpi;
import org.apache.ignite.spi.discovery.zk.ZookeeperDiscoverySpi;
import org.apache.ignite.spi.discovery.zk.ZookeeperDiscoverySpiTestUtil;
import org.apache.ignite.spi.discovery.zk.internal.ZookeeperDiscoverySpiTestBase;
import org.apache.ignite.spi.discovery.zk.internal.ZookeeperDiscoverySpiTestHelper;
import org.apache.ignite.testframework.GridTestUtils;
import org.apache.ignite.transactions.Transaction;
import org.apache.ignite.transactions.TransactionConcurrency;
import org.apache.ignite.transactions.TransactionIsolation;
import org.apache.zookeeper.ZkTestClientCnxnSocketNIO;
import org.apache.zookeeper.ZooKeeper;
import org.junit.Ignore;
import org.junit.Test;

public class ZookeeperDiscoverySegmentationAndConnectionRestoreTest
extends ZookeeperDiscoverySpiTestBase {
    @Test
    public void testStopNodeOnSegmentaion() throws Exception {
        this.sesTimeout = 2000L;
        this.testSockNio = true;
        this.persistence = true;
        this.atomicityMode = CacheAtomicityMode.TRANSACTIONAL;
        this.backups = 2;
        IgniteEx node0 = this.startGrid(0);
        this.sesTimeout = 10000L;
        this.testSockNio = false;
        this.startGrid(1);
        node0.cluster().active(true);
        this.helper.clientMode(true);
        final IgniteEx client = this.startGrid(2);
        client.transactions().txStart(TransactionConcurrency.PESSIMISTIC, TransactionIsolation.READ_COMMITTED, 0L, 0);
        client.cache("default").put((Object)0, (Object)0);
        GridTestUtils.runAsync((Runnable)new Runnable(){

            @Override
            public void run() {
                Transaction tx2 = client.transactions().txStart(TransactionConcurrency.OPTIMISTIC, TransactionIsolation.READ_COMMITTED, 0L, 0);
                client.cache("default").put((Object)0, (Object)0);
                tx2.commit();
            }
        });
        final CountDownLatch l = new CountDownLatch(1);
        node0.events().localListen((IgnitePredicate)new IgnitePredicate<Event>(){

            public boolean apply(Event evt) {
                l.countDown();
                return false;
            }
        }, new int[]{14});
        ZkTestClientCnxnSocketNIO c0 = ZkTestClientCnxnSocketNIO.forNode((Ignite)node0);
        c0.closeSocket(true);
        for (int i = 0; i < 10; ++i) {
            Thread.sleep(1000L);
            if (l.getCount() == 0L) break;
        }
        this.info("Allow connect");
        c0.allowConnect();
        ZookeeperDiscoverySegmentationAndConnectionRestoreTest.assertTrue((boolean)l.await(10L, TimeUnit.SECONDS));
        this.waitForNodeStop(node0.name());
        this.checkStoppedNodeThreads(node0.name());
    }

    private void checkStoppedNodeThreads(String nodeName) {
        Set<Thread> threads = Thread.getAllStackTraces().keySet();
        for (Thread t : threads) {
            if (t.getName().contains(nodeName)) {
                throw new AssertionError((Object)("Thread from stopped node has been found: " + t.getName()));
            }
        }
    }

    private void waitForNodeStop(String name) throws Exception {
        while (IgnitionEx.state((String)name) == IgniteState.STARTED) {
            Thread.sleep(2000L);
        }
    }

    @Test
    public void testSegmentation1() throws Exception {
        this.sesTimeout = 2000L;
        this.testSockNio = true;
        IgniteEx node0 = this.startGrid(0);
        final CountDownLatch l = new CountDownLatch(1);
        node0.events().localListen((IgnitePredicate)new IgnitePredicate<Event>(){

            public boolean apply(Event evt) {
                l.countDown();
                return false;
            }
        }, new int[]{14});
        ZkTestClientCnxnSocketNIO c0 = ZkTestClientCnxnSocketNIO.forNode((Ignite)node0);
        c0.closeSocket(true);
        for (int i = 0; i < 10; ++i) {
            Thread.sleep(1000L);
            if (l.getCount() == 0L) break;
        }
        this.info("Allow connect");
        c0.allowConnect();
        ZookeeperDiscoverySegmentationAndConnectionRestoreTest.assertTrue((boolean)l.await(10L, TimeUnit.SECONDS));
    }

    @Test
    public void testSegmentation2() throws Exception {
        this.sesTimeout = 2000L;
        IgniteEx node0 = this.startGrid(0);
        final CountDownLatch l = new CountDownLatch(1);
        node0.events().localListen((IgnitePredicate)new IgnitePredicate<Event>(){

            public boolean apply(Event evt) {
                l.countDown();
                return false;
            }
        }, new int[]{14});
        try {
            zkCluster.close();
            ZookeeperDiscoverySegmentationAndConnectionRestoreTest.assertTrue((boolean)l.await(10L, TimeUnit.SECONDS));
        }
        finally {
            zkCluster = ZookeeperDiscoverySpiTestUtil.createTestingCluster(3);
            zkCluster.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSegmentation3() throws Exception {
        this.sesTimeout = 5000L;
        IgniteEx node0 = this.startGrid(0);
        final CountDownLatch l = new CountDownLatch(1);
        node0.events().localListen((IgnitePredicate)new IgnitePredicate<Event>(){

            public boolean apply(Event evt) {
                l.countDown();
                return false;
            }
        }, new int[]{14});
        List srvs = zkCluster.getServers();
        ZookeeperDiscoverySegmentationAndConnectionRestoreTest.assertEquals((int)3, (int)srvs.size());
        try {
            ((TestingZooKeeperServer)srvs.get(0)).stop();
            ((TestingZooKeeperServer)srvs.get(1)).stop();
            ZookeeperDiscoverySegmentationAndConnectionRestoreTest.assertTrue((boolean)l.await(60000L, TimeUnit.MILLISECONDS));
        }
        finally {
            zkCluster.close();
            zkCluster = ZookeeperDiscoverySpiTestUtil.createTestingCluster(3);
            zkCluster.start();
        }
    }

    @Ignore(value="https://issues.apache.org/jira/browse/IGNITE-8178")
    @Test
    public void testQuorumRestore() throws Exception {
        this.sesTimeout = 60000L;
        this.startGrids(3);
        this.waitForTopology(3);
        List srvs = zkCluster.getServers();
        ZookeeperDiscoverySegmentationAndConnectionRestoreTest.assertEquals((int)3, (int)srvs.size());
        try {
            ((TestingZooKeeperServer)srvs.get(0)).stop();
            ((TestingZooKeeperServer)srvs.get(1)).stop();
            U.sleep((long)2000L);
            ((TestingZooKeeperServer)srvs.get(1)).restart();
            U.sleep((long)4000L);
            this.startGrid(4);
            this.waitForTopology(4);
        }
        finally {
            zkCluster.close();
            zkCluster = ZookeeperDiscoverySpiTestUtil.createTestingCluster(3);
            zkCluster.start();
        }
    }

    @Test
    public void testConnectionRestore1() throws Exception {
        this.testSockNio = true;
        IgniteEx node0 = this.startGrid(0);
        ZkTestClientCnxnSocketNIO c0 = ZkTestClientCnxnSocketNIO.forNode((Ignite)node0);
        c0.closeSocket(false);
        this.startGrid(1);
    }

    @Test
    public void testConnectionRestore2() throws Exception {
        this.testSockNio = true;
        IgniteEx node0 = this.startGrid(0);
        ZkTestClientCnxnSocketNIO c0 = ZkTestClientCnxnSocketNIO.forNode((Ignite)node0);
        c0.closeSocket(false);
        this.startGridsMultiThreaded(1, 5);
    }

    @Test
    public void testConnectionRestore_NonCoordinator1() throws Exception {
        this.connectionRestore_NonCoordinator(false);
    }

    @Test
    public void testConnectionRestore_NonCoordinator2() throws Exception {
        this.connectionRestore_NonCoordinator(true);
    }

    private void connectionRestore_NonCoordinator(boolean failWhenDisconnected) throws Exception {
        this.testSockNio = true;
        IgniteEx node0 = this.startGrid(0);
        IgniteEx node1 = this.startGrid(1);
        ZkTestClientCnxnSocketNIO c1 = ZkTestClientCnxnSocketNIO.forNode((Ignite)node1);
        c1.closeSocket(true);
        IgniteInternalFuture fut = GridTestUtils.runAsync((Callable)new Callable<Void>(){

            @Override
            public Void call() {
                try {
                    ZookeeperDiscoverySegmentationAndConnectionRestoreTest.this.startGrid(2);
                }
                catch (Exception e) {
                    ZookeeperDiscoverySegmentationAndConnectionRestoreTest.this.info("Start error: " + e);
                }
                return null;
            }
        }, (String)"start-node");
        this.helper.checkEvents((Ignite)node0, (ConcurrentHashMap<UUID, Map<T2<Integer, Long>, DiscoveryEvent>>)evts, ZookeeperDiscoverySpiTestHelper.joinEvent(3L));
        if (failWhenDisconnected) {
            ZookeeperDiscoverySpi spi = (ZookeeperDiscoverySpi)this.spis.get(this.getTestIgniteInstanceName(2));
            ZookeeperDiscoverySegmentationAndConnectionRestoreTest.closeZkClient(spi);
            this.helper.checkEvents((Ignite)node0, (ConcurrentHashMap<UUID, Map<T2<Integer, Long>, DiscoveryEvent>>)evts, ZookeeperDiscoverySpiTestHelper.failEvent(4L));
        }
        c1.allowConnect();
        this.helper.checkEvents((Ignite)this.ignite(1), (ConcurrentHashMap<UUID, Map<T2<Integer, Long>, DiscoveryEvent>>)evts, ZookeeperDiscoverySpiTestHelper.joinEvent(3L));
        if (failWhenDisconnected) {
            this.helper.checkEvents((Ignite)this.ignite(1), (ConcurrentHashMap<UUID, Map<T2<Integer, Long>, DiscoveryEvent>>)evts, ZookeeperDiscoverySpiTestHelper.failEvent(4L));
            IgnitionEx.stop((String)this.getTestIgniteInstanceName(2), (boolean)true, (ShutdownPolicy)ShutdownPolicy.IMMEDIATE, (boolean)true);
        }
        fut.get();
        this.waitForTopology(failWhenDisconnected ? 2 : 3);
    }

    @Test
    public void testConnectionRestore_Coordinator1() throws Exception {
        this.connectionRestore_Coordinator(1, 1, 0);
    }

    @Test
    public void testConnectionRestore_Coordinator1_1() throws Exception {
        this.connectionRestore_Coordinator(1, 1, 1);
    }

    @Test
    public void testConnectionRestore_Coordinator2() throws Exception {
        this.connectionRestore_Coordinator(1, 3, 0);
    }

    @Test
    public void testConnectionRestore_Coordinator3() throws Exception {
        this.connectionRestore_Coordinator(3, 3, 0);
    }

    @Test
    public void testConnectionRestore_Coordinator4() throws Exception {
        this.connectionRestore_Coordinator(3, 3, 1);
    }

    private void connectionRestore_Coordinator(int initNodes, int startNodes, int failCnt) throws Exception {
        this.sesTimeout = 30000L;
        this.testSockNio = true;
        IgniteEx node0 = this.startGrids(initNodes);
        ZkTestClientCnxnSocketNIO c0 = ZkTestClientCnxnSocketNIO.forNode((Ignite)node0);
        c0.closeSocket(true);
        final AtomicInteger nodeIdx = new AtomicInteger(initNodes);
        IgniteInternalFuture fut = GridTestUtils.runMultiThreadedAsync((Callable)new Callable<Void>(){

            @Override
            public Void call() {
                try {
                    ZookeeperDiscoverySegmentationAndConnectionRestoreTest.this.startGrid(nodeIdx.getAndIncrement());
                }
                catch (Exception e) {
                    ZookeeperDiscoverySegmentationAndConnectionRestoreTest.this.error("Start failed: " + e);
                }
                return null;
            }
        }, (int)startNodes, (String)"start-node");
        int cnt = 0;
        DiscoveryEvent[] expEvts = new DiscoveryEvent[startNodes - failCnt];
        int expEvtCnt = 0;
        this.sesTimeout = 1000L;
        ArrayList<ZkTestClientCnxnSocketNIO> blockedC = new ArrayList<ZkTestClientCnxnSocketNIO>();
        ArrayList<String> failedZkNodes = new ArrayList<String>(failCnt);
        for (int i = initNodes; i < initNodes + startNodes; ++i) {
            final ZookeeperDiscoverySpi spi = this.helper.waitSpi(this.getTestIgniteInstanceName(i), this.spis);
            ZookeeperDiscoverySegmentationAndConnectionRestoreTest.assertTrue((boolean)GridTestUtils.waitForCondition((GridAbsPredicate)new GridAbsPredicate(){

                public boolean apply() {
                    Object spiImpl = GridTestUtils.getFieldValue((Object)spi, (String[])new String[]{"impl"});
                    if (spiImpl == null) {
                        return false;
                    }
                    long internalOrder = (Long)GridTestUtils.getFieldValue((Object)spiImpl, (String[])new String[]{"rtState", "internalOrder"});
                    return internalOrder > 0L;
                }
            }, (long)10000L));
            if (cnt++ < failCnt) {
                ZkTestClientCnxnSocketNIO c = ZkTestClientCnxnSocketNIO.forNode(this.getTestIgniteInstanceName(i));
                c.closeSocket(true);
                blockedC.add(c);
                failedZkNodes.add(ZookeeperDiscoverySpiTestHelper.aliveZkNodePath((DiscoverySpi)spi));
                continue;
            }
            expEvts[expEvtCnt] = ZookeeperDiscoverySpiTestHelper.joinEvent(initNodes + expEvtCnt + 1);
            ++expEvtCnt;
        }
        ZookeeperDiscoverySpiTestHelper.waitNoAliveZkNodes(log, zkCluster.getConnectString(), failedZkNodes, 30000L);
        c0.allowConnect();
        for (ZkTestClientCnxnSocketNIO c : blockedC) {
            c.allowConnect();
        }
        if (expEvts.length > 0) {
            for (int i = 0; i < initNodes; ++i) {
                this.helper.checkEvents((Ignite)this.ignite(i), (ConcurrentHashMap<UUID, Map<T2<Integer, Long>, DiscoveryEvent>>)evts, expEvts);
            }
        }
        fut.get();
        this.waitForTopology(initNodes + startNodes - failCnt);
    }

    private static void closeZkClient(ZookeeperDiscoverySpi spi) {
        ZooKeeper zk = ZookeeperDiscoverySpiTestHelper.zkClient(spi);
        try {
            zk.close();
        }
        catch (Exception e) {
            ZookeeperDiscoverySegmentationAndConnectionRestoreTest.fail((String)("Unexpected error: " + e));
        }
    }
}

