/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.spi.discovery.zk.internal;

import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.management.JMX;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.events.Event;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.util.typedef.X;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteInClosure;
import org.apache.ignite.lang.IgnitePredicate;
import org.apache.ignite.spi.IgniteSpiException;
import org.apache.ignite.spi.communication.tcp.TcpCommunicationSpi;
import org.apache.ignite.spi.discovery.zk.ZookeeperDiscoverySpi;
import org.apache.ignite.spi.discovery.zk.ZookeeperDiscoverySpiMBean;
import org.apache.ignite.spi.discovery.zk.ZookeeperDiscoverySpiTestUtil;
import org.apache.ignite.spi.discovery.zk.internal.ZookeeperDiscoverySpiTestBase;
import org.apache.ignite.spi.discovery.zk.internal.ZookeeperDiscoverySpiTestHelper;
import org.apache.ignite.testframework.GridTestUtils;
import org.apache.zookeeper.ZkTestClientCnxnSocketNIO;
import org.junit.Test;

public class ZookeeperDiscoveryClientDisconnectTest
extends ZookeeperDiscoverySpiTestBase {
    @Override
    protected IgniteConfiguration getConfiguration(String igniteInstanceName) throws Exception {
        IgniteConfiguration cfg = super.getConfiguration(igniteInstanceName);
        cfg.setFailureDetectionTimeout(2000L);
        cfg.setClientFailureDetectionTimeout(2000L);
        return cfg;
    }

    @Test
    public void testClientReconnects() throws Exception {
        this.blockCommSpi = true;
        IgniteEx srv1 = this.startGrid("server1-block");
        this.helper.clientModeThreadLocal(true);
        IgniteEx cli = this.startGrid("client-block");
        IgniteCache cache = cli.getOrCreateCache("default");
        cache.put((Object)1, (Object)1);
        ZookeeperDiscoveryClientDisconnectTest.assertEquals((Object)cache.get((Object)1), (Object)1);
        ZookeeperDiscoveryClientDisconnectTest.assertEquals((int)1, (int)srv1.cluster().forClients().nodes().size());
        MBeanServer srv = ManagementFactory.getPlatformMBeanServer();
        IgniteEx ignite = this.grid("server1-block");
        ObjectName spiName = U.makeMBeanName((String)ignite.context().igniteInstanceName(), (String)"SPIs", (String)ZookeeperDiscoverySpi.class.getSimpleName());
        ZookeeperDiscoverySpiMBean bean = JMX.newMBeanProxy(srv, spiName, ZookeeperDiscoverySpiMBean.class);
        ZookeeperDiscoveryClientDisconnectTest.assertNotNull((Object)bean);
        ZookeeperDiscoveryClientDisconnectTest.assertEquals((long)0L, (long)bean.getCommErrorProcNum());
    }

    @Test
    public void testConnectionCheck() throws Exception {
        int NODES = 5;
        this.startGridsMultiThreaded(5);
        for (int i = 0; i < 5; ++i) {
            IgniteEx node = this.ignite(i);
            TcpCommunicationSpi spi = (TcpCommunicationSpi)node.configuration().getCommunicationSpi();
            ArrayList nodes = new ArrayList(node.cluster().nodes());
            BitSet res = (BitSet)spi.checkConnection(nodes).get();
            for (int j = 0; j < 5; ++j) {
                ZookeeperDiscoveryClientDisconnectTest.assertTrue((boolean)res.get(j));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testReconnectDisabled_ConnectionLost() throws Exception {
        this.clientReconnectDisabled = true;
        this.startGrid(0);
        this.sesTimeout = 3000L;
        this.testSockNio = true;
        this.helper.clientMode(true);
        IgniteEx client = this.startGrid(1);
        final CountDownLatch latch = new CountDownLatch(1);
        client.events().localListen((IgnitePredicate)new IgnitePredicate<Event>(){

            public boolean apply(Event evt) {
                latch.countDown();
                return false;
            }
        }, new int[]{14});
        ZkTestClientCnxnSocketNIO nio = ZkTestClientCnxnSocketNIO.forNode((Ignite)client);
        nio.closeSocket(true);
        try {
            ZookeeperDiscoverySpiTestHelper.waitNoAliveZkNodes(log, zkCluster.getConnectString(), Collections.singletonList(ZookeeperDiscoverySpiTestHelper.aliveZkNodePath((Ignite)client)), 10000L);
        }
        finally {
            nio.allowConnect();
        }
        ZookeeperDiscoveryClientDisconnectTest.assertTrue((boolean)latch.await(10L, TimeUnit.SECONDS));
    }

    @Test
    public void testServersLeft_FailOnTimeout() throws Exception {
        this.startGrid(0);
        int CLIENTS = 5;
        this.joinTimeout = 3000L;
        this.helper.clientMode(true);
        this.startGridsMultiThreaded(1, 5);
        this.waitForTopology(6);
        final CountDownLatch latch = new CountDownLatch(5);
        for (int i = 0; i < 5; ++i) {
            IgniteEx node = this.ignite(i + 1);
            node.events().localListen((IgnitePredicate)new IgnitePredicate<Event>(){

                public boolean apply(Event evt) {
                    latch.countDown();
                    return false;
                }
            }, new int[]{14});
        }
        this.stopGrid(this.getTestIgniteInstanceName(0), true, false);
        ZookeeperDiscoveryClientDisconnectTest.assertTrue((boolean)latch.await(10L, TimeUnit.SECONDS));
        evts.clear();
    }

    @Test
    public void testStartNoServers_FailOnTimeout() {
        this.joinTimeout = 3000L;
        this.helper.clientMode(true);
        long start = System.currentTimeMillis();
        Throwable err = GridTestUtils.assertThrows((IgniteLogger)log, (Callable)new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                ZookeeperDiscoveryClientDisconnectTest.this.startGrid(0);
                return null;
            }
        }, IgniteCheckedException.class, null);
        ZookeeperDiscoveryClientDisconnectTest.assertTrue((System.currentTimeMillis() >= start + this.joinTimeout ? 1 : 0) != 0);
        IgniteSpiException spiErr = (IgniteSpiException)X.cause((Throwable)err, IgniteSpiException.class);
        ZookeeperDiscoveryClientDisconnectTest.assertNotNull((Object)spiErr);
        ZookeeperDiscoveryClientDisconnectTest.assertTrue((boolean)spiErr.getMessage().contains("Failed to connect to cluster within configured timeout"));
    }

    @Test
    public void testStartNoServer_WaitForServers1() throws Exception {
        this.startNoServer_WaitForServers(0L);
    }

    @Test
    public void testStartNoServer_WaitForServers2() throws Exception {
        this.startNoServer_WaitForServers(10000L);
    }

    private void startNoServer_WaitForServers(long joinTimeout) throws Exception {
        this.joinTimeout = joinTimeout;
        IgniteInternalFuture fut = GridTestUtils.runAsync((Callable)new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                ZookeeperDiscoveryClientDisconnectTest.this.helper.clientModeThreadLocal(true);
                ZookeeperDiscoveryClientDisconnectTest.this.startGrid(0);
                return null;
            }
        });
        U.sleep((long)3000L);
        this.helper.waitSpi(this.getTestIgniteInstanceName(0), this.spis);
        this.helper.clientModeThreadLocal(false);
        this.startGrid(1);
        fut.get();
        this.waitForTopology(2);
    }

    @Test
    public void testDisconnectOnServersLeft_1() throws Exception {
        this.disconnectOnServersLeft(1, 1);
    }

    @Test
    public void testDisconnectOnServersLeft_2() throws Exception {
        this.disconnectOnServersLeft(5, 1);
    }

    @Test
    public void testDisconnectOnServersLeft_3() throws Exception {
        this.disconnectOnServersLeft(1, 10);
    }

    @Test
    public void testDisconnectOnServersLeft_4() throws Exception {
        this.disconnectOnServersLeft(5, 10);
    }

    @Test
    public void testDisconnectOnServersLeft_5() throws Exception {
        this.joinTimeout = 10000L;
        this.disconnectOnServersLeft(5, 10);
    }

    private void disconnectOnServersLeft(int srvs, int clients) throws Exception {
        this.startGridsMultiThreaded(srvs);
        this.helper.clientMode(true);
        this.startGridsMultiThreaded(srvs, clients);
        for (int i = 0; i < GridTestUtils.SF.applyLB((int)5, (int)2); ++i) {
            this.info("Iteration: " + i);
            final CountDownLatch disconnectLatch = new CountDownLatch(clients);
            final CountDownLatch reconnectLatch = new CountDownLatch(clients);
            IgnitePredicate<Event> p = new IgnitePredicate<Event>(){

                public boolean apply(Event evt) {
                    if (evt.type() == 16) {
                        log.info("Disconnected: " + evt);
                        disconnectLatch.countDown();
                    } else if (evt.type() == 17) {
                        log.info("Reconnected: " + evt);
                        reconnectLatch.countDown();
                        return false;
                    }
                    return true;
                }
            };
            for (int c = 0; c < clients; ++c) {
                IgniteEx client = this.ignite(srvs + c);
                ZookeeperDiscoveryClientDisconnectTest.assertTrue((boolean)client.configuration().isClientMode());
                client.events().localListen((IgnitePredicate)p, new int[]{16, 17});
            }
            log.info("Stop all servers.");
            GridTestUtils.runMultiThreaded((IgniteInClosure)new IgniteInClosure<Integer>(){

                public void apply(Integer threadIdx) {
                    ZookeeperDiscoveryClientDisconnectTest.this.stopGrid(ZookeeperDiscoveryClientDisconnectTest.this.getTestIgniteInstanceName(threadIdx), true, false);
                }
            }, (int)srvs, (String)"stop-server");
            ZookeeperDiscoverySpiTestHelper.waitReconnectEvent(log, disconnectLatch);
            evts.clear();
            this.helper.clientMode(false);
            log.info("Restart servers.");
            this.startGridsMultiThreaded(0, srvs);
            ZookeeperDiscoverySpiTestHelper.waitReconnectEvent(log, reconnectLatch);
            this.waitForTopology(srvs + clients);
            log.info("Reconnect finished.");
        }
    }

    @Test
    public void testStartNoZk() throws Exception {
        this.stopZkCluster();
        this.sesTimeout = 30000L;
        zkCluster = ZookeeperDiscoverySpiTestUtil.createTestingCluster(3);
        try {
            final AtomicInteger idx = new AtomicInteger();
            IgniteInternalFuture fut = GridTestUtils.runMultiThreadedAsync((Callable)new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    ZookeeperDiscoveryClientDisconnectTest.this.startGrid(idx.getAndIncrement());
                    return null;
                }
            }, (int)5, (String)"start-node");
            U.sleep((long)5000L);
            ZookeeperDiscoveryClientDisconnectTest.assertFalse((boolean)fut.isDone());
            zkCluster.start();
            fut.get();
            this.waitForTopology(5);
        }
        finally {
            zkCluster.start();
        }
    }
}

