/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.spi.discovery.zk.internal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.curator.test.TestingCluster;
import org.apache.curator.test.TestingZooKeeperServer;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.util.future.GridFutureAdapter;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteRunnable;
import org.apache.ignite.spi.discovery.zk.ZookeeperDiscoverySpiTestUtil;
import org.apache.ignite.spi.discovery.zk.internal.ZookeeperClient;
import org.apache.ignite.spi.discovery.zk.internal.ZookeeperClientFailedException;
import org.apache.ignite.testframework.GridTestUtils;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;
import org.apache.zookeeper.AsyncCallback;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.data.Stat;
import org.junit.Test;

public class ZookeeperClientTest
extends GridCommonAbstractTest {
    private static final int SES_TIMEOUT = 60000;
    private TestingCluster zkCluster;

    protected void afterTest() throws Exception {
        this.closeZK();
        super.afterTest();
    }

    private ZookeeperClient createClient(int sesTimeout) throws Exception {
        return new ZookeeperClient(log, this.zkCluster.getConnectString(), sesTimeout, null);
    }

    @Test
    public void testSaveLargeValue() throws Exception {
        this.startZK(1);
        ZookeeperClient client = this.createClient(60000);
        byte[] data = new byte[0x100000];
        String basePath = "/ignite";
        ZookeeperClientTest.assertTrue((boolean)client.needSplitNodeData(basePath, data, 2));
        List parts = client.splitNodeData(basePath, data, 2);
        ZookeeperClientTest.assertTrue((parts.size() > 1 ? 1 : 0) != 0);
        ZooKeeper zk = client.zk();
        for (int i = 0; i < parts.size(); ++i) {
            byte[] part = (byte[])parts.get(i);
            ZookeeperClientTest.assertTrue((part.length > 0 ? 1 : 0) != 0);
            String path0 = basePath + ":" + i;
            zk.create(path0, part, (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        }
    }

    @Test
    public void testClose() throws Exception {
        this.startZK(1);
        final ZookeeperClient client = this.createClient(60000);
        client.createIfNeeded("/apacheIgnite1", null, CreateMode.PERSISTENT);
        client.zk().close();
        GridTestUtils.assertThrows((IgniteLogger)log, (Callable)new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                client.createIfNeeded("/apacheIgnite2", null, CreateMode.PERSISTENT);
                return null;
            }
        }, ZookeeperClientFailedException.class, null);
    }

    @Test
    public void testCreateAll() throws Exception {
        this.startZK(1);
        ZookeeperClient client = this.createClient(60000);
        client.createIfNeeded("/apacheIgnite", null, CreateMode.PERSISTENT);
        ArrayList<String> paths = new ArrayList<String>();
        paths.add("/apacheIgnite/1");
        paths.add("/apacheIgnite/2");
        paths.add("/apacheIgnite/3");
        client.createAll(paths, CreateMode.PERSISTENT);
        ZookeeperClientTest.assertEquals((int)3, (int)client.getChildren("/apacheIgnite").size());
    }

    @Test
    public void testCreateAllRequestOverflow() throws Exception {
        this.startZK(1);
        ZookeeperClient client = this.createClient(60000);
        client.createIfNeeded("/apacheIgnite", null, CreateMode.PERSISTENT);
        int cnt = 20000;
        ArrayList<String> paths = new ArrayList<String>(cnt);
        for (int i = 0; i < cnt; ++i) {
            paths.add("/apacheIgnite/" + i);
        }
        client.createAll(paths, CreateMode.PERSISTENT);
        ZookeeperClientTest.assertEquals((int)cnt, (int)client.getChildren("/apacheIgnite").size());
    }

    @Test
    public void testCreateAllNodeExists() throws Exception {
        this.startZK(1);
        ZookeeperClient client = this.createClient(60000);
        client.createIfNeeded("/apacheIgnite", null, CreateMode.PERSISTENT);
        client.createIfNeeded("/apacheIgnite/1", null, CreateMode.PERSISTENT);
        ArrayList<String> paths = new ArrayList<String>();
        paths.add("/apacheIgnite/1");
        paths.add("/apacheIgnite/2");
        paths.add("/apacheIgnite/3");
        client.createAll(paths, CreateMode.PERSISTENT);
        ZookeeperClientTest.assertEquals((int)3, (int)client.getChildren("/apacheIgnite").size());
    }

    @Test
    public void testDeleteAll() throws Exception {
        this.startZK(1);
        ZookeeperClient client = this.createClient(60000);
        client.createIfNeeded("/apacheIgnite", null, CreateMode.PERSISTENT);
        client.createIfNeeded("/apacheIgnite/1", null, CreateMode.PERSISTENT);
        client.createIfNeeded("/apacheIgnite/2", null, CreateMode.PERSISTENT);
        client.deleteAll(Arrays.asList("/apacheIgnite/1", "/apacheIgnite/2"), -1);
        ZookeeperClientTest.assertTrue((boolean)client.getChildren("/apacheIgnite").isEmpty());
        client.createIfNeeded("/apacheIgnite/1", null, CreateMode.PERSISTENT);
        client.deleteAll(Collections.singletonList("/apacheIgnite/1"), -1);
        ZookeeperClientTest.assertTrue((boolean)client.getChildren("/apacheIgnite").isEmpty());
    }

    @Test
    public void testDeleteAllRequestOverflow() throws Exception {
        this.startZK(1);
        ZookeeperClient client = this.createClient(60000);
        client.createIfNeeded("/apacheIgnite", null, CreateMode.PERSISTENT);
        int cnt = 30000;
        ArrayList<String> paths = new ArrayList<String>(cnt);
        for (int i = 0; i < cnt; ++i) {
            paths.add("/apacheIgnite/" + i);
        }
        client.createAll(paths, CreateMode.PERSISTENT);
        ZookeeperClientTest.assertEquals((int)cnt, (int)client.getChildren("/apacheIgnite").size());
        client.deleteAll(paths, -1);
        ZookeeperClientTest.assertTrue((boolean)client.getChildren("/apacheIgnite").isEmpty());
    }

    @Test
    public void testDeleteAllNoNode() throws Exception {
        this.startZK(1);
        ZookeeperClient client = this.createClient(60000);
        client.createIfNeeded("/apacheIgnite", null, CreateMode.PERSISTENT);
        client.createIfNeeded("/apacheIgnite/1", null, CreateMode.PERSISTENT);
        client.createIfNeeded("/apacheIgnite/2", null, CreateMode.PERSISTENT);
        client.deleteAll(Arrays.asList("/apacheIgnite/1", "/apacheIgnite/2", "/apacheIgnite/3"), -1);
        ZookeeperClientTest.assertTrue((boolean)client.getChildren("/apacheIgnite").isEmpty());
    }

    @Test
    public void testConnectionLoss1() throws Exception {
        ZookeeperClient client = new ZookeeperClient(log, "localhost:2200", 3000, null);
        try {
            client.createIfNeeded("/apacheIgnite", null, CreateMode.PERSISTENT);
            ZookeeperClientTest.fail();
        }
        catch (ZookeeperClientFailedException e) {
            this.info("Expected error: " + (Object)((Object)e));
        }
    }

    @Test
    public void testConnectionLoss2() throws Exception {
        this.startZK(1);
        ZookeeperClient client = this.createClient(3000);
        client.createIfNeeded("/apacheIgnite1", null, CreateMode.PERSISTENT);
        this.closeZK();
        try {
            client.createIfNeeded("/apacheIgnite2", null, CreateMode.PERSISTENT);
            ZookeeperClientTest.fail();
        }
        catch (ZookeeperClientFailedException e) {
            this.info("Expected error: " + (Object)((Object)e));
        }
    }

    @Test
    public void testConnectionLoss3() throws Exception {
        this.startZK(1);
        CallbackFuture cb = new CallbackFuture();
        ZookeeperClient client = new ZookeeperClient(log, this.zkCluster.getConnectString(), 3000, (IgniteRunnable)cb);
        client.createIfNeeded("/apacheIgnite1", null, CreateMode.PERSISTENT);
        this.closeZK();
        final AtomicBoolean res = new AtomicBoolean();
        client.getChildrenAsync("/apacheIgnite1", null, new AsyncCallback.Children2Callback(){

            public void processResult(int rc, String path, Object ctx, List<String> children, Stat stat) {
                if (rc == 0) {
                    res.set(true);
                }
            }
        });
        cb.get(60000L);
        ZookeeperClientTest.assertFalse((boolean)res.get());
    }

    @Test
    public void testConnectionLoss4() throws Exception {
        this.startZK(1);
        CallbackFuture cb = new CallbackFuture();
        final ZookeeperClient client = new ZookeeperClient(log, this.zkCluster.getConnectString(), 3000, (IgniteRunnable)cb);
        client.createIfNeeded("/apacheIgnite1", null, CreateMode.PERSISTENT);
        final CountDownLatch l = new CountDownLatch(1);
        client.getChildrenAsync("/apacheIgnite1", null, new AsyncCallback.Children2Callback(){

            public void processResult(int rc, String path, Object ctx, List<String> children, Stat stat) {
                ZookeeperClientTest.this.closeZK();
                try {
                    client.createIfNeeded("/apacheIgnite2", null, CreateMode.PERSISTENT);
                }
                catch (ZookeeperClientFailedException e) {
                    ZookeeperClientTest.this.info("Expected error: " + (Object)((Object)e));
                    l.countDown();
                }
                catch (Exception e) {
                    ZookeeperClientTest.fail((String)("Unexpected error: " + e));
                }
            }
        });
        ZookeeperClientTest.assertTrue((boolean)l.await(10L, TimeUnit.SECONDS));
        cb.get();
    }

    @Test
    public void testReconnect1() throws Exception {
        this.startZK(1);
        ZookeeperClient client = this.createClient(60000);
        client.createIfNeeded("/apacheIgnite1", null, CreateMode.PERSISTENT);
        ((TestingZooKeeperServer)this.zkCluster.getServers().get(0)).stop();
        IgniteInternalFuture fut = GridTestUtils.runAsync((Callable)new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                U.sleep((long)2000L);
                ZookeeperClientTest.this.info("Restart zookeeper server");
                ((TestingZooKeeperServer)ZookeeperClientTest.this.zkCluster.getServers().get(0)).restart();
                ZookeeperClientTest.this.info("Zookeeper server restarted");
                return null;
            }
        }, (String)"start-zk");
        client.createIfNeeded("/apacheIgnite2", null, CreateMode.PERSISTENT);
        fut.get();
    }

    @Test
    public void testReconnect1_Callback() throws Exception {
        this.startZK(1);
        ZookeeperClient client = this.createClient(60000);
        client.createIfNeeded("/apacheIgnite1", null, CreateMode.PERSISTENT);
        ((TestingZooKeeperServer)this.zkCluster.getServers().get(0)).stop();
        final CountDownLatch l = new CountDownLatch(1);
        client.getChildrenAsync("/apacheIgnite1", null, new AsyncCallback.Children2Callback(){

            public void processResult(int rc, String path, Object ctx, List<String> children, Stat stat) {
                ZookeeperClientTest.this.info("Callback: " + rc);
                if (rc == 0) {
                    l.countDown();
                }
            }
        });
        IgniteInternalFuture fut = GridTestUtils.runAsync((Callable)new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                U.sleep((long)2000L);
                ZookeeperClientTest.this.info("Restart zookeeper server");
                ((TestingZooKeeperServer)ZookeeperClientTest.this.zkCluster.getServers().get(0)).restart();
                ZookeeperClientTest.this.info("Zookeeper server restarted");
                return null;
            }
        }, (String)"start-zk");
        ZookeeperClientTest.assertTrue((boolean)l.await(10L, TimeUnit.SECONDS));
        fut.get();
    }

    @Test
    public void testReconnect1_InCallback() throws Exception {
        this.startZK(1);
        final ZookeeperClient client = this.createClient(60000);
        client.createIfNeeded("/apacheIgnite1", null, CreateMode.PERSISTENT);
        final CountDownLatch l = new CountDownLatch(1);
        client.getChildrenAsync("/apacheIgnite1", null, new AsyncCallback.Children2Callback(){

            public void processResult(int rc, String path, Object ctx, List<String> children, Stat stat) {
                try {
                    ((TestingZooKeeperServer)ZookeeperClientTest.this.zkCluster.getServers().get(0)).stop();
                    IgniteInternalFuture fut = GridTestUtils.runAsync((Callable)new Callable<Void>(){

                        @Override
                        public Void call() throws Exception {
                            U.sleep((long)2000L);
                            ZookeeperClientTest.this.info("Restart zookeeper server");
                            ((TestingZooKeeperServer)ZookeeperClientTest.this.zkCluster.getServers().get(0)).restart();
                            ZookeeperClientTest.this.info("Zookeeper server restarted");
                            return null;
                        }
                    }, (String)"start-zk");
                    client.createIfNeeded("/apacheIgnite2", null, CreateMode.PERSISTENT);
                    l.countDown();
                    fut.get();
                }
                catch (Exception e) {
                    ZookeeperClientTest.fail((String)("Unexpected error: " + e));
                }
            }
        });
        ZookeeperClientTest.assertTrue((boolean)l.await(10L, TimeUnit.SECONDS));
    }

    @Test
    public void testReconnect2() throws Exception {
        this.startZK(1);
        ZookeeperClient client = this.createClient(60000);
        client.createIfNeeded("/apacheIgnite1", null, CreateMode.PERSISTENT);
        ((TestingZooKeeperServer)this.zkCluster.getServers().get(0)).restart();
        client.createIfNeeded("/apacheIgnite2", null, CreateMode.PERSISTENT);
    }

    @Test
    public void testReconnect3() throws Exception {
        this.startZK(3);
        ZookeeperClient client = this.createClient(60000);
        ThreadLocalRandom rnd = ThreadLocalRandom.current();
        for (int i = 0; i < 30; ++i) {
            this.info("Iteration: " + i);
            int idx = rnd.nextInt(3);
            ((TestingZooKeeperServer)this.zkCluster.getServers().get(idx)).restart();
            ZookeeperClientTest.doSleep((long)(rnd.nextLong(100L) + 1L));
            client.createIfNeeded("/apacheIgnite" + i, null, CreateMode.PERSISTENT);
        }
    }

    @Test
    public void testReconnect4() throws Exception {
        this.startZK(3);
        ZookeeperClient client = new ZookeeperClient(log, ((TestingZooKeeperServer)this.zkCluster.getServers().get(2)).getInstanceSpec().getConnectString(), 60000, null);
        client.createIfNeeded("/apacheIgnite1", null, CreateMode.PERSISTENT);
        ((TestingZooKeeperServer)this.zkCluster.getServers().get(0)).stop();
        ((TestingZooKeeperServer)this.zkCluster.getServers().get(1)).stop();
        IgniteInternalFuture fut = GridTestUtils.runAsync((Callable)new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                U.sleep((long)2000L);
                ZookeeperClientTest.this.info("Restart zookeeper server");
                ((TestingZooKeeperServer)ZookeeperClientTest.this.zkCluster.getServers().get(0)).restart();
                ZookeeperClientTest.this.info("Zookeeper server restarted");
                return null;
            }
        }, (String)"start-zk");
        client.createIfNeeded("/apacheIgnite2", null, CreateMode.PERSISTENT);
        fut.get();
    }

    private void startZK(int instances) throws Exception {
        assert (this.zkCluster == null);
        this.zkCluster = ZookeeperDiscoverySpiTestUtil.createTestingCluster(instances);
        this.zkCluster.start();
    }

    private void closeZK() {
        if (this.zkCluster != null) {
            try {
                this.zkCluster.close();
            }
            catch (Exception e) {
                U.error((IgniteLogger)log, (Object)("Failed to stop Zookeeper client: " + e), (Throwable)e);
            }
            this.zkCluster = null;
        }
    }

    private static class CallbackFuture
    extends GridFutureAdapter<Void>
    implements IgniteRunnable {
        private CallbackFuture() {
        }

        public void run() {
            this.onDone();
        }
    }
}

