/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.spi.discovery.tcp.ipfinder.zk;

import java.io.Closeable;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.curator.RetryPolicy;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.curator.retry.ExponentialBackoffRetry;
import org.apache.curator.retry.RetryNTimes;
import org.apache.curator.test.TestingCluster;
import org.apache.curator.utils.CloseableUtils;
import org.apache.ignite.Ignite;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.events.Event;
import org.apache.ignite.lang.IgniteBiPredicate;
import org.apache.ignite.spi.discovery.tcp.TcpDiscoverySpi;
import org.apache.ignite.spi.discovery.tcp.ipfinder.TcpDiscoveryIpFinder;
import org.apache.ignite.spi.discovery.tcp.ipfinder.zk.TcpDiscoveryZookeeperIpFinder;
import org.apache.ignite.testframework.GridTestUtils;
import org.apache.ignite.testframework.junits.WithSystemProperty;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.Timeout;

@WithSystemProperty(key="zookeeper.jmx.log4j.disable", value="true")
public class ZookeeperIpFinderTest
extends GridCommonAbstractTest {
    @Rule
    public Timeout globalTimeout = new Timeout(300000);
    private static final int ZK_CLUSTER_SIZE = 3;
    private static final String SERVICES_IGNITE_ZK_PATH = "/services/ignite";
    private TestingCluster zkCluster;
    private CuratorFramework zkCurator;
    private boolean allowDuplicateRegistrations = false;

    public ZookeeperIpFinderTest() {
        super(false);
    }

    public void beforeTest() throws Exception {
        super.beforeTest();
        System.getProperties().remove("IGNITE_ZK_CONNECTION_STRING");
        this.zkCluster = new TestingCluster(3);
        this.zkCluster.start();
        this.zkCurator = CuratorFrameworkFactory.newClient((String)this.zkCluster.getConnectString(), (RetryPolicy)new RetryNTimes(10, 1000));
        this.zkCurator.start();
    }

    public void afterTest() throws Exception {
        super.afterTest();
        if (this.zkCurator != null) {
            CloseableUtils.closeQuietly((Closeable)this.zkCurator);
        }
        if (this.zkCluster != null) {
            CloseableUtils.closeQuietly((Closeable)this.zkCluster);
        }
        this.stopAllGrids();
    }

    protected IgniteConfiguration getConfiguration(String igniteInstanceName) throws Exception {
        IgniteConfiguration configuration = super.getConfiguration(igniteInstanceName);
        TcpDiscoverySpi tcpDisco = (TcpDiscoverySpi)configuration.getDiscoverySpi();
        TcpDiscoveryZookeeperIpFinder zkIpFinder = new TcpDiscoveryZookeeperIpFinder();
        zkIpFinder.setAllowDuplicateRegistrations(this.allowDuplicateRegistrations);
        if (igniteInstanceName.equals(this.getTestIgniteInstanceName(0))) {
            zkIpFinder.setZkConnectionString(this.zkCluster.getConnectString());
        } else if (igniteInstanceName.equals(this.getTestIgniteInstanceName(1))) {
            zkIpFinder.setCurator(CuratorFrameworkFactory.newClient((String)this.zkCluster.getConnectString(), (RetryPolicy)new ExponentialBackoffRetry(100, 5)));
        }
        tcpDisco.setIpFinder((TcpDiscoveryIpFinder)zkIpFinder);
        return configuration;
    }

    @Test
    public void testOneIgniteNodeIsAlone() throws Exception {
        this.startGrid(0);
        ZookeeperIpFinderTest.assertEquals((int)1, (int)this.grid(0).cluster().metrics().getTotalNodes());
        this.stopAllGrids();
    }

    @Test
    public void testTwoIgniteNodesFindEachOther() throws Exception {
        this.startGrid(0);
        CountDownLatch latch = this.expectJoinEvents((Ignite)this.grid(0), 1);
        this.startGrid(1);
        ZookeeperIpFinderTest.assertEquals((int)2, (int)this.grid(0).cluster().metrics().getTotalNodes());
        ZookeeperIpFinderTest.assertEquals((int)2, (int)this.grid(1).cluster().metrics().getTotalNodes());
        latch.await(1L, TimeUnit.SECONDS);
        this.stopAllGrids();
    }

    @Test
    public void testThreeNodesWithThreeDifferentConfigMethods() throws Exception {
        this.startGrid(0);
        CountDownLatch latch = this.expectJoinEvents((Ignite)this.grid(0), 2);
        this.startGrid(1);
        System.setProperty("IGNITE_ZK_CONNECTION_STRING", this.zkCluster.getConnectString());
        this.startGrid(2);
        this.waitForRemoteNodes((Ignite)this.grid(0), 2);
        ZookeeperIpFinderTest.assertEquals((int)3, (int)this.grid(0).cluster().metrics().getTotalNodes());
        ZookeeperIpFinderTest.assertEquals((int)3, (int)this.grid(1).cluster().metrics().getTotalNodes());
        ZookeeperIpFinderTest.assertEquals((int)3, (int)this.grid(2).cluster().metrics().getTotalNodes());
        latch.await(1L, TimeUnit.SECONDS);
        this.stopAllGrids();
    }

    @Test
    public void testFourNodesStartingAndStopping() throws Exception {
        this.startGrid(0);
        CountDownLatch latch = this.expectJoinEvents((Ignite)this.grid(0), 3);
        this.startGrid(1);
        System.setProperty("IGNITE_ZK_CONNECTION_STRING", this.zkCluster.getConnectString());
        this.startGrid(2);
        this.startGrid(3);
        this.waitForRemoteNodes((Ignite)this.grid(0), 3);
        ZookeeperIpFinderTest.assertEquals((int)4, (int)this.grid(0).cluster().metrics().getTotalNodes());
        ZookeeperIpFinderTest.assertEquals((int)4, (int)this.grid(1).cluster().metrics().getTotalNodes());
        ZookeeperIpFinderTest.assertEquals((int)4, (int)this.grid(2).cluster().metrics().getTotalNodes());
        ZookeeperIpFinderTest.assertEquals((int)4, (int)this.grid(3).cluster().metrics().getTotalNodes());
        latch.await(1L, TimeUnit.SECONDS);
        this.stopGrid(0);
        ZookeeperIpFinderTest.assertEquals((int)3, (int)this.grid(1).cluster().metrics().getTotalNodes());
        ZookeeperIpFinderTest.assertEquals((int)3, (int)this.grid(2).cluster().metrics().getTotalNodes());
        ZookeeperIpFinderTest.assertEquals((int)3, (int)this.grid(3).cluster().metrics().getTotalNodes());
        this.stopGrid(1);
        this.stopGrid(2);
        this.stopGrid(3);
        ZookeeperIpFinderTest.assertEquals((int)0, (int)((List)this.zkCurator.getChildren().forPath(SERVICES_IGNITE_ZK_PATH)).size());
    }

    @Test
    public void testFourNodesWithDuplicateRegistrations() throws Exception {
        this.allowDuplicateRegistrations = true;
        System.setProperty("IGNITE_ZK_CONNECTION_STRING", this.zkCluster.getConnectString());
        this.startGrids(4);
        this.waitForRemoteNodes((Ignite)this.grid(0), 3);
        ZookeeperIpFinderTest.assertEquals((int)7, (int)((List)this.zkCurator.getChildren().forPath(SERVICES_IGNITE_ZK_PATH)).size());
        this.stopAllGrids();
        ZookeeperIpFinderTest.assertEquals((int)0, (int)((List)this.zkCurator.getChildren().forPath(SERVICES_IGNITE_ZK_PATH)).size());
    }

    @Test
    public void testFourNodesWithNoDuplicateRegistrations() throws Exception {
        this.allowDuplicateRegistrations = false;
        System.setProperty("IGNITE_ZK_CONNECTION_STRING", this.zkCluster.getConnectString());
        this.startGrids(4);
        this.waitForRemoteNodes((Ignite)this.grid(0), 3);
        ZookeeperIpFinderTest.assertEquals((int)4, (int)((List)this.zkCurator.getChildren().forPath(SERVICES_IGNITE_ZK_PATH)).size());
        this.stopAllGrids();
        ZookeeperIpFinderTest.assertEquals((int)0, (int)((List)this.zkCurator.getChildren().forPath(SERVICES_IGNITE_ZK_PATH)).size());
    }

    @Test
    public void testFourNodesRestartLastSeveralTimes() throws Exception {
        this.allowDuplicateRegistrations = false;
        System.setProperty("IGNITE_ZK_CONNECTION_STRING", this.zkCluster.getConnectString());
        this.startGrids(4);
        this.waitForRemoteNodes((Ignite)this.grid(0), 3);
        ZookeeperIpFinderTest.assertEquals((int)4, (int)((List)this.zkCurator.getChildren().forPath(SERVICES_IGNITE_ZK_PATH)).size());
        for (int i = 0; i < 5; ++i) {
            this.stopGrid(2);
            ZookeeperIpFinderTest.assertEquals((int)3, (int)((List)this.zkCurator.getChildren().forPath(SERVICES_IGNITE_ZK_PATH)).size());
            this.startGrid(2);
            ZookeeperIpFinderTest.assertEquals((int)4, (int)((List)this.zkCurator.getChildren().forPath(SERVICES_IGNITE_ZK_PATH)).size());
        }
        this.stopAllGrids();
        ZookeeperIpFinderTest.assertEquals((int)0, (int)((List)this.zkCurator.getChildren().forPath(SERVICES_IGNITE_ZK_PATH)).size());
    }

    @Test
    public void testFourNodesKillRestartZookeeper() throws Exception {
        this.allowDuplicateRegistrations = false;
        System.setProperty("IGNITE_ZK_CONNECTION_STRING", this.zkCluster.getConnectString());
        this.startGrids(4);
        this.waitForRemoteNodes((Ignite)this.grid(0), 3);
        ZookeeperIpFinderTest.assertEquals((int)4, (int)((List)this.zkCurator.getChildren().forPath(SERVICES_IGNITE_ZK_PATH)).size());
        Collection instances = this.zkCluster.getInstances();
        this.zkCluster.stop();
        Thread.sleep(1000L);
        this.zkCluster = new TestingCluster(instances);
        this.zkCluster.start();
        this.zkCurator.blockUntilConnected();
        ZookeeperIpFinderTest.assertEquals((int)4, (int)((List)this.zkCurator.getChildren().forPath(SERVICES_IGNITE_ZK_PATH)).size());
        for (int i = 0; i < 4; ++i) {
            TcpDiscoverySpi spi = (TcpDiscoverySpi)this.grid(i).configuration().getDiscoverySpi();
            TcpDiscoveryZookeeperIpFinder zkIpFinder = (TcpDiscoveryZookeeperIpFinder)spi.getIpFinder();
            CuratorFramework curator = (CuratorFramework)GridTestUtils.getFieldValue((Object)zkIpFinder, (String[])new String[]{"curator"});
            curator.blockUntilConnected();
        }
        this.stopAllGrids();
        ZookeeperIpFinderTest.assertEquals((int)0, (int)((List)this.zkCurator.getChildren().forPath(SERVICES_IGNITE_ZK_PATH)).size());
    }

    private CountDownLatch expectJoinEvents(Ignite ignite, int joinEvtCnt) {
        final CountDownLatch latch = new CountDownLatch(joinEvtCnt);
        ignite.events().remoteListen((IgniteBiPredicate)new IgniteBiPredicate<UUID, Event>(){

            public boolean apply(UUID uuid, Event evt) {
                latch.countDown();
                return true;
            }
        }, null, new int[]{10});
        return latch;
    }
}

