/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.spi.discovery.zk.internal;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.SocketTimeoutException;
import java.nio.ByteBuffer;
import java.util.BitSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.apache.curator.RetryPolicy;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.curator.retry.RetryNTimes;
import org.apache.curator.test.TestingCluster;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cache.CacheAtomicityMode;
import org.apache.ignite.cache.CacheWriteSynchronizationMode;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.CommunicationFailureResolver;
import org.apache.ignite.configuration.DataRegionConfiguration;
import org.apache.ignite.configuration.DataStorageConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.configuration.WALMode;
import org.apache.ignite.events.DiscoveryEvent;
import org.apache.ignite.events.Event;
import org.apache.ignite.events.EventType;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.IgniteKernal;
import org.apache.ignite.internal.IgnitionEx;
import org.apache.ignite.internal.TestRecordingCommunicationSpi;
import org.apache.ignite.internal.managers.discovery.DiscoveryLocalJoinData;
import org.apache.ignite.internal.managers.discovery.IgniteDiscoverySpiInternalListener;
import org.apache.ignite.internal.util.future.IgniteFinishedFutureImpl;
import org.apache.ignite.internal.util.lang.GridAbsPredicate;
import org.apache.ignite.internal.util.lang.IgniteInClosure2X;
import org.apache.ignite.internal.util.nio.GridCommunicationClient;
import org.apache.ignite.internal.util.typedef.T2;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteFuture;
import org.apache.ignite.lang.IgniteInClosure;
import org.apache.ignite.lang.IgniteOutClosure;
import org.apache.ignite.lang.IgnitePredicate;
import org.apache.ignite.plugin.extensions.communication.Message;
import org.apache.ignite.plugin.security.SecurityCredentials;
import org.apache.ignite.resources.IgniteInstanceResource;
import org.apache.ignite.spi.communication.CommunicationSpi;
import org.apache.ignite.spi.communication.tcp.TcpCommunicationSpi;
import org.apache.ignite.spi.discovery.DiscoverySpi;
import org.apache.ignite.spi.discovery.DiscoverySpiCustomMessage;
import org.apache.ignite.spi.discovery.DiscoverySpiNodeAuthenticator;
import org.apache.ignite.spi.discovery.zk.ZookeeperDiscoverySpi;
import org.apache.ignite.spi.discovery.zk.ZookeeperDiscoverySpiTestUtil;
import org.apache.ignite.spi.discovery.zk.internal.ZookeeperClusterNode;
import org.apache.ignite.spi.discovery.zk.internal.ZookeeperDiscoverySpiTestHelper;
import org.apache.ignite.spi.discovery.zk.internal.ZookeeperDiscoverySplitBrainTest;
import org.apache.ignite.testframework.GridTestUtils;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;
import org.apache.zookeeper.ZkTestClientCnxnSocketNIO;
import org.jetbrains.annotations.Nullable;

class ZookeeperDiscoverySpiTestBase
extends GridCommonAbstractTest {
    protected UUID nodeId;
    protected long joinTimeout;
    protected static TestingCluster zkCluster;
    protected static final boolean USE_TEST_CLUSTER = true;
    protected static final int ZK_SRVS = 3;
    protected ConcurrentHashMap<String, ZookeeperDiscoverySpi> spis = new ConcurrentHashMap();
    protected Map<String, Object> userAttrs;
    protected static ConcurrentHashMap<UUID, Map<T2<Integer, Long>, DiscoveryEvent>> evts;
    protected static volatile boolean err;
    protected final AtomicInteger clusterNum = new AtomicInteger(0);
    protected final ZookeeperDiscoverySpiTestHelper helper = new ZookeeperDiscoverySpiTestHelper(arg_0 -> ((ZookeeperDiscoverySpiTestBase)this).info(arg_0), this.clusterNum);
    protected boolean testSockNio;
    protected boolean testCommSpi;
    protected boolean failCommSpi;
    protected boolean blockCommSpi;
    protected long sesTimeout;
    protected boolean clientReconnectDisabled;
    protected boolean dfltConsistenId;
    protected boolean persistence;
    protected IgniteOutClosure<CommunicationFailureResolver> commFailureRslvr;
    protected IgniteOutClosure<DiscoverySpiNodeAuthenticator> auth;
    protected String zkRootPath;
    protected CacheAtomicityMode atomicityMode;
    protected int backups = -1;

    ZookeeperDiscoverySpiTestBase() {
    }

    protected void beforeTestsStarted() throws Exception {
        super.beforeTestsStarted();
        System.setProperty("IGNITE_ZOOKEEPER_DISCOVERY_SPI_ACK_TIMEOUT", "1000");
    }

    protected void afterTestsStopped() {
        this.stopZkCluster();
        System.clearProperty("IGNITE_ZOOKEEPER_DISCOVERY_SPI_ACK_TIMEOUT");
    }

    protected void beforeTest() throws Exception {
        super.beforeTest();
        if (zkCluster == null) {
            zkCluster = ZookeeperDiscoverySpiTestUtil.createTestingCluster(3);
            zkCluster.start();
            ZookeeperDiscoverySpiTestBase.waitForZkClusterReady(zkCluster);
        }
        this.reset();
    }

    protected void afterTest() throws Exception {
        super.afterTest();
        this.clearAckEveryEventSystemProperty();
        try {
            ZookeeperDiscoverySpiTestBase.assertFalse((String)"Unexpected error, see log for details", (boolean)err);
            this.checkEventsConsistency();
            this.checkInternalStructuresCleanup();
        }
        finally {
            this.stopAllGrids();
            this.reset();
        }
    }

    protected void waitForTopology(int expSize) throws Exception {
        super.waitForTopology(expSize);
    }

    static void waitForZkClusterReady(TestingCluster zkCluster) throws InterruptedException {
        try (CuratorFramework curator = CuratorFrameworkFactory.newClient((String)zkCluster.getConnectString(), (RetryPolicy)new RetryNTimes(10, 1000));){
            curator.start();
            ZookeeperDiscoverySpiTestBase.assertTrue((String)"Failed to wait for Zookeeper testing cluster ready.", (boolean)curator.blockUntilConnected(30, TimeUnit.SECONDS));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void checkEventsConsistency() {
        for (Map.Entry<UUID, Map<T2<Integer, Long>, DiscoveryEvent>> nodeEvtEntry : evts.entrySet()) {
            UUID nodeId = nodeEvtEntry.getKey();
            Map<T2<Integer, Long>, DiscoveryEvent> nodeEvts = nodeEvtEntry.getValue();
            for (Map.Entry<UUID, Map<T2<Integer, Long>, DiscoveryEvent>> nodeEvtEntry0 : evts.entrySet()) {
                if (nodeId.equals(nodeEvtEntry0.getKey())) continue;
                Map<T2<Integer, Long>, DiscoveryEvent> nodeEvts0 = nodeEvtEntry0.getValue();
                Map<T2<Integer, Long>, DiscoveryEvent> map = nodeEvts;
                synchronized (map) {
                    Map<T2<Integer, Long>, DiscoveryEvent> map2 = nodeEvts0;
                    synchronized (map2) {
                        this.checkEventsConsistency(nodeEvts, nodeEvts0);
                    }
                }
            }
        }
    }

    void checkInternalStructuresCleanup() throws Exception {
        for (Ignite node : IgnitionEx.allGridsx()) {
            final AtomicReference res = (AtomicReference)GridTestUtils.getFieldValue((Object)ZookeeperDiscoverySpiTestBase.spi(node), (String[])new String[]{"impl", "commErrProcFut"});
            GridTestUtils.waitForCondition((GridAbsPredicate)new GridAbsPredicate(){

                public boolean apply() {
                    return res.get() == null;
                }
            }, (long)30000L);
            ZookeeperDiscoverySpiTestBase.assertNull(res.get());
        }
    }

    void reset() {
        System.clearProperty("zookeeper.clientCnxnSocket");
        ZkTestClientCnxnSocketNIO.reset();
        System.clearProperty("zookeeper.clientCnxnSocket");
        err = false;
        this.failCommSpi = false;
        PeerToPeerCommunicationFailureSpi.unfail();
        evts.clear();
        try {
            this.cleanPersistenceDir();
        }
        catch (Exception e) {
            this.error("Failed to delete DB files: " + e, e);
        }
        this.helper.clientModeThreadLocalReset();
    }

    private void checkEventsConsistency(Map<T2<Integer, Long>, DiscoveryEvent> evts1, Map<T2<Integer, Long>, DiscoveryEvent> evts2) {
        for (Map.Entry<T2<Integer, Long>, DiscoveryEvent> e1 : evts1.entrySet()) {
            DiscoveryEvent evt1 = e1.getValue();
            DiscoveryEvent evt2 = evts2.get(e1.getKey());
            if (evt2 == null) continue;
            ZookeeperDiscoverySpiTestBase.assertEquals((long)evt1.topologyVersion(), (long)evt2.topologyVersion());
            ZookeeperDiscoverySpiTestBase.assertEquals((Object)evt1.eventNode().consistentId(), (Object)evt2.eventNode().consistentId());
            ZookeeperDiscoverySpiTestBase.assertTrue((boolean)this.equalsTopologies(evt1.topologyNodes(), evt2.topologyNodes()));
        }
    }

    private boolean equalsTopologies(Collection<ClusterNode> nodes1, Collection<ClusterNode> nodes2) {
        if (nodes1.size() != nodes2.size()) {
            return false;
        }
        Set consistentIds1 = nodes1.stream().map(ClusterNode::consistentId).collect(Collectors.toSet());
        return nodes2.stream().map(ClusterNode::consistentId).allMatch(consistentIds1::contains);
    }

    private void clearAckEveryEventSystemProperty() {
        System.setProperty("IGNITE_ZOOKEEPER_DISCOVERY_SPI_ACK_THRESHOLD", "1");
    }

    protected IgniteConfiguration getConfiguration(final String igniteInstanceName) throws Exception {
        if (this.testSockNio) {
            System.setProperty("zookeeper.clientCnxnSocket", ZkTestClientCnxnSocketNIO.class.getName());
        }
        IgniteConfiguration cfg = super.getConfiguration(igniteInstanceName);
        if (this.nodeId != null) {
            cfg.setNodeId(this.nodeId);
        }
        if (!this.dfltConsistenId) {
            cfg.setConsistentId((Serializable)((Object)igniteInstanceName));
        }
        ZookeeperDiscoverySpi zkSpi = new ZookeeperDiscoverySpi();
        if (this.joinTimeout != 0L) {
            zkSpi.setJoinTimeout(this.joinTimeout);
        }
        zkSpi.setSessionTimeout(this.sesTimeout > 0L ? this.sesTimeout : 10000L);
        zkSpi.setClientReconnectDisabled(this.clientReconnectDisabled);
        if (this.auth != null) {
            zkSpi.setAuthenticator((DiscoverySpiNodeAuthenticator)this.auth.apply());
            zkSpi.setInternalListener(new IgniteDiscoverySpiInternalListener(){

                public void beforeJoin(ClusterNode locNode, IgniteLogger log) {
                    ZookeeperClusterNode locNode0 = (ZookeeperClusterNode)locNode;
                    HashMap<String, SecurityCredentials> attrs = new HashMap<String, SecurityCredentials>(locNode0.getAttributes());
                    attrs.put("org.apache.ignite.security.cred", new SecurityCredentials(null, null, (Object)igniteInstanceName));
                    locNode0.setAttributes(attrs);
                }

                public boolean beforeSendCustomEvent(DiscoverySpi spi, IgniteLogger log, DiscoverySpiCustomMessage msg) {
                    return false;
                }
            });
        }
        this.spis.put(igniteInstanceName, zkSpi);
        assert (zkCluster != null);
        zkSpi.setZkConnectionString(this.getTestClusterZkConnectionString());
        if (this.zkRootPath != null) {
            zkSpi.setZkRootPath(this.zkRootPath);
        }
        cfg.setDiscoverySpi((DiscoverySpi)zkSpi);
        cfg.setCacheConfiguration(new CacheConfiguration[]{this.getCacheConfiguration()});
        Boolean clientMode = this.helper.clientModeThreadLocal();
        if (clientMode != null) {
            cfg.setClientMode(clientMode.booleanValue());
        } else {
            cfg.setClientMode(this.helper.clientMode());
        }
        if (this.userAttrs != null) {
            cfg.setUserAttributes(this.userAttrs);
        }
        HashMap<Object, int[]> lsnrs = new HashMap<Object, int[]>();
        if (cfg.isClientMode().booleanValue()) {
            final UUID currNodeId = cfg.getNodeId();
            lsnrs.put(new IgnitePredicate<Event>(){
                private UUID nodeId;
                {
                    this.nodeId = currNodeId;
                }

                public boolean apply(Event evt) {
                    if (evt.type() == 17) {
                        evts.remove(this.nodeId);
                        this.nodeId = evt.node().id();
                    }
                    return true;
                }
            }, new int[]{17});
        }
        lsnrs.put(new IgnitePredicate<Event>(){
            @IgniteInstanceResource
            private Ignite ignite;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public boolean apply(Event evt) {
                try {
                    DiscoveryEvent discoveryEvt = (DiscoveryEvent)evt;
                    UUID locId = ((IgniteKernal)this.ignite).context().localNodeId();
                    Map<T2<Integer, Long>, DiscoveryEvent> nodeEvts = evts.get(locId);
                    if (nodeEvts == null) {
                        nodeEvts = new LinkedHashMap<T2<Integer, Long>, DiscoveryEvent>();
                        LinkedHashMap<T2<Integer, Long>, DiscoveryEvent> old = evts.put(locId, nodeEvts);
                        ZookeeperDiscoverySpiTestBase.assertNull((Object)old);
                        if (evt.type() != 12 || discoveryEvt.eventNode().consistentId().equals(this.ignite.configuration().getConsistentId())) {
                            Map<T2<Integer, Long>, DiscoveryEvent> map = nodeEvts;
                            synchronized (map) {
                                DiscoveryLocalJoinData locJoin = ((IgniteEx)this.ignite).context().discovery().localJoin();
                                if (locJoin.event().node().order() == 1L) {
                                    ZookeeperDiscoverySpiTestBase.this.clusterNum.incrementAndGet();
                                }
                                nodeEvts.put((T2<Integer, Long>)new T2((Object)ZookeeperDiscoverySpiTestBase.this.clusterNum.get(), (Object)locJoin.event().topologyVersion()), locJoin.event());
                            }
                        }
                    }
                    Map<T2<Integer, Long>, DiscoveryEvent> map = nodeEvts;
                    synchronized (map) {
                        DiscoveryEvent old = nodeEvts.put((T2<Integer, Long>)new T2((Object)ZookeeperDiscoverySpiTestBase.this.clusterNum.get(), (Object)discoveryEvt.topologyVersion()), discoveryEvt);
                        ZookeeperDiscoverySpiTestBase.assertNull((Object)old);
                    }
                }
                catch (Throwable e) {
                    ZookeeperDiscoverySpiTestBase.this.error("Unexpected error [evt=" + evt + ", err=" + e + ']', e);
                    err = true;
                }
                return true;
            }
        }, new int[]{10, 12, 11});
        if (!this.isMultiJvm()) {
            cfg.setLocalEventListeners(lsnrs);
        }
        if (this.persistence) {
            DataStorageConfiguration memCfg = new DataStorageConfiguration().setDefaultDataRegionConfiguration(new DataRegionConfiguration().setMaxSize(0x6400000L).setPersistenceEnabled(true)).setPageSize(1024).setWalMode(WALMode.LOG_ONLY);
            cfg.setDataStorageConfiguration(memCfg);
        }
        if (this.testCommSpi) {
            cfg.setCommunicationSpi((CommunicationSpi)new ZkTestCommunicationSpi());
        }
        if (this.failCommSpi) {
            cfg.setCommunicationSpi((CommunicationSpi)new PeerToPeerCommunicationFailureSpi());
        }
        if (this.blockCommSpi) {
            cfg.setCommunicationSpi((CommunicationSpi)new TcpBlockCommunicationSpi(igniteInstanceName.contains("block")).setUsePairedConnections(true));
            cfg.setNetworkTimeout(500L);
        }
        if (this.commFailureRslvr != null) {
            cfg.setCommunicationFailureResolver((CommunicationFailureResolver)this.commFailureRslvr.apply());
        }
        cfg.setIncludeEventTypes(EventType.EVTS_ALL);
        return cfg;
    }

    protected String getTestClusterZkConnectionString() {
        return zkCluster.getConnectString();
    }

    protected String getRealClusterZkConnectionString() {
        return "localhost:2181";
    }

    static ZookeeperDiscoverySpi spi(Ignite node) {
        return (ZookeeperDiscoverySpi)node.configuration().getDiscoverySpi();
    }

    void stopZkCluster() {
        if (zkCluster != null) {
            try {
                zkCluster.close();
            }
            catch (Exception e) {
                U.error((IgniteLogger)log, (Object)("Failed to stop Zookeeper client: " + e), (Throwable)e);
            }
            zkCluster = null;
        }
    }

    private CacheConfiguration getCacheConfiguration() {
        CacheConfiguration ccfg = new CacheConfiguration("default");
        ccfg.setWriteSynchronizationMode(CacheWriteSynchronizationMode.FULL_SYNC);
        if (this.atomicityMode != null) {
            ccfg.setAtomicityMode(this.atomicityMode);
        }
        if (this.backups > 0) {
            ccfg.setBackups(this.backups);
        }
        return ccfg;
    }

    static {
        evts = new ConcurrentHashMap();
    }

    private static class TcpBlockCommunicationSpi
    extends TcpCommunicationSpi {
        private final boolean isBlocking;
        private boolean alreadyBlocked;

        public TcpBlockCommunicationSpi(boolean isBlocking) {
            this.isBlocking = isBlocking;
        }

        protected GridCommunicationClient createTcpClient(ClusterNode node, int connIdx) throws IgniteCheckedException {
            if (node.isClient() && this.blockHandshakeOnce()) {
                ZookeeperDiscoverySpi spi = ZookeeperDiscoverySpiTestBase.spi(this.ignite());
                spi.resolveCommunicationFailure((ClusterNode)spi.getRemoteNodes().iterator().next(), new Exception("test"));
                return null;
            }
            return super.createTcpClient(node, connIdx);
        }

        private boolean blockHandshakeOnce() {
            if (this.isBlocking && !this.alreadyBlocked) {
                this.alreadyBlocked = true;
                return true;
            }
            return false;
        }
    }

    static class ZkTestCommunicationSpi
    extends TestRecordingCommunicationSpi {
        volatile CountDownLatch pingStartLatch;
        volatile CountDownLatch pingLatch;
        volatile BitSet checkRes;

        ZkTestCommunicationSpi() {
        }

        static ZkTestCommunicationSpi testSpi(Ignite ignite) {
            return (ZkTestCommunicationSpi)ignite.configuration().getCommunicationSpi();
        }

        void initCheckResult(int nodes, Integer ... setBitIdxs) {
            BitSet res = new BitSet(nodes);
            for (Integer bitIdx : setBitIdxs) {
                res.set(bitIdx);
            }
            this.checkRes = res;
        }

        public IgniteFuture<BitSet> checkConnection(List<ClusterNode> nodes) {
            CountDownLatch pingStartLatch = this.pingStartLatch;
            if (pingStartLatch != null) {
                pingStartLatch.countDown();
            }
            CountDownLatch pingLatch = this.pingLatch;
            try {
                if (pingLatch != null) {
                    pingLatch.await();
                }
            }
            catch (InterruptedException e) {
                throw new IgniteException((Throwable)e);
            }
            BitSet checkRes = this.checkRes;
            if (checkRes != null) {
                this.checkRes = null;
                return new IgniteFinishedFutureImpl((Object)checkRes);
            }
            return super.checkConnection(nodes);
        }
    }

    static class PeerToPeerCommunicationFailureSpi
    extends TcpCommunicationSpi {
        private static volatile boolean failure;
        private static volatile ZookeeperDiscoverySplitBrainTest.ConnectionsFailureMatrix matrix;

        PeerToPeerCommunicationFailureSpi() {
        }

        static void fail(ZookeeperDiscoverySplitBrainTest.ConnectionsFailureMatrix with) {
            matrix = with;
            failure = true;
        }

        private static void unfail() {
            failure = false;
        }

        public IgniteFuture<BitSet> checkConnection(List<ClusterNode> nodes) {
            BitSet bitSet = new BitSet();
            ClusterNode locNode = this.getLocalNode();
            int idx = 0;
            for (ClusterNode remoteNode : nodes) {
                if (locNode.id().equals(remoteNode.id())) {
                    bitSet.set(idx);
                } else if (matrix.hasConnection(locNode, remoteNode)) {
                    bitSet.set(idx);
                }
                ++idx;
            }
            return new IgniteFinishedFutureImpl((Object)bitSet);
        }

        protected GridCommunicationClient createTcpClient(ClusterNode node, int connIdx) throws IgniteCheckedException {
            if (failure && !matrix.hasConnection(this.getLocalNode(), node)) {
                this.processSessionCreationError(node, null, new IgniteCheckedException("Test", (Throwable)new SocketTimeoutException()));
                return null;
            }
            return new FailingCommunicationClient(this.getLocalNode(), node, super.createTcpClient(node, connIdx));
        }

        static class FailingCommunicationClient
        implements GridCommunicationClient {
            private final GridCommunicationClient delegate;
            private final ClusterNode locNode;
            private final ClusterNode remoteNode;

            FailingCommunicationClient(ClusterNode locNode, ClusterNode remoteNode, GridCommunicationClient delegate) {
                this.delegate = delegate;
                this.locNode = locNode;
                this.remoteNode = remoteNode;
            }

            public void doHandshake(IgniteInClosure2X<InputStream, OutputStream> handshakeC) throws IgniteCheckedException {
                if (failure && !matrix.hasConnection(this.locNode, this.remoteNode)) {
                    throw new IgniteCheckedException("Test", (Throwable)new SocketTimeoutException());
                }
                this.delegate.doHandshake(handshakeC);
            }

            public boolean close() {
                return this.delegate.close();
            }

            public void forceClose() {
                this.delegate.forceClose();
            }

            public boolean closed() {
                return this.delegate.closed();
            }

            public boolean reserve() {
                return this.delegate.reserve();
            }

            public void release() {
                this.delegate.release();
            }

            public long getIdleTime() {
                return this.delegate.getIdleTime();
            }

            public void sendMessage(ByteBuffer data) throws IgniteCheckedException {
                if (failure && !matrix.hasConnection(this.locNode, this.remoteNode)) {
                    throw new IgniteCheckedException("Test", (Throwable)new SocketTimeoutException());
                }
                this.delegate.sendMessage(data);
            }

            public void sendMessage(byte[] data, int len) throws IgniteCheckedException {
                if (failure && !matrix.hasConnection(this.locNode, this.remoteNode)) {
                    throw new IgniteCheckedException("Test", (Throwable)new SocketTimeoutException());
                }
                this.delegate.sendMessage(data, len);
            }

            public boolean sendMessage(@Nullable UUID nodeId, Message msg, @Nullable IgniteInClosure<IgniteException> c) throws IgniteCheckedException {
                if (failure && !matrix.hasConnection(this.locNode, this.remoteNode)) {
                    return true;
                }
                return this.delegate.sendMessage(nodeId, msg, c);
            }

            public boolean async() {
                return this.delegate.async();
            }

            public int connectionIndex() {
                return this.delegate.connectionIndex();
            }
        }
    }
}

