/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.spi.discovery.zk.internal;

import java.util.Collection;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.events.DiscoveryEvent;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.util.lang.GridAbsPredicate;
import org.apache.ignite.internal.util.typedef.G;
import org.apache.ignite.internal.util.typedef.T2;
import org.apache.ignite.internal.util.typedef.internal.CU;
import org.apache.ignite.lang.IgniteCallable;
import org.apache.ignite.lang.IgniteInClosure;
import org.apache.ignite.spi.discovery.zk.internal.ZookeeperDiscoverySpiTestBase;
import org.apache.ignite.spi.discovery.zk.internal.ZookeeperDiscoverySpiTestHelper;
import org.apache.ignite.testframework.GridTestUtils;
import org.apache.ignite.testframework.junits.WithSystemProperty;
import org.apache.zookeeper.ZkTestClientCnxnSocketNIO;
import org.junit.Test;

public class ZookeeperDiscoveryConcurrentStartAndStartStopTest
extends ZookeeperDiscoverySpiTestBase {
    @Test
    public void testConcurrentStartWithClient() throws Exception {
        int NODES = 20;
        for (int i = 0; i < 3; ++i) {
            this.info("Iteration: " + i);
            final int srvIdx = ThreadLocalRandom.current().nextInt(20);
            final AtomicInteger idx = new AtomicInteger();
            GridTestUtils.runMultiThreaded((Callable)new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    int threadIdx = idx.getAndIncrement();
                    ZookeeperDiscoveryConcurrentStartAndStartStopTest.this.helper.clientModeThreadLocal(threadIdx == srvIdx || ThreadLocalRandom.current().nextBoolean());
                    ZookeeperDiscoveryConcurrentStartAndStartStopTest.this.startGrid(threadIdx);
                    return null;
                }
            }, (int)20, (String)"start-node");
            this.waitForTopology(20);
            this.stopAllGrids();
            this.checkEventsConsistency();
            evts.clear();
        }
    }

    @Test
    public void testConcurrentStart() throws Exception {
        int NODES = 20;
        for (int i = 0; i < 3; ++i) {
            this.info("Iteration: " + i);
            final AtomicInteger idx = new AtomicInteger();
            final CyclicBarrier b = new CyclicBarrier(20);
            GridTestUtils.runMultiThreaded((Callable)new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    b.await();
                    int threadIdx = idx.getAndIncrement();
                    ZookeeperDiscoveryConcurrentStartAndStartStopTest.this.startGrid(threadIdx);
                    return null;
                }
            }, (int)20, (String)"start-node");
            this.waitForTopology(20);
            this.stopAllGrids();
            this.checkEventsConsistency();
            evts.clear();
        }
    }

    @Test
    public void testConcurrentStartStop1() throws Exception {
        this.concurrentStartStop(1);
    }

    @Test
    public void testConcurrentStartStop2() throws Exception {
        this.concurrentStartStop(5);
    }

    @Test
    @WithSystemProperty(key="IGNITE_ZOOKEEPER_DISCOVERY_SPI_MAX_EVTS", value="1")
    public void testConcurrentStartStop2_EventsThrottle() throws Exception {
        this.concurrentStartStop(5);
    }

    private void concurrentStartStop(final int initNodes) throws Exception {
        this.startGrids(initNodes);
        int NODES = 5;
        long topVer = initNodes;
        for (int i = 0; i < GridTestUtils.SF.applyLB((int)10, (int)2); ++i) {
            this.info("Iteration: " + i);
            DiscoveryEvent[] expEvts = new DiscoveryEvent[5];
            this.startGridsMultiThreaded(initNodes, 5);
            for (int j = 0; j < 5; ++j) {
                expEvts[j] = ZookeeperDiscoverySpiTestHelper.joinEvent(++topVer);
            }
            this.helper.checkEvents((Ignite)this.ignite(0), (ConcurrentHashMap<UUID, Map<T2<Integer, Long>, DiscoveryEvent>>)evts, expEvts);
            this.checkEventsConsistency();
            final CyclicBarrier b = new CyclicBarrier(5);
            GridTestUtils.runMultiThreaded((IgniteInClosure)new IgniteInClosure<Integer>(){

                public void apply(Integer idx) {
                    try {
                        b.await();
                        ZookeeperDiscoveryConcurrentStartAndStartStopTest.this.stopGrid(initNodes + idx);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        ZookeeperDiscoveryConcurrentStartAndStartStopTest.fail();
                    }
                }
            }, (int)5, (String)"stop-node");
            for (int j = 0; j < 5; ++j) {
                expEvts[j] = ZookeeperDiscoverySpiTestHelper.failEvent(++topVer);
            }
            this.checkEventsConsistency();
        }
    }

    @Test
    public void testClusterRestart() throws Exception {
        this.startGridsMultiThreaded(3, false);
        this.stopAllGrids();
        evts.clear();
        this.startGridsMultiThreaded(3, false);
        this.waitForTopology(3);
    }

    @Test
    public void testConnectionRestore4() throws Exception {
        this.testSockNio = true;
        IgniteEx node0 = this.startGrid(0);
        ZkTestClientCnxnSocketNIO c0 = ZkTestClientCnxnSocketNIO.forNode((Ignite)node0);
        c0.closeSocket(false);
        this.startGrid(1);
    }

    @Test
    public void testStartStop_1_Node() throws Exception {
        this.startGrid(0);
        this.waitForTopology(1);
        this.stopGrid(0);
    }

    @Test
    public void testRestarts_2_Nodes() throws Exception {
        this.startGrid(0);
        for (int i = 0; i < 10; ++i) {
            this.info("Iteration: " + i);
            this.startGrid(1);
            this.waitForTopology(2);
            this.stopGrid(1);
        }
    }

    @Test
    public void testStartStop_2_Nodes_WithCache() throws Exception {
        this.startGrids(2);
        for (Ignite node : G.allGrids()) {
            IgniteCache cache = node.cache("default");
            ZookeeperDiscoveryConcurrentStartAndStartStopTest.assertNotNull((Object)cache);
            for (int i = 0; i < 100; ++i) {
                cache.put((Object)i, (Object)node.name());
                ZookeeperDiscoveryConcurrentStartAndStartStopTest.assertEquals((Object)node.name(), (Object)cache.get((Object)i));
            }
        }
        this.awaitPartitionMapExchange();
    }

    @Test
    public void testStartStop_2_Nodes() throws Exception {
        ZookeeperDiscoverySpiTestHelper.ackEveryEventSystemProperty();
        this.startGrid(0);
        this.waitForTopology(1);
        this.startGrid(1);
        this.waitForTopology(2);
        for (Ignite node : G.allGrids()) {
            node.compute().broadcast((IgniteCallable)new ZookeeperDiscoverySpiTestHelper.DummyCallable(null));
        }
        this.awaitPartitionMapExchange();
        this.helper.waitForEventsAcks((Ignite)this.ignite(0));
    }

    @Test
    public void testMultipleClusters() throws Exception {
        IgniteEx c0 = this.startGrid(0);
        this.zkRootPath = "/cluster2";
        Ignite c1 = this.startGridsMultiThreaded(1, 5);
        this.zkRootPath = "/cluster3";
        Ignite c2 = this.startGridsMultiThreaded(6, 3);
        this.checkNodesNumber((Ignite)c0, 1);
        this.checkNodesNumber(c1, 5);
        this.checkNodesNumber(c2, 3);
        this.stopGrid(2);
        this.checkNodesNumber((Ignite)c0, 1);
        this.checkNodesNumber(c1, 4);
        this.checkNodesNumber(c2, 3);
        for (int i = 0; i < 3; ++i) {
            this.stopGrid(i + 6);
        }
        this.checkNodesNumber((Ignite)c0, 1);
        this.checkNodesNumber(c1, 4);
        c2 = this.startGridsMultiThreaded(6, 2);
        this.checkNodesNumber((Ignite)c0, 1);
        this.checkNodesNumber(c1, 4);
        this.checkNodesNumber(c2, 2);
        evts.clear();
    }

    private void checkNodesNumber(final Ignite node, final int expNodes) throws Exception {
        GridTestUtils.waitForCondition((GridAbsPredicate)new GridAbsPredicate(){

            public boolean apply() {
                return node.cluster().nodes().size() == expNodes;
            }
        }, (long)5000L);
        ZookeeperDiscoveryConcurrentStartAndStartStopTest.assertEquals((int)expNodes, (int)node.cluster().nodes().size());
    }

    @Test
    public void testStartStop1() throws Exception {
        ZookeeperDiscoverySpiTestHelper.ackEveryEventSystemProperty();
        this.startGridsMultiThreaded(5, false);
        this.waitForTopology(5);
        this.awaitPartitionMapExchange();
        this.helper.waitForEventsAcks((Ignite)this.ignite(0));
        this.stopGrid(0);
        this.waitForTopology(4);
        for (Ignite node : G.allGrids()) {
            node.compute().broadcast((IgniteCallable)new ZookeeperDiscoverySpiTestHelper.DummyCallable(null));
        }
        this.startGrid(0);
        this.waitForTopology(5);
        this.awaitPartitionMapExchange();
        this.helper.waitForEventsAcks(this.grid(CU.oldest((Collection)this.ignite(1).cluster().nodes())));
    }

    @Test
    public void testStartStop3() throws Exception {
        this.startGrids(4);
        this.awaitPartitionMapExchange();
        this.stopGrid(0);
        this.startGrid(5);
        this.awaitPartitionMapExchange();
    }

    @Test
    public void testStartStop4() throws Exception {
        this.startGrids(6);
        this.awaitPartitionMapExchange();
        this.stopGrid(2);
        if (ThreadLocalRandom.current().nextBoolean()) {
            this.awaitPartitionMapExchange();
        }
        this.stopGrid(1);
        if (ThreadLocalRandom.current().nextBoolean()) {
            this.awaitPartitionMapExchange();
        }
        this.stopGrid(0);
        if (ThreadLocalRandom.current().nextBoolean()) {
            this.awaitPartitionMapExchange();
        }
        this.startGrid(7);
        this.awaitPartitionMapExchange();
    }

    @Test
    public void testStartStop2() throws Exception {
        this.startGridsMultiThreaded(10, false);
        GridTestUtils.runMultiThreaded(arg_0 -> ((ZookeeperDiscoveryConcurrentStartAndStartStopTest)this).stopGrid(arg_0), (int)3, (String)"stop-node-thread");
        this.waitForTopology(7);
        this.startGridsMultiThreaded(0, 3);
        this.waitForTopology(10);
    }

    @Test
    public void testStartStopWithClients() throws Exception {
        int SRVS = 3;
        this.startGrids(3);
        this.helper.clientMode(true);
        int THREADS = 30;
        for (int i = 0; i < GridTestUtils.SF.applyLB((int)5, (int)2); ++i) {
            this.info("Iteration: " + i);
            this.startGridsMultiThreaded(3, 30);
            this.waitForTopology(33);
            GridTestUtils.runMultiThreaded((IgniteInClosure)new IgniteInClosure<Integer>(){

                public void apply(Integer idx) {
                    ZookeeperDiscoveryConcurrentStartAndStartStopTest.this.stopGrid(idx + 3);
                }
            }, (int)30, (String)"stop-node");
            this.waitForTopology(3);
            this.checkEventsConsistency();
        }
    }
}

