/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.spi.discovery.zk;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.curator.test.InstanceSpec;
import org.apache.curator.test.TestingCluster;
import org.apache.ignite.IgniteException;

public class ZookeeperDiscoverySpiTestUtil {
    public static final String ZK_ELECTION_PORT_BIND_RETRY = "electionPortBindRetry";
    public static final String ZK_ENABLE_ADMIN_SERVER = "admin.enableServer";

    public static TestingCluster createTestingCluster(int instances) {
        return ZookeeperDiscoverySpiTestUtil.createTestingCluster(instances, 0);
    }

    public static TestingCluster createTestingCluster(int instances, int firstInstanceIdx) {
        String tmpDir = System.getenv("TMPFS_ROOT") != null ? System.getenv("TMPFS_ROOT") : System.getProperty("java.io.tmpdir");
        ArrayList<InstanceSpec> specs = new ArrayList<InstanceSpec>();
        int n = firstInstanceIdx + instances;
        for (int i = firstInstanceIdx; i < n; ++i) {
            File file = new File(tmpDir, "apacheIgniteTestZk-" + i);
            if (file.isDirectory()) {
                ZookeeperDiscoverySpiTestUtil.deleteRecursively0(file);
            } else if (!file.mkdirs()) {
                throw new IgniteException("Failed to create directory for test Zookeeper server: " + file.getAbsolutePath());
            }
            specs.add(new InstanceSpec(file, -1, -1, -1, true, -1, -1, 500, ZookeeperDiscoverySpiTestUtil.clusterCustomProperties()));
        }
        return new TestingCluster(specs);
    }

    private static Map<String, Object> clusterCustomProperties() {
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.putIfAbsent(ZK_ELECTION_PORT_BIND_RETRY, "0");
        props.putIfAbsent(ZK_ENABLE_ADMIN_SERVER, "false");
        return props;
    }

    private static void deleteRecursively0(File file) {
        File[] files = file.listFiles();
        if (files == null) {
            return;
        }
        for (File f : files) {
            if (f.isDirectory()) {
                ZookeeperDiscoverySpiTestUtil.deleteRecursively0(f);
                continue;
            }
            if (f.delete()) continue;
            throw new IgniteException("Failed to delete file: " + f.getAbsolutePath());
        }
    }
}

