/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.spi.discovery.zk.internal;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Paths;
import javax.security.auth.login.Configuration;
import org.apache.curator.test.DirectoryUtils;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.spi.discovery.DiscoverySpi;
import org.apache.ignite.spi.discovery.zk.ZookeeperDiscoverySpi;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;
import org.apache.zookeeper.server.ServerCnxnFactory;
import org.apache.zookeeper.server.ZKDatabase;
import org.apache.zookeeper.server.ZooKeeperServer;

public abstract class ZookeeperDiscoverySpiSaslAuthAbstractTest
extends GridCommonAbstractTest {
    private File tmpDir = this.createTmpDir();
    private static final String JAAS_CONF_FILE = "jaas.conf";
    private static final String AUTH_PROVIDER = "zookeeper.authProvider.1";
    private static final String SASL_CONFIG = "java.security.auth.login.config";
    private long joinTimeout = 2000L;
    private long sesTimeout = 10000L;
    private ServerCnxnFactory serverFactory;
    private String hostPort = "localhost:2181";
    private int maxCnxns;

    protected IgniteConfiguration getConfiguration(String instanceName) throws Exception {
        IgniteConfiguration cfg = super.getConfiguration(instanceName);
        ZookeeperDiscoverySpi zkSpi = new ZookeeperDiscoverySpi();
        if (this.joinTimeout != 0L) {
            zkSpi.setJoinTimeout(this.joinTimeout);
        }
        zkSpi.setSessionTimeout(this.sesTimeout > 0L ? this.sesTimeout : 10000L);
        zkSpi.setZkConnectionString(this.hostPort);
        cfg.setDiscoverySpi((DiscoverySpi)zkSpi);
        return cfg;
    }

    protected void beforeTest() throws Exception {
        this.prepareJaasConfigFile();
        this.prepareSaslSystemProperties();
        this.startZooKeeperServer();
    }

    protected void afterTest() throws Exception {
        this.stopZooKeeperServer();
        this.stopAllGrids();
        this.clearSaslSystemProperties();
        this.clearTmpDir();
    }

    private void clearTmpDir() throws Exception {
        DirectoryUtils.deleteRecursively((File)this.tmpDir);
    }

    protected void clearSaslSystemProperties() {
        Configuration.setConfiguration(null);
        System.clearProperty(AUTH_PROVIDER);
        System.clearProperty(SASL_CONFIG);
        System.clearProperty("zookeeper.sasl.clientconfig");
    }

    private void prepareJaasConfigFile() throws Exception {
        U.ensureDirectory((File)this.tmpDir, (String)"Temp directory for JAAS configuration file wasn't created", null);
        File saslConfFile = new File(this.tmpDir, JAAS_CONF_FILE);
        FileWriter fwriter = new FileWriter(saslConfFile);
        this.writeServerConfigSection(fwriter, "validPassword");
        this.writeClientConfigSection(fwriter, "ValidZookeeperClient", "validPassword");
        this.writeClientConfigSection(fwriter, "InvalidZookeeperClient", "invalidPassword");
        fwriter.close();
    }

    private void prepareSaslSystemProperties() {
        Configuration.setConfiguration(null);
        System.setProperty(SASL_CONFIG, Paths.get(this.tmpDir.getPath().toString(), JAAS_CONF_FILE).toString());
        System.setProperty(AUTH_PROVIDER, "org.apache.zookeeper.server.auth.SASLAuthenticationProvider");
    }

    private void writeClientConfigSection(FileWriter fwriter, String clientName, String pass) throws IOException {
        fwriter.write(clientName + "{\n       org.apache.zookeeper.server.auth.DigestLoginModule required\n       username=\"zkUser\"\n       password=\"" + pass + "\";\n};\n");
    }

    private void writeServerConfigSection(FileWriter fwriter, String pass) throws IOException {
        fwriter.write("Server {\n          org.apache.zookeeper.server.auth.DigestLoginModule required\n          user_zkUser=\"" + pass + "\";\n};\n");
    }

    private File createTmpDir() {
        File jaasConfDir = Paths.get(System.getProperty("java.io.tmpdir"), "zk_disco_spi_test").toFile();
        try {
            U.ensureDirectory((File)jaasConfDir, (String)"", null);
        }
        catch (IgniteCheckedException igniteCheckedException) {
            // empty catch block
        }
        return jaasConfDir;
    }

    private void stopZooKeeperServer() throws Exception {
        this.shutdownServerInstance(this.serverFactory);
        this.serverFactory = null;
    }

    private void shutdownServerInstance(ServerCnxnFactory factory) {
        if (factory != null) {
            ZKDatabase zkDb = null;
            ZooKeeperServer zs = this.getServer(factory);
            if (zs != null) {
                zkDb = zs.getZKDatabase();
            }
            factory.shutdown();
            try {
                if (zkDb != null) {
                    zkDb.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private ZooKeeperServer getServer(ServerCnxnFactory fac) {
        ZooKeeperServer zs = (ZooKeeperServer)U.field((Object)fac, (String)"zkServer");
        return zs;
    }

    private void startZooKeeperServer() throws Exception {
        this.serverFactory = this.createNewServerInstance(this.serverFactory, this.hostPort, this.maxCnxns);
        this.startServerInstance(this.tmpDir, this.serverFactory);
    }

    private ServerCnxnFactory createNewServerInstance(ServerCnxnFactory factory, String hostPort, int maxCnxns) throws IOException {
        int port = this.getPort(hostPort);
        if (factory == null) {
            factory = ServerCnxnFactory.createFactory((int)port, (int)maxCnxns);
        }
        return factory;
    }

    private void startServerInstance(File dataDir, ServerCnxnFactory factory) throws IOException, InterruptedException {
        ZooKeeperServer zks = new ZooKeeperServer(dataDir, dataDir, 3000);
        factory.startup(zks);
    }

    private int getPort(String hostPort) {
        String[] split = hostPort.split(":");
        String portstr = split[split.length - 1];
        String[] pc = portstr.split("/");
        if (pc.length > 1) {
            portstr = pc[0];
        }
        return Integer.parseInt(portstr);
    }
}

