/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.spi.discovery.zk.internal;

import java.io.Serializable;
import java.lang.management.ManagementFactory;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.Callable;
import javax.management.JMX;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cache.affinity.AffinityFunction;
import org.apache.ignite.cache.affinity.rendezvous.RendezvousAffinityFunction;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.SecurityCredentialsAttrFilterPredicate;
import org.apache.ignite.internal.processors.security.SecurityContext;
import org.apache.ignite.internal.processors.security.SecurityUtils;
import org.apache.ignite.internal.util.lang.gridfunc.PredicateMapView;
import org.apache.ignite.internal.util.typedef.G;
import org.apache.ignite.internal.util.typedef.X;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteOutClosure;
import org.apache.ignite.lang.IgnitePredicate;
import org.apache.ignite.marshaller.Marshaller;
import org.apache.ignite.plugin.security.SecurityCredentials;
import org.apache.ignite.plugin.security.SecurityPermission;
import org.apache.ignite.plugin.security.SecuritySubject;
import org.apache.ignite.spi.IgniteSpiException;
import org.apache.ignite.spi.discovery.DiscoverySpiNodeAuthenticator;
import org.apache.ignite.spi.discovery.zk.ZookeeperDiscoverySpi;
import org.apache.ignite.spi.discovery.zk.ZookeeperDiscoverySpiMBean;
import org.apache.ignite.spi.discovery.zk.internal.ZookeeperDiscoverySpiTestBase;
import org.apache.ignite.testframework.GridTestUtils;
import org.junit.Test;

public class ZookeeperDiscoveryMiscTest
extends ZookeeperDiscoverySpiTestBase {
    private CacheConfiguration ccfg;

    @Override
    protected IgniteConfiguration getConfiguration(String igniteInstanceName) throws Exception {
        IgniteConfiguration cfg = super.getConfiguration(igniteInstanceName);
        if (this.ccfg != null) {
            cfg.setCacheConfiguration(new CacheConfiguration[]{this.ccfg});
        }
        return cfg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNodeAttributesNotReferencingZookeeperClusterNode() throws Exception {
        this.userAttrs = new HashMap();
        this.userAttrs.put("testAttr", "testAttr");
        try {
            IgniteEx ignite = this.startGrid(0);
            Map attrs = ignite.cluster().localNode().attributes();
            ZookeeperDiscoveryMiscTest.assertTrue((boolean)(attrs instanceof PredicateMapView));
            IgnitePredicate[] preds = (IgnitePredicate[])GridTestUtils.getFieldValue((Object)attrs, (String[])new String[]{"preds"});
            ZookeeperDiscoveryMiscTest.assertNotNull((Object)preds);
            ZookeeperDiscoveryMiscTest.assertEquals((int)1, (int)preds.length);
            ZookeeperDiscoveryMiscTest.assertTrue((boolean)(preds[0] instanceof SecurityCredentialsAttrFilterPredicate));
        }
        finally {
            this.userAttrs = null;
        }
    }

    @Test
    public void testZkRootNotExists() throws Exception {
        this.zkRootPath = "/a/b/c";
        for (int i = 0; i < 3; ++i) {
            this.reset();
            this.startGridsMultiThreaded(5);
            this.waitForTopology(5);
            this.stopAllGrids();
            this.checkEventsConsistency();
        }
    }

    @Test
    public void testMetadataUpdate() throws Exception {
        this.startGrid(0);
        GridTestUtils.runMultiThreaded((Callable)new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                ZookeeperDiscoveryMiscTest.this.ignite(0).configuration().getMarshaller().marshal((Object)new C1());
                ZookeeperDiscoveryMiscTest.this.ignite(0).configuration().getMarshaller().marshal((Object)new C2());
                return null;
            }
        }, (int)64, (String)"marshal");
    }

    @Test
    public void testNodeAddresses() throws Exception {
        this.startGridsMultiThreaded(3);
        this.helper.clientMode(true);
        this.startGridsMultiThreaded(3, 3);
        this.waitForTopology(6);
        for (Ignite node : G.allGrids()) {
            ClusterNode locNode0 = node.cluster().localNode();
            ZookeeperDiscoveryMiscTest.assertTrue((!locNode0.addresses().isEmpty() ? 1 : 0) != 0);
            ZookeeperDiscoveryMiscTest.assertTrue((!locNode0.hostNames().isEmpty() ? 1 : 0) != 0);
            for (ClusterNode node0 : node.cluster().nodes()) {
                ZookeeperDiscoveryMiscTest.assertTrue((!node0.addresses().isEmpty() ? 1 : 0) != 0);
                ZookeeperDiscoveryMiscTest.assertTrue((!node0.hostNames().isEmpty() ? 1 : 0) != 0);
            }
        }
    }

    @Test
    public void testSetConsistentId() throws Exception {
        this.startGridsMultiThreaded(3);
        this.helper.clientMode(true);
        this.startGridsMultiThreaded(3, 3);
        this.waitForTopology(6);
        for (Ignite node : G.allGrids()) {
            ClusterNode locNode0 = node.cluster().localNode();
            ZookeeperDiscoveryMiscTest.assertEquals((Object)locNode0.attribute("org.apache.ignite.ignite.name"), (Object)locNode0.consistentId());
            for (ClusterNode node0 : node.cluster().nodes()) {
                ZookeeperDiscoveryMiscTest.assertEquals((Object)node0.attribute("org.apache.ignite.ignite.name"), (Object)node0.consistentId());
            }
        }
    }

    @Test
    public void testDefaultConsistentId() throws Exception {
        this.dfltConsistenId = true;
        this.startGridsMultiThreaded(3);
        this.helper.clientMode(true);
        this.startGridsMultiThreaded(3, 3);
        this.waitForTopology(6);
        for (Ignite node : G.allGrids()) {
            ClusterNode locNode0 = node.cluster().localNode();
            ZookeeperDiscoveryMiscTest.assertNotNull((Object)locNode0.consistentId());
            for (ClusterNode node0 : node.cluster().nodes()) {
                ZookeeperDiscoveryMiscTest.assertNotNull((Object)node0.consistentId());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMbean() throws Exception {
        this.startGrids(3);
        MBeanServer srv = ManagementFactory.getPlatformMBeanServer();
        UUID crdNodeId = this.grid(0).localNode().id();
        try {
            for (int i = 0; i < 3; ++i) {
                IgniteEx grid = this.grid(i);
                ObjectName spiName = U.makeMBeanName((String)grid.context().igniteInstanceName(), (String)"SPIs", (String)ZookeeperDiscoverySpi.class.getSimpleName());
                ZookeeperDiscoverySpiMBean bean = JMX.newMBeanProxy(srv, spiName, ZookeeperDiscoverySpiMBean.class);
                ZookeeperDiscoveryMiscTest.assertNotNull((Object)bean);
                ZookeeperDiscoveryMiscTest.assertEquals((String)String.valueOf(grid.cluster().node(crdNodeId)), (String)bean.getCoordinatorNodeFormatted());
                ZookeeperDiscoveryMiscTest.assertEquals((String)String.valueOf(grid.cluster().localNode()), (String)bean.getLocalNodeFormatted());
                ZookeeperDiscoveryMiscTest.assertEquals((String)zkCluster.getConnectString(), (String)bean.getZkConnectionString());
                ZookeeperDiscoveryMiscTest.assertEquals((long)grid.configuration().getFailureDetectionTimeout(), (long)bean.getZkSessionTimeout());
            }
        }
        finally {
            this.stopAllGrids();
        }
    }

    @Test
    public void testClientNodesStatus() throws Exception {
        this.startGrid(0);
        for (Ignite node : G.allGrids()) {
            ZookeeperDiscoveryMiscTest.assertEquals((int)0, (int)node.cluster().forClients().nodes().size());
            ZookeeperDiscoveryMiscTest.assertEquals((int)1, (int)node.cluster().forServers().nodes().size());
        }
        this.helper.clientMode(true);
        this.startGrid(1);
        for (Ignite node : G.allGrids()) {
            ZookeeperDiscoveryMiscTest.assertEquals((int)1, (int)node.cluster().forClients().nodes().size());
            ZookeeperDiscoveryMiscTest.assertEquals((int)1, (int)node.cluster().forServers().nodes().size());
        }
        this.helper.clientMode(false);
        this.startGrid(2);
        this.helper.clientMode(true);
        this.startGrid(3);
        for (Ignite node : G.allGrids()) {
            ZookeeperDiscoveryMiscTest.assertEquals((int)2, (int)node.cluster().forClients().nodes().size());
            ZookeeperDiscoveryMiscTest.assertEquals((int)2, (int)node.cluster().forServers().nodes().size());
        }
        this.stopGrid(1);
        this.waitForTopology(3);
        for (Ignite node : G.allGrids()) {
            ZookeeperDiscoveryMiscTest.assertEquals((int)1, (int)node.cluster().forClients().nodes().size());
            ZookeeperDiscoveryMiscTest.assertEquals((int)2, (int)node.cluster().forServers().nodes().size());
        }
        this.stopGrid(2);
        this.waitForTopology(2);
        for (Ignite node : G.allGrids()) {
            ZookeeperDiscoveryMiscTest.assertEquals((int)1, (int)node.cluster().forClients().nodes().size());
            ZookeeperDiscoveryMiscTest.assertEquals((int)1, (int)node.cluster().forServers().nodes().size());
        }
    }

    @Test
    public void testLocalAuthenticationFails() throws Exception {
        this.auth = ZkTestNodeAuthenticator.factory(this.getTestIgniteInstanceName(0));
        Throwable err = GridTestUtils.assertThrows((IgniteLogger)log, (Callable)new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                ZookeeperDiscoveryMiscTest.this.startGrid(0);
                return null;
            }
        }, IgniteCheckedException.class, null);
        IgniteSpiException spiErr = (IgniteSpiException)X.cause((Throwable)err, IgniteSpiException.class);
        ZookeeperDiscoveryMiscTest.assertNotNull((Object)((Object)spiErr));
        ZookeeperDiscoveryMiscTest.assertTrue((boolean)spiErr.getMessage().contains("Failed to authenticate local node"));
        this.startGrid(1);
        this.startGrid(2);
        this.checkTestSecuritySubject(2);
    }

    @Test
    public void testNodeValidation() throws Exception {
        this.ccfg = new CacheConfiguration("validate-test-cache");
        this.ccfg.setAffinity((AffinityFunction)new ValidationTestAffinity());
        this.startGrid(0);
        this.ccfg = new CacheConfiguration("validate-test-cache");
        this.ccfg.setAffinity((AffinityFunction)new ValidationTestAffinity());
        this.checkStartFail(1, "Failed to add node to topology because it has the same hash code");
    }

    @Test
    public void testAuthentication() throws Exception {
        this.auth = ZkTestNodeAuthenticator.factory(this.getTestIgniteInstanceName(1), this.getTestIgniteInstanceName(5));
        String expErr = "Authentication failed";
        this.startGrid(0);
        this.checkTestSecuritySubject(1);
        this.helper.clientMode(false);
        this.checkStartFail(1, expErr);
        this.helper.clientMode(true);
        this.checkStartFail(1, expErr);
        this.helper.clientMode(false);
        this.startGrid(2);
        this.checkTestSecuritySubject(2);
        this.stopGrid(2);
        this.checkTestSecuritySubject(1);
        this.startGrid(2);
        this.checkTestSecuritySubject(2);
        this.stopGrid(0);
        this.checkTestSecuritySubject(1);
        this.checkStartFail(1, expErr);
        this.helper.clientMode(false);
        this.startGrid(3);
        this.helper.clientMode(true);
        this.startGrid(4);
        this.helper.clientMode(false);
        this.startGrid(0);
        this.checkTestSecuritySubject(4);
        this.checkStartFail(1, expErr);
        this.checkStartFail(5, expErr);
        this.helper.clientMode(true);
        this.checkStartFail(1, expErr);
        this.checkStartFail(5, expErr);
    }

    private void checkStartFail(final int nodeIdx, String expMsg) {
        Throwable err = GridTestUtils.assertThrows((IgniteLogger)log, (Callable)new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                ZookeeperDiscoveryMiscTest.this.startGrid(nodeIdx);
                return null;
            }
        }, IgniteCheckedException.class, null);
        IgniteSpiException spiErr = (IgniteSpiException)X.cause((Throwable)err, IgniteSpiException.class);
        ZookeeperDiscoveryMiscTest.assertNotNull((Object)((Object)spiErr));
        ZookeeperDiscoveryMiscTest.assertTrue((String)spiErr.getMessage(), (boolean)spiErr.getMessage().contains(expMsg));
    }

    private void checkTestSecuritySubject(int expNodes) throws Exception {
        this.waitForTopology(expNodes);
        List nodes = G.allGrids();
        for (Ignite ignite : nodes) {
            Collection nodes0 = ignite.cluster().nodes();
            ZookeeperDiscoveryMiscTest.assertEquals((int)nodes.size(), (int)nodes0.size());
            for (ClusterNode node : nodes0) {
                SecurityContext secCtx = SecurityUtils.nodeSecurityContext((Marshaller)((IgniteEx)ignite).context().marshallerContext().jdkMarshaller(), (ClassLoader)U.resolveClassLoader((IgniteConfiguration)ignite.configuration()), (ClusterNode)node);
                ZookeeperDiscoveryMiscTest.assertEquals((String)((String)node.attribute("org.apache.ignite.ignite.name")), (String)((ZkTestNodeAuthenticator.TestSecurityContext)secCtx).nodeName);
            }
        }
    }

    @Test
    public void testStopNode_1() throws Exception {
        this.startGrids(5);
        this.waitForTopology(5);
        this.stopGrid(3);
        this.waitForTopology(4);
        this.startGrid(3);
        this.waitForTopology(5);
    }

    @Test
    public void testZkMbeansValidity() throws Exception {
        try {
            IgniteEx ignite = this.startGrid();
            this.validateMbeans((Ignite)ignite, new String[]{"org.apache.ignite.spi.discovery.zk.ZookeeperDiscoverySpi$ZookeeperDiscoverySpiMBeanImpl"});
        }
        finally {
            this.stopAllGrids();
        }
    }

    static class ZkTestNodeAuthenticator
    implements DiscoverySpiNodeAuthenticator {
        private final Collection<String> failAuthNodes;

        static IgniteOutClosure<DiscoverySpiNodeAuthenticator> factory(final String ... failAuthNodes) {
            return new IgniteOutClosure<DiscoverySpiNodeAuthenticator>(){

                public DiscoverySpiNodeAuthenticator apply() {
                    return new ZkTestNodeAuthenticator(Arrays.asList(failAuthNodes));
                }
            };
        }

        ZkTestNodeAuthenticator(Collection<String> failAuthNodes) {
            this.failAuthNodes = failAuthNodes;
        }

        public SecurityContext authenticateNode(ClusterNode node, SecurityCredentials cred) {
            ZookeeperDiscoveryMiscTest.assertNotNull((Object)cred);
            String nodeName = (String)node.attribute("org.apache.ignite.ignite.name");
            ZookeeperDiscoveryMiscTest.assertEquals((Object)nodeName, (Object)cred.getUserObject());
            boolean auth = !this.failAuthNodes.contains(nodeName);
            System.out.println(Thread.currentThread().getName() + " authenticateNode [node=" + node.id() + ", res=" + auth + ']');
            return auth ? new TestSecurityContext(nodeName) : null;
        }

        public boolean isGlobalNodeAuthentication() {
            return false;
        }

        private static class TestSecurityContext
        implements SecurityContext,
        Serializable {
            private static final long serialVersionUID = 0L;
            final String nodeName;

            TestSecurityContext(String nodeName) {
                this.nodeName = nodeName;
            }

            public SecuritySubject subject() {
                return null;
            }

            public boolean taskOperationAllowed(String taskClsName, SecurityPermission perm) {
                return true;
            }

            public boolean cacheOperationAllowed(String cacheName, SecurityPermission perm) {
                return true;
            }

            public boolean serviceOperationAllowed(String srvcName, SecurityPermission perm) {
                return true;
            }

            public boolean tracingOperationAllowed(SecurityPermission perm) {
                return true;
            }

            public boolean systemOperationAllowed(SecurityPermission perm) {
                return true;
            }
        }
    }

    private static class C2
    implements Serializable {
        private C2() {
        }
    }

    private static class C1
    implements Serializable {
        private C1() {
        }
    }

    private static class ValidationTestAffinity
    extends RendezvousAffinityFunction {
        private ValidationTestAffinity() {
        }

        public Object resolveNodeHash(ClusterNode node) {
            return 0;
        }
    }
}

