/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.spi.discovery.zk.internal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cache.CacheMode;
import org.apache.ignite.cache.affinity.AffinityFunction;
import org.apache.ignite.cache.affinity.rendezvous.RendezvousAffinityFunction;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.CommunicationFailureContext;
import org.apache.ignite.configuration.CommunicationFailureResolver;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.TestRecordingCommunicationSpi;
import org.apache.ignite.internal.cluster.ClusterTopologyCheckedException;
import org.apache.ignite.internal.processors.cache.distributed.TestCacheNodeExcludingFilter;
import org.apache.ignite.internal.processors.cache.distributed.dht.preloader.GridDhtPartitionSupplyMessage;
import org.apache.ignite.internal.util.future.GridCompoundFuture;
import org.apache.ignite.internal.util.typedef.G;
import org.apache.ignite.internal.util.typedef.T3;
import org.apache.ignite.internal.util.typedef.internal.CU;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteBiPredicate;
import org.apache.ignite.lang.IgniteInClosure;
import org.apache.ignite.lang.IgniteOutClosure;
import org.apache.ignite.lang.IgnitePredicate;
import org.apache.ignite.plugin.extensions.communication.Message;
import org.apache.ignite.resources.LoggerResource;
import org.apache.ignite.spi.IgniteSpiException;
import org.apache.ignite.spi.communication.tcp.TcpCommunicationSpi;
import org.apache.ignite.spi.discovery.zk.ZookeeperDiscoverySpi;
import org.apache.ignite.spi.discovery.zk.internal.ZookeeperDiscoverySpiTestBase;
import org.apache.ignite.testframework.GridTestUtils;
import org.apache.zookeeper.ZkTestClientCnxnSocketNIO;
import org.junit.Ignore;
import org.junit.Test;

public class ZookeeperDiscoveryCommunicationFailureTest
extends ZookeeperDiscoverySpiTestBase {
    @Test
    public void testNoOpCommunicationFailureResolve_1() throws Exception {
        this.communicationFailureResolve_Simple(2);
    }

    @Test
    public void testNoOpCommunicationErrorResolve_2() throws Exception {
        this.communicationFailureResolve_Simple(10);
    }

    private void communicationFailureResolve_Simple(int nodes) throws Exception {
        assert (nodes > 1);
        this.sesTimeout = 2000L;
        this.commFailureRslvr = NoOpCommunicationFailureResolver.FACTORY;
        this.startGridsMultiThreaded(nodes);
        ThreadLocalRandom rnd = ThreadLocalRandom.current();
        for (int i = 0; i < 3; ++i) {
            int idx2;
            this.info("Iteration: " + i);
            int idx1 = rnd.nextInt(nodes);
            while (idx1 == (idx2 = rnd.nextInt(nodes))) {
            }
            ZookeeperDiscoverySpi spi = ZookeeperDiscoveryCommunicationFailureTest.spi((Ignite)this.ignite(idx1));
            spi.resolveCommunicationFailure(this.ignite(idx2).cluster().localNode(), new Exception("test"));
            this.checkInternalStructuresCleanup();
        }
    }

    @Test
    public void testNoOpCommunicationErrorResolve_3() throws Exception {
        this.sesTimeout = 2000L;
        this.commFailureRslvr = NoOpCommunicationFailureResolver.FACTORY;
        this.startGridsMultiThreaded(3);
        this.sesTimeout = 10000L;
        this.testSockNio = true;
        this.sesTimeout = 5000L;
        this.startGrid(3);
        IgniteInternalFuture fut = GridTestUtils.runAsync((Callable)new Callable<Object>(){

            @Override
            public Object call() {
                ZookeeperDiscoverySpi spi = ZookeeperDiscoverySpiTestBase.spi((Ignite)ZookeeperDiscoveryCommunicationFailureTest.this.ignite(0));
                spi.resolveCommunicationFailure(ZookeeperDiscoveryCommunicationFailureTest.this.ignite(1).cluster().localNode(), new Exception("test"));
                return null;
            }
        });
        U.sleep((long)1000L);
        ZkTestClientCnxnSocketNIO nio = ZkTestClientCnxnSocketNIO.forNode((Ignite)this.ignite(3));
        nio.closeSocket(true);
        try {
            this.stopGrid(3);
            fut.get();
        }
        finally {
            nio.allowConnect();
        }
        this.waitForTopology(3);
    }

    @Test
    public void testNoOpCommunicationErrorResolve_4() throws Exception {
        this.testCommSpi = true;
        this.sesTimeout = 2000L;
        this.commFailureRslvr = NoOpCommunicationFailureResolver.FACTORY;
        this.startGrid(0);
        this.startGridsMultiThreaded(1, 3);
        ZookeeperDiscoverySpiTestBase.ZkTestCommunicationSpi commSpi = ZookeeperDiscoverySpiTestBase.ZkTestCommunicationSpi.testSpi((Ignite)this.ignite(3));
        commSpi.pingLatch = new CountDownLatch(1);
        IgniteInternalFuture fut = GridTestUtils.runAsync((Callable)new Callable<Object>(){

            @Override
            public Object call() {
                ZookeeperDiscoverySpi spi = ZookeeperDiscoverySpiTestBase.spi((Ignite)ZookeeperDiscoveryCommunicationFailureTest.this.ignite(1));
                spi.resolveCommunicationFailure(ZookeeperDiscoveryCommunicationFailureTest.this.ignite(2).cluster().localNode(), new Exception("test"));
                return null;
            }
        });
        U.sleep((long)1000L);
        ZookeeperDiscoveryCommunicationFailureTest.assertFalse((boolean)fut.isDone());
        this.stopGrid(0);
        this.awaitPartitionMapExchange();
        commSpi.pingLatch.countDown();
        fut.get();
        this.waitForTopology(3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNoOpCommunicationErrorResolve_5() throws Exception {
        this.testCommSpi = true;
        this.sesTimeout = 2000L;
        this.commFailureRslvr = NoOpCommunicationFailureResolver.FACTORY;
        this.startGrid(0);
        this.startGridsMultiThreaded(1, 3);
        ZookeeperDiscoverySpiTestBase.ZkTestCommunicationSpi commSpi = ZookeeperDiscoverySpiTestBase.ZkTestCommunicationSpi.testSpi((Ignite)this.ignite(3));
        commSpi.pingStartLatch = new CountDownLatch(1);
        commSpi.pingLatch = new CountDownLatch(1);
        IgniteInternalFuture fut = GridTestUtils.runAsync((Callable)new Callable<Object>(){

            @Override
            public Object call() {
                ZookeeperDiscoverySpi spi = ZookeeperDiscoverySpiTestBase.spi((Ignite)ZookeeperDiscoveryCommunicationFailureTest.this.ignite(1));
                spi.resolveCommunicationFailure(ZookeeperDiscoveryCommunicationFailureTest.this.ignite(2).cluster().localNode(), new Exception("test"));
                return null;
            }
        });
        ZookeeperDiscoveryCommunicationFailureTest.assertTrue((boolean)commSpi.pingStartLatch.await(10L, TimeUnit.SECONDS));
        try {
            ZookeeperDiscoveryCommunicationFailureTest.assertFalse((boolean)fut.isDone());
            final AtomicInteger nodeIdx = new AtomicInteger(3);
            IgniteInternalFuture startFut = GridTestUtils.runMultiThreadedAsync((Callable)new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    ZookeeperDiscoveryCommunicationFailureTest.this.startGrid(nodeIdx.incrementAndGet());
                    return null;
                }
            }, (int)3, (String)"start-node");
            U.sleep((long)1000L);
            ZookeeperDiscoveryCommunicationFailureTest.assertFalse((boolean)startFut.isDone());
            ZookeeperDiscoveryCommunicationFailureTest.assertEquals((int)4, (int)this.ignite(0).cluster().nodes().size());
            commSpi.pingLatch.countDown();
            startFut.get();
            fut.get();
            this.waitForTopology(7);
        }
        finally {
            commSpi.pingLatch.countDown();
        }
    }

    @Test
    public void testCommunicationErrorResolve_KillNode_1() throws Exception {
        this.communicationFailureResolve_KillNodes(2, Collections.singleton(2L));
    }

    @Test
    public void testCommunicationErrorResolve_KillNode_2() throws Exception {
        this.communicationFailureResolve_KillNodes(3, Collections.singleton(2L));
    }

    @Test
    public void testCommunicationErrorResolve_KillNode_3() throws Exception {
        this.communicationFailureResolve_KillNodes(10, Arrays.asList(2L, 4L, 6L));
    }

    @Test
    public void testCommunicationErrorResolve_KillCoordinator_1() throws Exception {
        this.communicationFailureResolve_KillNodes(2, Collections.singleton(1L));
    }

    @Test
    public void testCommunicationErrorResolve_KillCoordinator_2() throws Exception {
        this.communicationFailureResolve_KillNodes(3, Collections.singleton(1L));
    }

    @Test
    public void testCommunicationErrorResolve_KillCoordinator_3() throws Exception {
        this.communicationFailureResolve_KillNodes(10, Arrays.asList(1L, 4L, 6L));
    }

    @Test
    public void testCommunicationErrorResolve_KillCoordinator_4() throws Exception {
        this.communicationFailureResolve_KillNodes(10, Arrays.asList(1L, 2L, 3L));
    }

    private void communicationFailureResolve_KillNodes(int startNodes, Collection<Long> killNodes) throws Exception {
        this.testCommSpi = true;
        this.commFailureRslvr = TestNodeKillCommunicationFailureResolver.factory(killNodes);
        this.startGrids(startNodes);
        ZookeeperDiscoverySpiTestBase.ZkTestCommunicationSpi commSpi = ZookeeperDiscoverySpiTestBase.ZkTestCommunicationSpi.testSpi((Ignite)this.ignite(0));
        commSpi.checkRes = new BitSet(startNodes);
        ZookeeperDiscoverySpi spi = null;
        UUID killNodeId = null;
        for (Ignite node : G.allGrids()) {
            ZookeeperDiscoverySpi spi0 = ZookeeperDiscoveryCommunicationFailureTest.spi(node);
            if (!killNodes.contains(node.cluster().localNode().order())) {
                spi = spi0;
                continue;
            }
            killNodeId = node.cluster().localNode().id();
        }
        ZookeeperDiscoveryCommunicationFailureTest.assertNotNull(spi);
        ZookeeperDiscoveryCommunicationFailureTest.assertNotNull(killNodeId);
        try {
            spi.resolveCommunicationFailure(spi.getNode(killNodeId), new Exception("test"));
            ZookeeperDiscoveryCommunicationFailureTest.fail((String)"Exception is not thrown");
        }
        catch (IgniteSpiException e) {
            ZookeeperDiscoveryCommunicationFailureTest.assertTrue((String)("Unexpected exception: " + (Object)((Object)e)), (boolean)(e.getCause() instanceof ClusterTopologyCheckedException));
        }
        int expNodes = startNodes - killNodes.size();
        this.waitForTopology(expNodes);
        for (Ignite node : G.allGrids()) {
            ZookeeperDiscoveryCommunicationFailureTest.assertFalse((boolean)killNodes.contains(node.cluster().localNode().order()));
        }
        this.startGrid(startNodes);
        this.waitForTopology(expNodes + 1);
    }

    @Test
    public void testCommunicationFailureResolve_KillCoordinator_5() throws Exception {
        this.sesTimeout = 2000L;
        this.testCommSpi = true;
        this.commFailureRslvr = KillCoordinatorCommunicationFailureResolver.FACTORY;
        this.startGrids(10);
        int crd = 0;
        int nodeIdx = 10;
        for (int i = 0; i < GridTestUtils.SF.applyLB((int)4, (int)2); ++i) {
            this.info("Iteration: " + i);
            for (Ignite node : G.allGrids()) {
                ZookeeperDiscoverySpiTestBase.ZkTestCommunicationSpi.testSpi(node).initCheckResult(10, new Integer[0]);
            }
            UUID crdId = this.ignite(crd).cluster().localNode().id();
            ZookeeperDiscoverySpi spi = ZookeeperDiscoveryCommunicationFailureTest.spi((Ignite)this.ignite(crd + 1));
            try {
                spi.resolveCommunicationFailure(spi.getNode(crdId), new Exception("test"));
                ZookeeperDiscoveryCommunicationFailureTest.fail((String)"Exception is not thrown");
            }
            catch (IgniteSpiException e) {
                ZookeeperDiscoveryCommunicationFailureTest.assertTrue((String)("Unexpected exception: " + (Object)((Object)e)), (boolean)(e.getCause() instanceof ClusterTopologyCheckedException));
            }
            this.waitForTopology(9);
            this.startGrid(nodeIdx++);
            this.waitForTopology(10);
            ++crd;
        }
    }

    @Ignore(value="https://issues.apache.org/jira/browse/IGNITE-10988")
    @Test
    public void testCommunicationFailureResolve_KillRandom() throws Exception {
        this.sesTimeout = 2000L;
        this.testCommSpi = true;
        this.commFailureRslvr = KillRandomCommunicationFailureResolver.FACTORY;
        this.startGridsMultiThreaded(10);
        this.helper.clientMode(true);
        this.startGridsMultiThreaded(10, 5);
        int nodesCnt = 15;
        this.waitForTopology(nodesCnt);
        int nodeIdx = 15;
        for (int i = 0; i < GridTestUtils.SF.applyLB((int)10, (int)2); ++i) {
            this.info("Iteration: " + i);
            ZookeeperDiscoverySpi spi = null;
            for (Ignite node : G.allGrids()) {
                ZookeeperDiscoverySpiTestBase.ZkTestCommunicationSpi.testSpi(node).initCheckResult(100, new Integer[0]);
                spi = ZookeeperDiscoveryCommunicationFailureTest.spi(node);
            }
            assert (spi != null);
            try {
                spi.resolveCommunicationFailure((ClusterNode)spi.getRemoteNodes().iterator().next(), new Exception("test"));
            }
            catch (IgniteSpiException igniteSpiException) {
                // empty catch block
            }
            boolean clientMode = ThreadLocalRandom.current().nextBoolean();
            this.helper.clientMode(clientMode);
            this.startGrid(nodeIdx++);
            nodesCnt = nodesCnt - KillRandomCommunicationFailureResolver.LAST_KILLED_NODES.size() + 1;
            this.waitForTopology(nodesCnt);
        }
    }

    @Test
    public void testDefaultCommunicationFailureResolver1() throws Exception {
        this.testCommSpi = true;
        this.sesTimeout = 5000L;
        this.startGrids(3);
        ZookeeperDiscoverySpiTestBase.ZkTestCommunicationSpi.testSpi((Ignite)this.ignite(0)).initCheckResult(3, 0, 1);
        ZookeeperDiscoverySpiTestBase.ZkTestCommunicationSpi.testSpi((Ignite)this.ignite(1)).initCheckResult(3, 0, 1);
        ZookeeperDiscoverySpiTestBase.ZkTestCommunicationSpi.testSpi((Ignite)this.ignite(2)).initCheckResult(3, 2);
        UUID killedId = this.nodeId(2);
        ZookeeperDiscoveryCommunicationFailureTest.assertNotNull((Object)this.ignite(0).cluster().node(killedId));
        ZookeeperDiscoverySpi spi = ZookeeperDiscoveryCommunicationFailureTest.spi((Ignite)this.ignite(0));
        spi.resolveCommunicationFailure(spi.getNode(this.ignite(1).cluster().localNode().id()), new Exception("test"));
        this.waitForTopology(2);
        ZookeeperDiscoveryCommunicationFailureTest.assertNull((Object)this.ignite(0).cluster().node(killedId));
    }

    @Test
    public void testDefaultCommunicationFailureResolver2() throws Exception {
        this.testCommSpi = true;
        this.sesTimeout = 5000L;
        this.startGrids(3);
        this.helper.clientMode(true);
        this.startGridsMultiThreaded(3, 2);
        ZookeeperDiscoverySpiTestBase.ZkTestCommunicationSpi.testSpi((Ignite)this.ignite(0)).initCheckResult(5, 0, 1);
        ZookeeperDiscoverySpiTestBase.ZkTestCommunicationSpi.testSpi((Ignite)this.ignite(1)).initCheckResult(5, 0, 1);
        ZookeeperDiscoverySpiTestBase.ZkTestCommunicationSpi.testSpi((Ignite)this.ignite(2)).initCheckResult(5, 2, 3, 4);
        ZookeeperDiscoverySpiTestBase.ZkTestCommunicationSpi.testSpi((Ignite)this.ignite(3)).initCheckResult(5, 2, 3, 4);
        ZookeeperDiscoverySpiTestBase.ZkTestCommunicationSpi.testSpi((Ignite)this.ignite(4)).initCheckResult(5, 2, 3, 4);
        ZookeeperDiscoverySpi spi = ZookeeperDiscoveryCommunicationFailureTest.spi((Ignite)this.ignite(0));
        spi.resolveCommunicationFailure(spi.getNode(this.ignite(1).cluster().localNode().id()), new Exception("test"));
        this.waitForTopology(2);
    }

    @Test
    public void testDefaultCommunicationFailureResolver6() throws Exception {
        this.testCommSpi = true;
        this.sesTimeout = 5000L;
        this.startGrids(2);
        this.helper.clientMode(true);
        this.startGrid(2);
        this.startGrid(3);
        this.helper.clientMode(false);
        this.awaitPartitionMapExchange();
        UUID isolatedClientId = this.ignite(3).localNode().id();
        ZookeeperDiscoverySpiTestBase.ZkTestCommunicationSpi.testSpi((Ignite)this.ignite(0)).initCheckResult(4, 0, 1, 2);
        ZookeeperDiscoverySpiTestBase.ZkTestCommunicationSpi.testSpi((Ignite)this.ignite(1)).initCheckResult(4, 0, 1, 2);
        ZookeeperDiscoverySpiTestBase.ZkTestCommunicationSpi.testSpi((Ignite)this.ignite(2)).initCheckResult(4, 0, 1, 2);
        ZookeeperDiscoverySpiTestBase.ZkTestCommunicationSpi.testSpi((Ignite)this.ignite(3)).initCheckResult(4, 3);
        ZookeeperDiscoverySpi spi = ZookeeperDiscoveryCommunicationFailureTest.spi((Ignite)this.ignite(0));
        spi.resolveCommunicationFailure(spi.getNode(this.ignite(0).cluster().localNode().id()), new Exception("test"));
        this.waitForTopology(3);
        ZookeeperDiscoveryCommunicationFailureTest.assertNull((Object)this.ignite(0).cluster().node(isolatedClientId));
    }

    @Test
    public void testDefaultCommunicationFailureResolver3() throws Exception {
        this.defaultCommunicationFailureResolver_BreakCommunication(3, 1);
    }

    @Test
    public void testDefaultCommunicationFailureResolver4() throws Exception {
        this.defaultCommunicationFailureResolver_BreakCommunication(3, 0);
    }

    @Test
    public void testDefaultCommunicationFailureResolver5() throws Exception {
        this.defaultCommunicationFailureResolver_BreakCommunication(10, 1, 3, 6);
    }

    private void defaultCommunicationFailureResolver_BreakCommunication(int startNodes, final int ... breakNodes) throws Exception {
        this.sesTimeout = 5000L;
        this.startGridsMultiThreaded(startNodes);
        final CyclicBarrier b = new CyclicBarrier(breakNodes.length);
        GridTestUtils.runMultiThreaded((IgniteInClosure)new IgniteInClosure<Integer>(){

            public void apply(Integer threadIdx) {
                try {
                    b.await();
                    int nodeIdx = breakNodes[threadIdx];
                    ZookeeperDiscoveryCommunicationFailureTest.this.info("Close communication: " + nodeIdx);
                    ((TcpCommunicationSpi)ZookeeperDiscoveryCommunicationFailureTest.this.ignite(nodeIdx).configuration().getCommunicationSpi()).simulateNodeFailure();
                }
                catch (Exception e) {
                    ZookeeperDiscoveryCommunicationFailureTest.fail((String)("Unexpected error: " + e));
                }
            }
        }, (int)breakNodes.length, (String)"break-communication");
        this.waitForTopology(startNodes - breakNodes.length);
    }

    @Test
    public void testCommunicationFailureResolve_CachesInfo1() throws Exception {
        this.testCommSpi = true;
        this.sesTimeout = 5000L;
        final CacheInfoCommunicationFailureResolver rslvr = new CacheInfoCommunicationFailureResolver();
        this.commFailureRslvr = new IgniteOutClosure<CommunicationFailureResolver>(){

            public CommunicationFailureResolver apply() {
                return rslvr;
            }
        };
        this.startGrids(2);
        this.awaitPartitionMapExchange();
        HashMap<String, T3<Integer, Integer, Integer>> expCaches = new HashMap<String, T3<Integer, Integer, Integer>>();
        expCaches.put("default", new T3((Object)1024, (Object)0, (Object)1));
        this.checkResolverCachesInfo((Ignite)this.ignite(0), expCaches);
        ArrayList<CacheConfiguration> caches = new ArrayList<CacheConfiguration>();
        CacheConfiguration c1 = new CacheConfiguration("c1");
        c1.setBackups(1);
        c1.setAffinity((AffinityFunction)new RendezvousAffinityFunction(false, 64));
        caches.add(c1);
        CacheConfiguration c2 = new CacheConfiguration("c2");
        c2.setBackups(2);
        c2.setAffinity((AffinityFunction)new RendezvousAffinityFunction(false, 128));
        caches.add(c2);
        CacheConfiguration c3 = new CacheConfiguration("c3");
        c3.setCacheMode(CacheMode.REPLICATED);
        c3.setAffinity((AffinityFunction)new RendezvousAffinityFunction(false, 256));
        caches.add(c3);
        this.ignite(0).createCaches(caches);
        expCaches.put("c1", (T3<Integer, Integer, Integer>)new T3((Object)64, (Object)1, (Object)2));
        expCaches.put("c2", (T3<Integer, Integer, Integer>)new T3((Object)128, (Object)2, (Object)2));
        expCaches.put("c3", (T3<Integer, Integer, Integer>)new T3((Object)256, (Object)1, (Object)2));
        this.checkResolverCachesInfo((Ignite)this.ignite(0), expCaches);
        this.startGrid(2);
        this.startGrid(3);
        this.awaitPartitionMapExchange();
        expCaches.put("c2", (T3<Integer, Integer, Integer>)new T3((Object)128, (Object)2, (Object)3));
        expCaches.put("c3", (T3<Integer, Integer, Integer>)new T3((Object)256, (Object)1, (Object)4));
        this.checkResolverCachesInfo((Ignite)this.ignite(0), expCaches);
        CacheConfiguration c4 = new CacheConfiguration("c4");
        c4.setCacheMode(CacheMode.PARTITIONED);
        c4.setBackups(0);
        c4.setAffinity((AffinityFunction)new RendezvousAffinityFunction(false, 256));
        c4.setNodeFilter((IgnitePredicate)new TestCacheNodeExcludingFilter(new String[]{this.getTestIgniteInstanceName(0), this.getTestIgniteInstanceName(1)}));
        this.ignite(2).createCache(c4);
        expCaches.put("c4", (T3<Integer, Integer, Integer>)new T3((Object)256, (Object)0, (Object)1));
        this.checkResolverCachesInfo((Ignite)this.ignite(0), expCaches);
        this.stopGrid(0);
        this.awaitPartitionMapExchange();
        expCaches.put("c3", (T3<Integer, Integer, Integer>)new T3((Object)256, (Object)1, (Object)3));
        this.checkResolverCachesInfo((Ignite)this.ignite(1), expCaches);
        this.startGrid(0);
        expCaches.put("c3", (T3<Integer, Integer, Integer>)new T3((Object)256, (Object)1, (Object)4));
        this.checkResolverCachesInfo((Ignite)this.ignite(1), expCaches);
        this.stopGrid(1);
        this.awaitPartitionMapExchange();
        expCaches.put("c3", (T3<Integer, Integer, Integer>)new T3((Object)256, (Object)1, (Object)3));
        this.checkResolverCachesInfo((Ignite)this.ignite(3), expCaches);
    }

    @Test
    public void testCommunicationFailureResolve_CachesInfo2() throws Exception {
        this.testCommSpi = true;
        this.sesTimeout = 5000L;
        final CacheInfoCommunicationFailureResolver rslvr = new CacheInfoCommunicationFailureResolver();
        this.commFailureRslvr = new IgniteOutClosure<CommunicationFailureResolver>(){

            public CommunicationFailureResolver apply() {
                return rslvr;
            }
        };
        IgniteEx srv0 = this.startGrid(0);
        CacheConfiguration ccfg = new CacheConfiguration("c1");
        ccfg.setBackups(1);
        srv0.createCache(ccfg);
        TestRecordingCommunicationSpi.spi((Ignite)srv0).blockMessages((IgniteBiPredicate)new IgniteBiPredicate<ClusterNode, Message>(){

            public boolean apply(ClusterNode node, Message msg) {
                return msg instanceof GridDhtPartitionSupplyMessage && ((GridDhtPartitionSupplyMessage)msg).groupId() == CU.cacheId((String)"c1");
            }
        });
        this.startGrid(1);
        U.sleep((long)1000L);
        ZookeeperDiscoverySpi spi = ZookeeperDiscoveryCommunicationFailureTest.spi((Ignite)srv0);
        rslvr.latch = new CountDownLatch(1);
        ZookeeperDiscoverySpiTestBase.ZkTestCommunicationSpi.testSpi((Ignite)srv0).initCheckResult(2, 0);
        spi.resolveCommunicationFailure((ClusterNode)spi.getRemoteNodes().iterator().next(), new Exception("test"));
        ZookeeperDiscoveryCommunicationFailureTest.assertTrue((boolean)rslvr.latch.await(10L, TimeUnit.SECONDS));
        List<List<ClusterNode>> cacheOwners = rslvr.ownersMap.get("c1");
        ClusterNode node0 = srv0.cluster().localNode();
        for (int p = 0; p < 1024; ++p) {
            List<ClusterNode> owners = cacheOwners.get(p);
            ZookeeperDiscoveryCommunicationFailureTest.assertEquals((int)1, (int)owners.size());
            ZookeeperDiscoveryCommunicationFailureTest.assertEquals((Object)node0, (Object)owners.get(0));
        }
        TestRecordingCommunicationSpi.spi((Ignite)srv0).stopBlock();
        this.awaitPartitionMapExchange();
        HashMap<String, T3<Integer, Integer, Integer>> expCaches = new HashMap<String, T3<Integer, Integer, Integer>>();
        expCaches.put("default", new T3((Object)1024, (Object)0, (Object)1));
        expCaches.put("c1", new T3((Object)1024, (Object)1, (Object)2));
        this.checkResolverCachesInfo((Ignite)srv0, expCaches);
    }

    private void checkResolverCachesInfo(Ignite crd, Map<String, T3<Integer, Integer, Integer>> expCaches) throws Exception {
        CacheInfoCommunicationFailureResolver rslvr = (CacheInfoCommunicationFailureResolver)crd.configuration().getCommunicationFailureResolver();
        ZookeeperDiscoveryCommunicationFailureTest.assertNotNull((Object)rslvr);
        ZookeeperDiscoverySpi spi = ZookeeperDiscoveryCommunicationFailureTest.spi(crd);
        rslvr.latch = new CountDownLatch(1);
        ZookeeperDiscoverySpiTestBase.ZkTestCommunicationSpi.testSpi(crd).initCheckResult(crd.cluster().nodes().size(), 0);
        spi.resolveCommunicationFailure((ClusterNode)spi.getRemoteNodes().iterator().next(), new Exception("test"));
        ZookeeperDiscoveryCommunicationFailureTest.assertTrue((boolean)rslvr.latch.await(10L, TimeUnit.SECONDS));
        rslvr.checkCachesInfo(expCaches);
        rslvr.reset();
    }

    @Test
    public void testCommunicationFailureResolve_ConcurrentDiscoveyEvents() throws Exception {
        this.sesTimeout = 5000L;
        this.commFailureRslvr = NoOpCommunicationFailureResolver.FACTORY;
        int INIT_NODES = 5;
        this.startGridsMultiThreaded(5);
        final CyclicBarrier b = new CyclicBarrier(4);
        GridCompoundFuture fut = new GridCompoundFuture();
        final AtomicBoolean stop = new AtomicBoolean();
        fut.add(GridTestUtils.runAsync((Callable)new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                b.await();
                ThreadLocalRandom rnd = ThreadLocalRandom.current();
                for (int i = 0; i < 10; ++i) {
                    ZookeeperDiscoveryCommunicationFailureTest.this.startGrid(i + 5);
                    Thread.sleep(rnd.nextLong(1000L) + 10L);
                    if (stop.get()) break;
                }
                return null;
            }
        }, (String)"test-node-start"));
        fut.add(GridTestUtils.runAsync((Callable)new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                b.await();
                ThreadLocalRandom rnd = ThreadLocalRandom.current();
                while (!stop.get()) {
                    ZookeeperDiscoveryCommunicationFailureTest.this.startGrid(100);
                    Thread.sleep(rnd.nextLong(1000L) + 10L);
                    ZookeeperDiscoveryCommunicationFailureTest.this.stopGrid(100);
                    Thread.sleep(rnd.nextLong(1000L) + 10L);
                }
                return null;
            }
        }, (String)"test-node-restart"));
        fut.add(GridTestUtils.runAsync((Callable)new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                b.await();
                ThreadLocalRandom rnd = ThreadLocalRandom.current();
                int idx = 0;
                while (!stop.get()) {
                    CacheConfiguration ccfg = new CacheConfiguration("c-" + idx++);
                    ccfg.setBackups(rnd.nextInt(5));
                    ZookeeperDiscoveryCommunicationFailureTest.this.ignite(rnd.nextInt(5)).createCache(ccfg);
                    Thread.sleep(rnd.nextLong(1000L) + 10L);
                    ZookeeperDiscoveryCommunicationFailureTest.this.ignite(rnd.nextInt(5)).destroyCache(ccfg.getName());
                    Thread.sleep(rnd.nextLong(1000L) + 10L);
                }
                return null;
            }
        }, (String)"test-create-cache"));
        fut.add(GridTestUtils.runMultiThreadedAsync((Callable)new Callable<Void>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Void call() throws Exception {
                try {
                    b.await();
                    ThreadLocalRandom rnd = ThreadLocalRandom.current();
                    for (int i = 0; i < 5; ++i) {
                        ZookeeperDiscoveryCommunicationFailureTest.this.info("resolveCommunicationFailure: " + i);
                        ZookeeperDiscoverySpi spi = ZookeeperDiscoverySpiTestBase.spi((Ignite)ZookeeperDiscoveryCommunicationFailureTest.this.ignite(rnd.nextInt(5)));
                        spi.resolveCommunicationFailure(ZookeeperDiscoveryCommunicationFailureTest.this.ignite(rnd.nextInt(5)).cluster().localNode(), new Exception("test"));
                    }
                    Void void_ = null;
                    return void_;
                }
                finally {
                    stop.set(true);
                }
            }
        }, (int)5, (String)"test-resolve-failure"));
        fut.markInitialized();
        fut.get();
    }

    @Test
    public void testCommunicationFailureResolve_ConcurrentMultinode() throws Exception {
        this.sesTimeout = 5000L;
        this.commFailureRslvr = NoOpCommunicationFailureResolver.FACTORY;
        this.startGridsMultiThreaded(5);
        this.helper.clientMode(true);
        this.startGridsMultiThreaded(5, 5);
        int NODES = 10;
        GridTestUtils.runMultiThreaded((Callable)new Callable<Void>(){

            @Override
            public Void call() {
                ThreadLocalRandom rnd = ThreadLocalRandom.current();
                for (int i = 0; i < 5; ++i) {
                    ZookeeperDiscoveryCommunicationFailureTest.this.info("resolveCommunicationFailure: " + i);
                    ZookeeperDiscoverySpi spi = ZookeeperDiscoverySpiTestBase.spi((Ignite)ZookeeperDiscoveryCommunicationFailureTest.this.ignite(rnd.nextInt(10)));
                    spi.resolveCommunicationFailure((ClusterNode)spi.getRemoteNodes().iterator().next(), new Exception("test"));
                }
                return null;
            }
        }, (int)30, (String)"test-resolve-failure");
    }

    private static class TestNodeKillCommunicationFailureResolver
    implements CommunicationFailureResolver {
        final Collection<Long> killNodeOrders;

        static IgniteOutClosure<CommunicationFailureResolver> factory(final Collection<Long> killOrders) {
            return new IgniteOutClosure<CommunicationFailureResolver>(){

                public CommunicationFailureResolver apply() {
                    return new TestNodeKillCommunicationFailureResolver(killOrders);
                }
            };
        }

        TestNodeKillCommunicationFailureResolver(Collection<Long> killNodeOrders) {
            this.killNodeOrders = killNodeOrders;
        }

        public void resolve(CommunicationFailureContext ctx) {
            List nodes = ctx.topologySnapshot();
            ZookeeperDiscoveryCommunicationFailureTest.assertTrue((boolean)(!nodes.isEmpty()));
            for (ClusterNode node : nodes) {
                if (!this.killNodeOrders.contains(node.order())) continue;
                ctx.killNode(node);
            }
        }
    }

    private static class KillRandomCommunicationFailureResolver
    implements CommunicationFailureResolver {
        static final IgniteOutClosure<CommunicationFailureResolver> FACTORY = KillRandomCommunicationFailureResolver::new;
        static final Set<ClusterNode> LAST_KILLED_NODES = new HashSet<ClusterNode>();
        @LoggerResource
        private IgniteLogger log;

        private KillRandomCommunicationFailureResolver() {
        }

        public void resolve(CommunicationFailureContext ctx) {
            LAST_KILLED_NODES.clear();
            List nodes = ctx.topologySnapshot();
            ThreadLocalRandom rnd = ThreadLocalRandom.current();
            int killNodes = rnd.nextInt(nodes.size() / 2);
            this.log.info("Resolver kills nodes [total=" + nodes.size() + ", kill=" + killNodes + ']');
            long srvCnt = nodes.stream().filter(node -> !node.isClient()).count();
            HashSet<Integer> idxs = new HashSet<Integer>();
            while (idxs.size() < killNodes) {
                int idx = rnd.nextInt(nodes.size());
                if (!((ClusterNode)nodes.get(idx)).isClient() && !idxs.contains(idx) && --srvCnt < 1L) continue;
                idxs.add(idx);
            }
            Iterator iterator = idxs.iterator();
            while (iterator.hasNext()) {
                int idx = (Integer)iterator.next();
                ClusterNode node2 = (ClusterNode)nodes.get(idx);
                this.log.info("Resolver kills node: " + node2.id());
                LAST_KILLED_NODES.add(node2);
                ctx.killNode(node2);
            }
        }
    }

    private static class KillCoordinatorCommunicationFailureResolver
    implements CommunicationFailureResolver {
        static final IgniteOutClosure<CommunicationFailureResolver> FACTORY = KillCoordinatorCommunicationFailureResolver::new;
        @LoggerResource
        private IgniteLogger log;

        private KillCoordinatorCommunicationFailureResolver() {
        }

        public void resolve(CommunicationFailureContext ctx) {
            List nodes = ctx.topologySnapshot();
            ClusterNode node = (ClusterNode)nodes.get(0);
            this.log.info("Resolver kills node: " + node.id());
            ctx.killNode(node);
        }
    }

    private static class NoOpCommunicationFailureResolver
    implements CommunicationFailureResolver {
        static final IgniteOutClosure<CommunicationFailureResolver> FACTORY = NoOpCommunicationFailureResolver::new;

        private NoOpCommunicationFailureResolver() {
        }

        public void resolve(CommunicationFailureContext ctx) {
        }
    }

    private static class CacheInfoCommunicationFailureResolver
    implements CommunicationFailureResolver {
        @LoggerResource
        private IgniteLogger log;
        Map<String, CacheConfiguration<?, ?>> caches;
        Map<String, List<List<ClusterNode>>> affMap;
        Map<String, List<List<ClusterNode>>> ownersMap;
        volatile CountDownLatch latch;

        private CacheInfoCommunicationFailureResolver() {
        }

        public void resolve(CommunicationFailureContext ctx) {
            assert (this.latch != null);
            assert (this.latch.getCount() == 1L) : this.latch.getCount();
            this.caches = ctx.startedCaches();
            this.log.info("Resolver called, started caches: " + this.caches.keySet());
            ZookeeperDiscoveryCommunicationFailureTest.assertNotNull((Object)this.caches);
            this.affMap = new HashMap<String, List<List<ClusterNode>>>();
            this.ownersMap = new HashMap<String, List<List<ClusterNode>>>();
            for (String cache : this.caches.keySet()) {
                this.affMap.put(cache, ctx.cacheAffinity(cache));
                this.ownersMap.put(cache, ctx.cachePartitionOwners(cache));
            }
            this.latch.countDown();
        }

        void checkCachesInfo(Map<String, T3<Integer, Integer, Integer>> expCaches) {
            ZookeeperDiscoveryCommunicationFailureTest.assertNotNull((Object)this.caches);
            ZookeeperDiscoveryCommunicationFailureTest.assertNotNull((Object)this.affMap);
            ZookeeperDiscoveryCommunicationFailureTest.assertNotNull((Object)this.ownersMap);
            for (Map.Entry<String, T3<Integer, Integer, Integer>> e : expCaches.entrySet()) {
                String cacheName = e.getKey();
                int parts = (Integer)e.getValue().get1();
                int backups = (Integer)e.getValue().get2();
                int expNodes = (Integer)e.getValue().get3();
                ZookeeperDiscoveryCommunicationFailureTest.assertTrue((String)cacheName, (boolean)this.caches.containsKey(cacheName));
                CacheConfiguration<?, ?> ccfg = this.caches.get(cacheName);
                ZookeeperDiscoveryCommunicationFailureTest.assertEquals((String)cacheName, (String)ccfg.getName());
                if (ccfg.getCacheMode() == CacheMode.REPLICATED) {
                    ZookeeperDiscoveryCommunicationFailureTest.assertEquals((int)Integer.MAX_VALUE, (int)ccfg.getBackups());
                } else {
                    ZookeeperDiscoveryCommunicationFailureTest.assertEquals((int)backups, (int)ccfg.getBackups());
                }
                ZookeeperDiscoveryCommunicationFailureTest.assertEquals((int)parts, (int)ccfg.getAffinity().partitions());
                List<List<ClusterNode>> aff = this.affMap.get(cacheName);
                ZookeeperDiscoveryCommunicationFailureTest.assertNotNull((String)cacheName, (Object)aff);
                ZookeeperDiscoveryCommunicationFailureTest.assertEquals((int)parts, (int)aff.size());
                List<List<ClusterNode>> owners = this.ownersMap.get(cacheName);
                ZookeeperDiscoveryCommunicationFailureTest.assertNotNull((String)cacheName, (Object)owners);
                ZookeeperDiscoveryCommunicationFailureTest.assertEquals((int)parts, (int)owners.size());
                for (int i = 0; i < parts; ++i) {
                    List<ClusterNode> partAff = aff.get(i);
                    ZookeeperDiscoveryCommunicationFailureTest.assertEquals((String)cacheName, (int)expNodes, (int)partAff.size());
                    List<ClusterNode> partOwners = owners.get(i);
                    ZookeeperDiscoveryCommunicationFailureTest.assertEquals((String)cacheName, (int)expNodes, (int)partOwners.size());
                    ZookeeperDiscoveryCommunicationFailureTest.assertTrue((String)cacheName, (boolean)partAff.containsAll(partOwners));
                    ZookeeperDiscoveryCommunicationFailureTest.assertTrue((String)cacheName, (boolean)partOwners.containsAll(partAff));
                }
            }
        }

        void reset() {
            this.caches = null;
            this.affMap = null;
            this.ownersMap = null;
        }
    }
}

