/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.spi.discovery.zk.internal;

import java.io.Serializable;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.ignite.Ignite;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.util.lang.GridAbsPredicate;
import org.apache.ignite.lang.IgniteInClosure;
import org.apache.ignite.lang.IgnitePredicate;
import org.apache.ignite.spi.discovery.zk.internal.ZookeeperDiscoverySpiTestBase;
import org.apache.ignite.testframework.GridTestUtils;
import org.junit.Test;

public class ZookeeperDiscoveryClientReconnectTest
extends ZookeeperDiscoverySpiTestBase {
    @Test
    public void testReconnectServersRestart_1() throws Exception {
        this.reconnectServersRestart(1);
    }

    @Test
    public void testReconnectServersRestart_2() throws Exception {
        this.reconnectServersRestart(3);
    }

    @Test
    public void testReconnectServersRestart_3() throws Exception {
        this.startGrid(0);
        this.helper.clientMode(true);
        this.startGridsMultiThreaded(5, 5);
        this.stopGrid(this.getTestIgniteInstanceName(0), true, false);
        final int srvIdx = ThreadLocalRandom.current().nextInt(5);
        final AtomicInteger idx = new AtomicInteger();
        this.info("Restart nodes.");
        GridTestUtils.runMultiThreaded((Callable)new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                int threadIdx = idx.getAndIncrement();
                ZookeeperDiscoveryClientReconnectTest.this.helper.clientModeThreadLocal(threadIdx != srvIdx && ThreadLocalRandom.current().nextBoolean());
                ZookeeperDiscoveryClientReconnectTest.this.startGrid(threadIdx);
                return null;
            }
        }, (int)5, (String)"start-node");
        this.waitForTopology(10);
        evts.clear();
    }

    @Test
    public void testReconnectServersRestart_4() throws Exception {
        this.startGrid(0);
        this.helper.clientMode(true);
        IgniteEx client = this.startGrid(1);
        this.helper.clientMode(false);
        CountDownLatch latch = new CountDownLatch(1);
        client.events().localListen((IgnitePredicate & Serializable)event -> {
            latch.countDown();
            return true;
        }, new int[]{16});
        this.waitForTopology(2);
        this.stopGrid(0);
        evts.clear();
        ZookeeperDiscoveryClientReconnectTest.assertTrue((String)"Failed to wait for client node disconnected.", (boolean)latch.await(15L, TimeUnit.SECONDS));
        this.startGrid(0);
        this.stopGrid(0);
        evts.clear();
        this.startGrid(0);
        this.waitForTopology(2);
    }

    private void reconnectServersRestart(int srvs) throws Exception {
        this.sesTimeout = 30000L;
        this.startGridsMultiThreaded(srvs);
        this.helper.clientMode(true);
        int CLIENTS = 10;
        this.startGridsMultiThreaded(srvs, 10);
        this.helper.clientMode(false);
        long stopTime = System.currentTimeMillis() + 30000L;
        ThreadLocalRandom rnd = ThreadLocalRandom.current();
        int NODES = srvs + 10;
        int iter = 0;
        while (System.currentTimeMillis() < stopTime) {
            int restarts = rnd.nextInt(10) + 1;
            this.info("Test iteration [iter=" + iter++ + ", restarts=" + restarts + ']');
            for (int i = 0; i < restarts; ++i) {
                GridTestUtils.runMultiThreaded((IgniteInClosure)new IgniteInClosure<Integer>(){

                    public void apply(Integer threadIdx) {
                        ZookeeperDiscoveryClientReconnectTest.this.stopGrid(ZookeeperDiscoveryClientReconnectTest.this.getTestIgniteInstanceName(threadIdx), true, false);
                    }
                }, (int)srvs, (String)"stop-server");
                this.startGridsMultiThreaded(0, srvs);
            }
            IgniteEx srv = this.ignite(0);
            ZookeeperDiscoveryClientReconnectTest.assertTrue((boolean)GridTestUtils.waitForCondition((GridAbsPredicate)new GridAbsPredicate((Ignite)srv, NODES){
                final /* synthetic */ Ignite val$srv;
                final /* synthetic */ int val$NODES;
                {
                    this.val$srv = ignite;
                    this.val$NODES = n;
                }

                public boolean apply() {
                    return this.val$srv.cluster().nodes().size() == this.val$NODES;
                }
            }, (long)30000L));
            this.waitForTopology(NODES);
            this.awaitPartitionMapExchange();
        }
        evts.clear();
    }
}

