/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.spi.discovery.zk.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.internal.util.typedef.G;
import org.apache.ignite.spi.discovery.zk.internal.ZookeeperDiscoverySpiTestBase;
import org.junit.Assert;
import org.junit.Test;

public class ZookeeperDiscoverySplitBrainTest
extends ZookeeperDiscoverySpiTestBase {
    @Test
    public void testSimpleSplitBrain() throws Exception {
        this.failCommSpi = true;
        this.startGridsMultiThreaded(5);
        this.helper.clientMode(true);
        this.startGridsMultiThreaded(5, 3);
        this.helper.clientMode(false);
        this.awaitPartitionMapExchange();
        List all = G.allGrids().stream().map(g -> g.cluster().localNode()).collect(Collectors.toList());
        List<ClusterNode> part1 = all.subList(0, 3);
        List<ClusterNode> part2 = all.subList(3, all.size());
        ConnectionsFailureMatrix matrix = ConnectionsFailureMatrix.buildFrom(part1, part2);
        ClusterNode lastClient = this.startGrid(8).cluster().localNode();
        this.awaitPartitionMapExchange();
        for (ClusterNode node : all) {
            if (node.id().equals(lastClient.id())) continue;
            matrix.addConnection(lastClient, node);
            matrix.addConnection(node, lastClient);
        }
        ZookeeperDiscoverySpiTestBase.PeerToPeerCommunicationFailureSpi.fail(matrix);
        this.waitForTopology(4);
    }

    @Test
    public void testNotActualSplitBrain() throws Exception {
        this.failCommSpi = true;
        this.startGridsMultiThreaded(5);
        List srvNodes = G.allGrids().stream().map(g -> g.cluster().localNode()).collect(Collectors.toList());
        Assert.assertEquals((long)5L, (long)srvNodes.size());
        this.helper.clientMode(true);
        this.startGridsMultiThreaded(5, 3);
        this.helper.clientMode(false);
        this.awaitPartitionMapExchange();
        ConnectionsFailureMatrix matrix = new ConnectionsFailureMatrix();
        List<ClusterNode> allNodes = G.allGrids().stream().map(g -> g.cluster().localNode()).collect(Collectors.toList());
        matrix.addAll(allNodes);
        matrix.removeConnection((ClusterNode)srvNodes.get(0), (ClusterNode)srvNodes.get(1));
        matrix.removeConnection((ClusterNode)srvNodes.get(1), (ClusterNode)srvNodes.get(0));
        matrix.removeConnection((ClusterNode)srvNodes.get(2), (ClusterNode)srvNodes.get(3));
        matrix.removeConnection((ClusterNode)srvNodes.get(3), (ClusterNode)srvNodes.get(2));
        ZookeeperDiscoverySpiTestBase.PeerToPeerCommunicationFailureSpi.fail(matrix);
        this.waitForTopology(8);
    }

    @Test
    public void testAlmostSplitBrain() throws Exception {
        this.failCommSpi = true;
        this.startGridsMultiThreaded(6);
        List srvNodes = G.allGrids().stream().map(g -> g.cluster().localNode()).collect(Collectors.toList());
        Assert.assertEquals((long)6L, (long)srvNodes.size());
        List srvPart1 = srvNodes.subList(0, 3);
        List srvPart2 = srvNodes.subList(3, srvNodes.size());
        this.helper.clientMode(true);
        this.startGridsMultiThreaded(6, 5);
        this.helper.clientMode(false);
        this.awaitPartitionMapExchange();
        List clientNodes = G.allGrids().stream().map(g -> g.cluster().localNode()).filter(ClusterNode::isClient).collect(Collectors.toList());
        Assert.assertEquals((long)5L, (long)clientNodes.size());
        List clientPart1 = clientNodes.subList(0, 2);
        List clientPart2 = clientNodes.subList(2, 4);
        ArrayList<ClusterNode> splittedPart1 = new ArrayList<ClusterNode>();
        splittedPart1.addAll(srvPart1);
        splittedPart1.addAll(clientPart1);
        ArrayList<ClusterNode> splittedPart2 = new ArrayList<ClusterNode>();
        splittedPart2.addAll(srvPart2);
        splittedPart2.addAll(clientPart2);
        ConnectionsFailureMatrix matrix = new ConnectionsFailureMatrix();
        matrix.addAll(splittedPart1);
        matrix.addAll(splittedPart2);
        matrix.addConnection((ClusterNode)srvPart1.get(0), (ClusterNode)srvPart2.get(1));
        matrix.addConnection((ClusterNode)srvPart2.get(1), (ClusterNode)srvPart1.get(0));
        matrix.addConnection((ClusterNode)srvPart1.get(1), (ClusterNode)srvPart2.get(2));
        matrix.addConnection((ClusterNode)srvPart2.get(2), (ClusterNode)srvPart1.get(1));
        matrix.addConnection((ClusterNode)srvPart1.get(2), (ClusterNode)srvPart2.get(0));
        matrix.addConnection((ClusterNode)srvPart2.get(0), (ClusterNode)srvPart1.get(2));
        ZookeeperDiscoverySpiTestBase.PeerToPeerCommunicationFailureSpi.fail(matrix);
        this.waitForTopology(5);
    }

    static class ConnectionsFailureMatrix {
        private Map<UUID, Set<UUID>> availableConnections = new HashMap<UUID, Set<UUID>>();

        ConnectionsFailureMatrix() {
        }

        public boolean hasConnection(ClusterNode from, ClusterNode to) {
            return this.availableConnections.getOrDefault(from.id(), Collections.emptySet()).contains(to.id());
        }

        public void addConnection(ClusterNode from, ClusterNode to) {
            this.availableConnections.computeIfAbsent(from.id(), s -> new HashSet()).add(to.id());
        }

        public void removeConnection(ClusterNode from, ClusterNode to) {
            this.availableConnections.getOrDefault(from.id(), Collections.emptySet()).remove(to.id());
        }

        public void addAll(List<ClusterNode> nodeSet) {
            for (int i = 0; i < nodeSet.size(); ++i) {
                for (int j = 0; j < nodeSet.size(); ++j) {
                    if (i == j) continue;
                    this.addConnection(nodeSet.get(i), nodeSet.get(j));
                }
            }
        }

        static ConnectionsFailureMatrix buildFrom(List<ClusterNode> part1, List<ClusterNode> part2) {
            ConnectionsFailureMatrix matrix = new ConnectionsFailureMatrix();
            matrix.addAll(part1);
            matrix.addAll(part2);
            return matrix;
        }
    }
}

