/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.spi.discovery.zk;

import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.curator.test.TestingCluster;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.spi.discovery.DiscoverySpi;
import org.apache.ignite.spi.discovery.tcp.TcpDiscoverySpi;
import org.apache.ignite.spi.discovery.zk.ZookeeperDiscoverySpi;
import org.apache.ignite.spi.discovery.zk.ZookeeperDiscoverySpiTestUtil;

public class ZookeeperDiscoverySpiTestConfigurator {
    private static final Lock lock = new ReentrantLock();
    private static TestingCluster testingCluster;

    public static void initTestSuite() throws Exception {
        System.setProperty("H2_JDBC_CONNECTIONS", "500");
        System.setProperty("zookeeper.forceSync", "false");
        lock.lock();
        try {
            testingCluster = ZookeeperDiscoverySpiTestUtil.createTestingCluster(3);
            testingCluster.start();
        }
        finally {
            lock.unlock();
        }
        System.setProperty("ignite.cfg.preprocessor.class", ZookeeperDiscoverySpiTestConfigurator.class.getName());
    }

    public static void preprocessConfiguration(IgniteConfiguration cfg) {
        lock.lock();
        try {
            if (testingCluster == null) {
                throw new IllegalStateException("Test Zookeeper cluster is not started.");
            }
            ZookeeperDiscoverySpi zkSpi = new ZookeeperDiscoverySpi();
            DiscoverySpi spi = cfg.getDiscoverySpi();
            if (spi instanceof TcpDiscoverySpi) {
                zkSpi.setClientReconnectDisabled(((TcpDiscoverySpi)spi).isClientReconnectDisabled());
            }
            zkSpi.setSessionTimeout(30000L);
            zkSpi.setZkConnectionString(testingCluster.getConnectString());
            cfg.setDiscoverySpi((DiscoverySpi)zkSpi);
        }
        finally {
            lock.unlock();
        }
    }
}

