/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.channels.SelectionKey;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.logger.java.JavaLogger;
import org.apache.ignite.testframework.GridTestUtils;
import org.apache.zookeeper.ClientCnxnSocketNIO;
import org.apache.zookeeper.client.ZKClientConfig;

public class ZkTestClientCnxnSocketNIO
extends ClientCnxnSocketNIO {
    public static final IgniteLogger log = new JavaLogger().getLogger(ZkTestClientCnxnSocketNIO.class);
    public static volatile boolean DEBUG = false;
    public volatile CountDownLatch blockConnectLatch;
    public static ConcurrentHashMap<String, ZkTestClientCnxnSocketNIO> clients = new ConcurrentHashMap();
    private final String nodeName;

    public static void reset() {
        clients.clear();
    }

    public static ZkTestClientCnxnSocketNIO forNode(Ignite node) {
        return clients.get(node.name());
    }

    public static ZkTestClientCnxnSocketNIO forNode(String instanceName) {
        return clients.get(instanceName);
    }

    public ZkTestClientCnxnSocketNIO(ZKClientConfig clientCfg) throws IOException {
        super(clientCfg);
        String threadName = Thread.currentThread().getName();
        this.nodeName = threadName.substring(threadName.indexOf(45) + 1);
        if (DEBUG) {
            log.info("ZkTestClientCnxnSocketNIO created for node: " + this.nodeName);
        }
    }

    void connect(InetSocketAddress addr) throws IOException {
        CountDownLatch blockConnect = this.blockConnectLatch;
        if (DEBUG) {
            log.info("ZkTestClientCnxnSocketNIO connect [node=" + this.nodeName + ", addr=" + addr + ']');
        }
        if (blockConnect != null && blockConnect.getCount() > 0L) {
            try {
                log.info("ZkTestClientCnxnSocketNIO block connect");
                blockConnect.await(60L, TimeUnit.SECONDS);
                log.info("ZkTestClientCnxnSocketNIO finish block connect");
            }
            catch (Exception e) {
                log.error("Error in ZkTestClientCnxnSocketNIO: " + e, (Throwable)e);
            }
        }
        super.connect(addr);
        clients.put(this.nodeName, this);
    }

    public void allowConnect() {
        assert (this.blockConnectLatch != null && this.blockConnectLatch.getCount() == 1L) : this.blockConnectLatch;
        log.info("ZkTestClientCnxnSocketNIO allowConnect [node=" + this.nodeName + ']');
        this.blockConnectLatch.countDown();
    }

    public void closeSocket(boolean blockConnect) throws Exception {
        if (blockConnect) {
            this.blockConnectLatch = new CountDownLatch(1);
        }
        log.info("ZkTestClientCnxnSocketNIO closeSocket [node=" + this.nodeName + ", block=" + blockConnect + ']');
        SelectionKey k = (SelectionKey)GridTestUtils.getFieldValue((Object)((Object)this), ClientCnxnSocketNIO.class, (String)"sockKey");
        k.channel().close();
    }
}

