/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.spi.discovery.zk.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.ignite.Ignite;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.IgniteKernal;
import org.apache.ignite.internal.managers.discovery.CustomEventListener;
import org.apache.ignite.internal.managers.discovery.DiscoCache;
import org.apache.ignite.internal.managers.discovery.DiscoveryCustomMessage;
import org.apache.ignite.internal.managers.discovery.GridDiscoveryManager;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.util.lang.GridAbsPredicate;
import org.apache.ignite.internal.util.typedef.G;
import org.apache.ignite.internal.util.typedef.T3;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.lang.IgniteUuid;
import org.apache.ignite.spi.discovery.zk.internal.ZookeeperDiscoverySpiTestBase;
import org.apache.ignite.spi.discovery.zk.internal.ZookeeperDiscoverySpiTestHelper;
import org.apache.ignite.testframework.GridTestUtils;
import org.jetbrains.annotations.Nullable;
import org.junit.Test;

public class ZookeeperDiscoveryCustomEventsTest
extends ZookeeperDiscoverySpiTestBase {
    @Test
    public void testCustomEventsSimple1_SingleNode() throws Exception {
        ZookeeperDiscoverySpiTestHelper.ackEveryEventSystemProperty();
        IgniteEx srv0 = this.startGrid(0);
        srv0.createCache(new CacheConfiguration("c1"));
        this.helper.waitForEventsAcks((Ignite)srv0);
    }

    @Test
    public void testCustomEventsSimple1_5_Nodes() throws Exception {
        ZookeeperDiscoverySpiTestHelper.ackEveryEventSystemProperty();
        IgniteEx srv0 = this.startGrids(5);
        srv0.createCache(new CacheConfiguration("c1"));
        this.awaitPartitionMapExchange();
        this.helper.waitForEventsAcks((Ignite)srv0);
    }

    @Test
    public void testCustomEvents_FastStopProcess_1() throws Exception {
        this.customEvents_FastStopProcess(1, 0);
    }

    @Test
    public void testCustomEvents_FastStopProcess_2() throws Exception {
        this.customEvents_FastStopProcess(5, 5);
    }

    private void customEvents_FastStopProcess(int srvs, int clients) throws Exception {
        ZookeeperDiscoverySpiTestHelper.ackEveryEventSystemProperty();
        ConcurrentHashMap<UUID, List<T3<AffinityTopologyVersion, UUID, DiscoveryCustomMessage>>> rcvdMsgs = new ConcurrentHashMap<UUID, List<T3<AffinityTopologyVersion, UUID, DiscoveryCustomMessage>>>();
        IgniteEx crd = this.startGrid(0);
        UUID crdId = crd.cluster().localNode().id();
        if (srvs > 1) {
            this.startGridsMultiThreaded(1, srvs - 1);
        }
        if (clients > 0) {
            this.helper.clientMode(true);
            this.startGridsMultiThreaded(srvs, clients);
        }
        this.awaitPartitionMapExchange();
        List nodes = G.allGrids();
        ZookeeperDiscoveryCustomEventsTest.assertEquals((int)(srvs + clients), (int)nodes.size());
        for (Ignite node : nodes) {
            this.registerTestEventListeners(node, rcvdMsgs);
        }
        int payload = 0;
        AffinityTopologyVersion topVer = ((IgniteKernal)crd).context().discovery().topologyVersionEx();
        for (Ignite node : nodes) {
            UUID sndId = node.cluster().localNode().id();
            this.info("Send from node: " + sndId);
            GridDiscoveryManager discoveryMgr = ((IgniteKernal)node).context().discovery();
            ArrayList<Object> expCrdMsgs = new ArrayList<T3<AffinityTopologyVersion, UUID, DiscoveryCustomMessage>>();
            List<T3<AffinityTopologyVersion, UUID, DiscoveryCustomMessage>> expNodesMsgs = Collections.emptyList();
            TestFastStopProcessCustomMessage msg = new TestFastStopProcessCustomMessage(false, payload++);
            expCrdMsgs.add(new T3((Object)topVer, (Object)sndId, (Object)msg));
            discoveryMgr.sendCustomEvent((DiscoveryCustomMessage)msg);
            ZookeeperDiscoveryCustomEventsTest.doSleep((long)200L);
            this.checkEvents((Ignite)crd, rcvdMsgs, expCrdMsgs);
            for (Ignite node0 : nodes) {
                if (node0 == crd) continue;
                this.checkEvents(node0, rcvdMsgs, expNodesMsgs);
            }
            rcvdMsgs.clear();
            expCrdMsgs = new ArrayList();
            expNodesMsgs = new ArrayList();
            msg = new TestFastStopProcessCustomMessage(true, payload++);
            expCrdMsgs.add((T3<AffinityTopologyVersion, UUID, DiscoveryCustomMessage>)new T3((Object)topVer, (Object)sndId, (Object)msg));
            discoveryMgr.sendCustomEvent((DiscoveryCustomMessage)msg);
            TestFastStopProcessCustomMessageAck ackMsg = new TestFastStopProcessCustomMessageAck(msg.payload);
            expCrdMsgs.add(new T3((Object)topVer, (Object)crdId, (Object)ackMsg));
            expNodesMsgs.add((T3<AffinityTopologyVersion, UUID, DiscoveryCustomMessage>)new T3((Object)topVer, (Object)crdId, (Object)ackMsg));
            ZookeeperDiscoveryCustomEventsTest.doSleep((long)200L);
            this.checkEvents((Ignite)crd, rcvdMsgs, expCrdMsgs);
            for (Ignite node0 : nodes) {
                if (node0 == crd) continue;
                this.checkEvents(node0, rcvdMsgs, expNodesMsgs);
            }
            rcvdMsgs.clear();
            this.helper.waitForEventsAcks((Ignite)crd);
        }
    }

    private void checkEvents(Ignite node, final Map<UUID, List<T3<AffinityTopologyVersion, UUID, DiscoveryCustomMessage>>> rcvdMsgs, final List<T3<AffinityTopologyVersion, UUID, DiscoveryCustomMessage>> expMsgs) throws Exception {
        final UUID nodeId = node.cluster().localNode().id();
        ZookeeperDiscoveryCustomEventsTest.assertTrue((boolean)GridTestUtils.waitForCondition((GridAbsPredicate)new GridAbsPredicate(){

            public boolean apply() {
                List msgs = (List)rcvdMsgs.get(nodeId);
                int size = msgs == null ? 0 : msgs.size();
                return size >= expMsgs.size();
            }
        }, (long)5000L));
        List<Object> msgs = rcvdMsgs.get(nodeId);
        if (msgs == null) {
            msgs = Collections.emptyList();
        }
        ZookeeperDiscoveryCustomEventsTest.assertEqualsCollections(expMsgs, msgs);
    }

    private void registerTestEventListeners(Ignite node, final Map<UUID, List<T3<AffinityTopologyVersion, UUID, DiscoveryCustomMessage>>> rcvdMsgs) {
        GridDiscoveryManager discoveryMgr = ((IgniteKernal)node).context().discovery();
        final UUID nodeId = node.cluster().localNode().id();
        discoveryMgr.setCustomEventListener(TestFastStopProcessCustomMessage.class, (CustomEventListener)new CustomEventListener<TestFastStopProcessCustomMessage>(){

            public void onCustomEvent(AffinityTopologyVersion topVer, ClusterNode snd, TestFastStopProcessCustomMessage msg) {
                ArrayList<T3> list = (ArrayList<T3>)rcvdMsgs.get(nodeId);
                if (list == null) {
                    list = new ArrayList<T3>();
                    rcvdMsgs.put(nodeId, list);
                }
                list.add(new T3((Object)topVer, (Object)snd.id(), (Object)msg));
            }
        });
        discoveryMgr.setCustomEventListener(TestFastStopProcessCustomMessageAck.class, (CustomEventListener)new CustomEventListener<TestFastStopProcessCustomMessageAck>(){

            public void onCustomEvent(AffinityTopologyVersion topVer, ClusterNode snd, TestFastStopProcessCustomMessageAck msg) {
                ArrayList<T3> list = (ArrayList<T3>)rcvdMsgs.get(nodeId);
                if (list == null) {
                    list = new ArrayList<T3>();
                    rcvdMsgs.put(nodeId, list);
                }
                list.add(new T3((Object)topVer, (Object)snd.id(), (Object)msg));
            }
        });
    }

    private static class TestFastStopProcessCustomMessageAck
    implements DiscoveryCustomMessage {
        private static final long serialVersionUID = 0L;
        private final IgniteUuid id = IgniteUuid.randomUuid();
        private final int payload;

        TestFastStopProcessCustomMessageAck(int payload) {
            this.payload = payload;
        }

        public IgniteUuid id() {
            return this.id;
        }

        @Nullable
        public DiscoveryCustomMessage ackMessage() {
            return null;
        }

        public boolean isMutable() {
            return false;
        }

        public boolean stopProcess() {
            return true;
        }

        public DiscoCache createDiscoCache(GridDiscoveryManager mgr, AffinityTopologyVersion topVer, DiscoCache discoCache) {
            throw new UnsupportedOperationException();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TestFastStopProcessCustomMessageAck that = (TestFastStopProcessCustomMessageAck)o;
            return this.payload == that.payload;
        }

        public int hashCode() {
            return Objects.hash(this.payload);
        }

        public String toString() {
            return S.toString(TestFastStopProcessCustomMessageAck.class, (Object)this);
        }
    }

    private static class TestFastStopProcessCustomMessage
    implements DiscoveryCustomMessage {
        private static final long serialVersionUID = 0L;
        private final IgniteUuid id = IgniteUuid.randomUuid();
        private final boolean createAck;
        private final int payload;

        TestFastStopProcessCustomMessage(boolean createAck, int payload) {
            this.createAck = createAck;
            this.payload = payload;
        }

        public IgniteUuid id() {
            return this.id;
        }

        @Nullable
        public DiscoveryCustomMessage ackMessage() {
            return this.createAck ? new TestFastStopProcessCustomMessageAck(this.payload) : null;
        }

        public boolean isMutable() {
            return false;
        }

        public boolean stopProcess() {
            return true;
        }

        public DiscoCache createDiscoCache(GridDiscoveryManager mgr, AffinityTopologyVersion topVer, DiscoCache discoCache) {
            throw new UnsupportedOperationException();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TestFastStopProcessCustomMessage that = (TestFastStopProcessCustomMessage)o;
            return this.createAck == that.createAck && this.payload == that.payload;
        }

        public int hashCode() {
            return Objects.hash(this.createAck, this.payload);
        }

        public String toString() {
            return S.toString(TestFastStopProcessCustomMessage.class, (Object)this);
        }
    }
}

