/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.spi.discovery.zk;

import java.util.List;
import org.apache.ignite.Ignite;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.util.typedef.G;
import org.apache.ignite.spi.discovery.DiscoverySpi;
import org.apache.ignite.spi.discovery.tcp.TcpDiscoverySpi;
import org.apache.ignite.spi.discovery.tcp.ipfinder.TcpDiscoveryIpFinder;
import org.apache.ignite.spi.discovery.tcp.ipfinder.vm.TcpDiscoveryVmIpFinder;
import org.apache.ignite.spi.discovery.zk.ZookeeperDiscoverySpi;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;
import org.junit.Test;

public class ZookeeperDiscoverySuitePreprocessorTest
extends GridCommonAbstractTest {
    private static final TcpDiscoveryIpFinder IP_FINDER = new TcpDiscoveryVmIpFinder(true);

    protected IgniteConfiguration getConfiguration(String igniteInstanceName) throws Exception {
        IgniteConfiguration cfg = super.getConfiguration(igniteInstanceName);
        TcpDiscoverySpi spi = new TcpDiscoverySpi();
        spi.setIpFinder(IP_FINDER);
        cfg.setDiscoverySpi((DiscoverySpi)spi);
        return cfg;
    }

    protected void afterTest() throws Exception {
        this.stopAllGrids();
        super.afterTest();
    }

    @Test
    public void testSpiConfigurationIsChanged() throws Exception {
        this.startGrid(0);
        this.checkDiscoverySpi(1);
        this.startGrid(1);
        this.checkDiscoverySpi(2);
        this.startGridsMultiThreaded(2, 2);
        this.checkDiscoverySpi(4);
        this.startGrid();
        this.checkDiscoverySpi(5);
    }

    private void checkDiscoverySpi(int expNodes) throws Exception {
        List nodes = G.allGrids();
        ZookeeperDiscoverySuitePreprocessorTest.assertEquals((int)expNodes, (int)nodes.size());
        for (Ignite node : nodes) {
            DiscoverySpi spi = node.configuration().getDiscoverySpi();
            ZookeeperDiscoverySuitePreprocessorTest.assertTrue((String)("Node should be started with " + ZookeeperDiscoverySpi.class.getName()), (boolean)(spi instanceof ZookeeperDiscoverySpi));
        }
        this.waitForTopology(expNodes);
    }
}

