/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.worker;

import org.apache.ignite.internal.lang.IgniteSystemProperties;
import org.apache.ignite.internal.logger.IgniteLogger;
import org.apache.ignite.internal.logger.Loggers;
import org.apache.ignite.internal.thread.PublicApiThreading;
import org.apache.ignite.internal.thread.ThreadAttributes;
import org.apache.ignite.internal.thread.ThreadOperation;

public class ThreadAssertions {
    private static final IgniteLogger LOG = Loggers.forClass(ThreadAssertions.class);

    public static boolean enabled() {
        return IgniteSystemProperties.getBoolean((String)"IGNITE_THREAD_ASSERTIONS_ENABLED", (boolean)false);
    }

    public static void assertThreadAllowsToWrite() {
        ThreadAssertions.assertThreadAllowsTo(ThreadOperation.STORAGE_WRITE);
    }

    public static void assertThreadAllowsToRead() {
        ThreadAssertions.assertThreadAllowsTo(ThreadOperation.STORAGE_READ);
    }

    public static void assertThreadAllowsTo(ThreadOperation requestedOperation) {
        Thread currentThread = Thread.currentThread();
        if (!(currentThread instanceof ThreadAttributes)) {
            if (PublicApiThreading.executingSyncPublicApi()) {
                return;
            }
            AssertionError error = new AssertionError((Object)("Thread " + currentThread.getName() + " does not have allowed operations"));
            if (ThreadAssertions.logBeforeThrowing()) {
                LOG.warn("Thread {} does not have allowed operations", (Throwable)((Object)error), new Object[]{currentThread});
            }
            throw error;
        }
        if (!((ThreadAttributes)currentThread).allows(requestedOperation)) {
            AssertionError error = new AssertionError((Object)("Thread " + currentThread.getName() + " is not allowed to do " + requestedOperation));
            if (ThreadAssertions.logBeforeThrowing()) {
                LOG.warn("Thread {} is not allowed to do {}", (Throwable)((Object)error), new Object[]{currentThread, requestedOperation});
            }
            throw error;
        }
    }

    private static boolean logBeforeThrowing() {
        return IgniteSystemProperties.getBoolean((String)"THREAD_ASSERTIONS_LOG_BEFORE_THROWING", (boolean)true);
    }
}

